/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model.stats;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.json.DurationLongDeserializerCodehaus;
import com.atlassian.migration.json.DurationLongDeserializerFasterXml;
import com.atlassian.migration.json.DurationLongSerializerCodehaus;
import com.atlassian.migration.json.DurationLongSerializerFasterXml;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ParametersAreNonnullByDefault
public final class GlobalEntitiesStats {
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final long numberOfGlobalPageTemplates;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final long numberOfEditedSystemTemplates;
    @org.codehaus.jackson.map.annotate.JsonSerialize(using=DurationLongSerializerCodehaus.class)
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=DurationLongDeserializerFasterXml.class)
    @JsonDeserialize(using=DurationLongDeserializerCodehaus.class)
    @JsonSerialize(using=DurationLongSerializerFasterXml.class)
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private final Duration totalMigrationTime;

    @JsonCreator
    @com.fasterxml.jackson.annotation.JsonCreator
    public GlobalEntitiesStats(@org.codehaus.jackson.annotate.JsonProperty(value="numberOfGlobalEntities") @JsonProperty(value="numberOfGlobalEntities") long numberOfGlobalPageTemplates, @org.codehaus.jackson.annotate.JsonProperty(value="numberOfEditedSystemTemplates") @JsonProperty(value="numberOfEditedSystemTemplates") long numberOfEditedSystemTemplates) {
        this.numberOfGlobalPageTemplates = numberOfGlobalPageTemplates;
        this.numberOfEditedSystemTemplates = numberOfEditedSystemTemplates;
        this.totalMigrationTime = MigrationTimeEstimationUtils.estimateGlobalEntitiesMigrationTime(this.numberOfGlobalPageTemplates + this.numberOfEditedSystemTemplates);
    }

    public long getNumberOfGlobalPageTemplates() {
        return this.numberOfGlobalPageTemplates;
    }

    public Duration getTotalMigrationTime() {
        return this.totalMigrationTime;
    }

    public long getNumberOfEditedSystemTemplates() {
        return this.numberOfEditedSystemTemplates;
    }
}

