/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.media.MediaClientTokenSupplier;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CachedMediaClientTokenSupplier
implements MediaClientTokenSupplier {
    private static final String CACHE_NAME = "com.atlassian.migration.agent.mediaClientTokenCache";
    private static final Duration DEFAULT_MEDIA_TOKEN_CACHE_EXPIRY_TTL = Duration.ofMinutes(8L);
    @VisibleForTesting
    static final Duration DEFAULT_MEDIA_TOKEN_TTL = Duration.ofMinutes(15L);
    private final Cache<String, String> clientTokens;

    public CachedMediaClientTokenSupplier(final ConfluenceCloudService confluenceCloudService, CacheManager cacheManager) {
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateViaCopy().expireAfterWrite(DEFAULT_MEDIA_TOKEN_CACHE_EXPIRY_TTL.toMillis(), TimeUnit.MILLISECONDS).build();
        CacheLoader<String, String> cacheLoader = new CacheLoader<String, String>(){

            @NotNull
            public String load(@NotNull String cloudId) {
                return Jsons.valueAsString(confluenceCloudService.getMediaClientToken(cloudId, DEFAULT_MEDIA_TOKEN_TTL));
            }
        };
        this.clientTokens = cacheManager.getCache(CACHE_NAME, (CacheLoader)cacheLoader, cacheSettings);
        this.clientTokens.removeAll();
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public MediaClientToken getToken(String cloudId) {
        try {
            return Objects.requireNonNull(Jsons.readValue((String)this.clientTokens.get((Object)cloudId), MediaClientToken.class));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load media token for cloudId: " + cloudId, e);
        }
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public MediaClientToken getRefreshedToken(String cloudId) {
        this.clientTokens.remove((Object)cloudId);
        return this.getToken(cloudId);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void destroy() {
        this.clientTokens.removeAll();
    }
}

