/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.dto;

import com.atlassian.migration.agent.dto.util.ConcurrencyOverrideGroup;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum ConcurrencySettingsEnum {
    SPACE_USERS_CONCURRENCY_MAX(2),
    SPACE_USERS_CONCURRENCY_NODE_MAX(2),
    ATTACHMENT_CONCURRENCY_CLUSTER_MAX(1),
    ATTACHMENT_CONCURRENCY_NODE_MAX(1),
    EXPORT_CONCURRENCY_CLUSTER_MAX(1),
    EXPORT_CONCURRENCY_NODE_MAX(1),
    IMPORT_CONCURRENCY_CLUSTER_MAX(4),
    IMPORT_CONCURRENCY_NODE_MAX(4),
    UPLOAD_CONCURRENCY_CLUSTER_MAX(2),
    UPLOAD_CONCURRENCY_NODE_MAX(2),
    ATTACHMENT_UPLOAD_CONCURRENCY(5);

    @Generated
    private static final Logger log;
    private final int defaultConcurrency;

    private ConcurrencySettingsEnum(int defaultConcurrency) {
        this.defaultConcurrency = defaultConcurrency;
    }

    public static Map<ConcurrencySettingsEnum, Integer> getDefaultMap() {
        return ConcurrencyHelper.getDefaultDistribution();
    }

    public static Map<ConcurrencySettingsEnum, Integer> getEffectiveMapWithOverrides(ConcurrencyOverrideGroup overrideGroup) {
        Map<ConcurrencySettingsEnum, Integer> result = ConcurrencySettingsEnum.getDefaultMap();
        try {
            ConcurrencySettingsEnum.applyOverrideValues(result, overrideGroup);
        }
        catch (Exception ignored) {
            log.error("Exception occurred", (Throwable)ignored);
        }
        log.info("Updated concurrency map: {}", result);
        return result;
    }

    private static void applyOverrideValues(Map<ConcurrencySettingsEnum, Integer> result, ConcurrencyOverrideGroup overrideGroup) {
        List<Double> overrideValues = overrideGroup.getConcurrencies();
        List<ConcurrencySettingsEnum> keys = overrideGroup.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (overrideValues == null || i >= overrideValues.size() || overrideValues.get(i) == null) continue;
            ConcurrencySettingsEnum key = keys.get(i);
            int overrideValue = overrideValues.get(i).intValue();
            int currentValue = result.getOrDefault((Object)key, 0);
            result.put(key, Math.max(currentValue, overrideValue));
        }
    }

    @Generated
    public int getDefaultConcurrency() {
        return this.defaultConcurrency;
    }

    static {
        log = LoggerFactory.getLogger(ConcurrencySettingsEnum.class);
    }
}

