/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.common;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.google.common.util.concurrent.RateLimiter;
import io.atlassian.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;

public class MediaRateLimiter {
    private static final Logger log = ContextLoggerFactory.getLogger(MediaRateLimiter.class);
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final ClusterInformationService clusterInformationService;
    private final AtomicReference<RateLimiter> rateLimiter = new AtomicReference(null);

    @Inject
    @jakarta.inject.Inject
    public MediaRateLimiter(MigrationDarkFeaturesManager darkFeaturesManager, ClusterInformationService clusterInformationService) {
        this.darkFeaturesManager = darkFeaturesManager;
        this.clusterInformationService = clusterInformationService;
    }

    private double getPerSecondRateLimit() {
        double rateLimit = this.darkFeaturesManager.getMediaPerMinuteStableRateLimit() / (60.0 * (double)this.clusterInformationService.getAllNodeIds().size());
        log.info("Rate limit set to: {} RPS", (Object)rateLimit);
        return rateLimit;
    }

    public RateLimiter get() {
        return (RateLimiter)this.rateLimiter.getOrSetAndGetIf(null, () -> RateLimiter.create((double)this.getPerSecondRateLimit(), (long)((long)this.darkFeaturesManager.getMediaRateLimitRampUpTimeInSeconds()), (TimeUnit)TimeUnit.SECONDS));
    }

    public void reset() {
        this.rateLimiter.updateAndGet(old -> null);
    }
}

