/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.SpaceAttachmentsOnlyTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AttachmentUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class AttachmentUploadWorker
extends V4Worker<AttachmentUploadTransferTask> {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentUploadWorker.class);
    @Autowired
    private final AttachmentMigrationExecutor attachmentMigrationExecutor;
    @Autowired
    private final SpaceManager spaceManager;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private AttachmentUploadTransferTask task;

    public AttachmentUploadWorker(List<ProgressUnit> supportedUnits, AttachmentMigrationExecutor attachmentMigrationExecutor, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, SpaceManager spaceManager, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.attachmentMigrationExecutor = attachmentMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
        this.commandName = CommandName.CONFLUENCE_ATTACHMENT_UPLOAD;
        this.spaceManager = spaceManager;
    }

    @Override
    public void process(PrcTask<AttachmentUploadTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.ATTACHMENT_UPLOAD.name());
        V4LogContext logContext = V4LogContext.builder().stepId(prcStep.getId()).prcTaskId(prcTask.getTransferTask().getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(prcStep.getNodeExecutionId()).executionState(prcStep.getNodeExecutionId()).build();
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        this.v4Logger.logInfo(log, logContext, "Step updated successfully for task");
        AttachmentUploadProcessor processor = new AttachmentUploadProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.attachmentMigrationExecutor, this.migrationLogService, this.v4Logger, this.clusterInformationService);
        processor.initiate();
        this.v4Logger.logInfo(log, logContext, "Attachment upload process initiated for task");
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<AttachmentUploadTransferTask> prcTask) {
        String spaceKey = Objects.requireNonNull(this.spaceManager.getSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId()))).getKey();
        V4LogContext logContext = V4LogContext.builder().prcTaskId(prcTask.getTransferTask().getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties("spaceKey", spaceKey);
        if (this.isAttachmentOnlyMigration(tasks)) {
            this.v4Logger.logInfo(log, logContext, "Attachment Only Migration");
            return this.getAttachmentOnlyMigrationTask(tasks, spaceKey);
        }
        this.v4Logger.logInfo(log, logContext, "Not an attachment only migration");
        return this.getSpaceTask(tasks, spaceKey);
    }

    private boolean isAttachmentOnlyMigration(List<Task> tasks) {
        return tasks.stream().anyMatch(SpaceAttachmentsOnlyTask.class::isInstance);
    }

    private Task getSpaceTask(List<Task> tasks, String spaceKey) {
        return tasks.stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    private Task getAttachmentOnlyMigrationTask(List<Task> tasks, String spaceKey) {
        return tasks.stream().filter(SpaceAttachmentsOnlyTask.class::isInstance).map(SpaceAttachmentsOnlyTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        AbstractSpaceTask task = (AbstractSpaceTask)step.getTask();
        step.setConfig(task.getSpaceKey());
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_ATTACHMENT_UPLOAD;
    }
}

