/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.service.impl.ConcurrencyLimitItem;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV2Limits;

public class ConcurrencyV4Limits
implements ConcurrencyLimits {
    private static final int MINIMUM_THRESHOLD = 1;
    private static final int MINIMUM_ATTACHMENT_THRESHOLD = 5;
    public static final int DEFAULT_ATTACHMENT_MIGRATION_CONCURRENCY = 2;
    public static final int DEFAULT_UPLOAD_CONCURRENCY = 4;
    public static final int DEFAULT_IMPORT_CONCURRENCY = 2;
    public static final int DEFAULT_EXPORT_CONCURRENCY = 2;
    public static final double ENVIRONMENT_USAGE_LIMIT = 0.9;
    private final ConcurrencyLimits template = new ConcurrencyV2Limits();
    private final int numOfNodes;
    private final int numOfCPU;

    public ConcurrencyV4Limits(int numOfNodes, int numOfCPU) {
        this.numOfNodes = numOfNodes;
        this.numOfCPU = numOfCPU;
    }

    @Override
    public ConcurrencyLimitItem getAttachmentClusterMaxLimit() {
        Double upperLimit = (double)(this.numOfCPU * this.numOfNodes) * 0.9;
        return new ConcurrencyLimitItem(this.numOfNodes, ((Number)upperLimit).intValue());
    }

    @Override
    public ConcurrencyLimitItem getAttachmentNodeMaxLimit() {
        return new ConcurrencyLimitItem(5, Math.max(this.numOfNodes, 5));
    }

    @Override
    public ConcurrencyLimitItem getExportNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 2);
    }

    @Override
    public ConcurrencyLimitItem getExportClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 2 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getSpaceUsersMaxLimit() {
        return new ConcurrencyLimitItem(1, 1);
    }

    @Override
    public ConcurrencyLimitItem getSpaceUsersNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 1);
    }

    @Override
    public ConcurrencyLimitItem getUploadClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 4 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getUploadNodeMaxLimit() {
        return new ConcurrencyLimitItem(1, 4);
    }

    @Override
    public ConcurrencyLimitItem getImportClusterMaxLimit() {
        return new ConcurrencyLimitItem(this.numOfNodes, 2 * this.numOfNodes);
    }

    @Override
    public ConcurrencyLimitItem getImportNodeMaxLimit() {
        return this.template.getImportNodeMaxLimit();
    }
}

