/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.execution;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.analytics.PrometheusMetricExportController;
import com.atlassian.migration.agent.common.MediaRateLimiter;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.PlanSchedulerVersion;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.ClusterLimits;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.MigrationMappingService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorContainerType;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.model.TransferResponseList;
import com.atlassian.migration.agent.service.event.ExecuteStepsEvent;
import com.atlassian.migration.agent.service.event.MediaRateLimiterResetEvent;
import com.atlassian.migration.agent.service.event.PlanCompletionEvent;
import com.atlassian.migration.agent.service.event.StepAllocation;
import com.atlassian.migration.agent.service.event.StepExecutorHeartbeatEvent;
import com.atlassian.migration.agent.service.event.StopPlanEvent;
import com.atlassian.migration.agent.service.execution.SchedulingAlgorithm;
import com.atlassian.migration.agent.service.execution.StepAllocations;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsAnalyticsService;
import com.atlassian.migration.agent.service.impl.DefaultPlanService;
import com.atlassian.migration.agent.service.impl.PlanConverter;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.infraoptimisation.InfraOptimisationService;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.service.planning.StepPlanningEngines;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.UsersMappingService;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.atlassian.migration.agent.service.user.UsersToTombstoneFileManager;
import com.atlassian.migration.agent.service.util.MigrationCreationHelper;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.guardrails.AssessmentApplinkService;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkAppType;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkDto;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class PlanExecutionService
implements JobRunner {
    static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:node-status-checker");
    static final JobId JOB_ID = JobId.of((String)"migration-plugin:node-status-checker-job-id");
    static final Duration RESCHEDULE_INTERVAL = Duration.ofSeconds(90L);
    static final String CLUSTER_LOCK = "PlanExecutionServiceLock";
    static final String JIRA_APPLINK = "jiraapplicationlink";
    private static final Logger log = ContextLoggerFactory.getLogger(PlanExecutionService.class);
    private final PluginTransactionTemplate ptx;
    private final TaskPlanningEngine taskPlanningEngine;
    private final StepPlanningEngines stepPlanningEngines;
    private final PlanStore planStore;
    private final TaskStore taskStore;
    private final StepStore stepStore;
    private final ProgressTracker progressTracker;
    private final PlatformService platformService;
    private final UserMappingsFileManager userMappingsFileManager;
    private final UsersToTombstoneFileManager usersToTombstoneFileManager;
    private final MigrationLogService migrationLogService;
    private final DefaultRegistrar cloudMigrationRegistrar;
    private final EventPublisher eventPublisher;
    private final UsersMappingService usersMappingService;
    private final ClusterInformationService clusterInformationService;
    private final SchedulerService schedulerService;
    private final ClusterLockService lockService;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final Clock clock;
    private final Supplier<String> idGenerator;
    private final ConcurrentMap<String, StepExecutorHeartbeatEvent> receivedHeartbeats;
    private final Map<Pair<String, String>, String> taskToTransferMap = new HashMap<Pair<String, String>, String>();
    private final InfraOptimisationService infraOptimisationService;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final ExecutorService executor;
    private final MigrationCreationHelper migrationCreationHelper;
    private final PlanConverter planConverter;
    private final MigrationMappingService migrationMappingService;
    private final AssessmentApplinkService assessmentApplinkService;
    private final PrometheusMetricExportController prometheusMetricExportController;
    private final ConcurrencySettingsAnalyticsService concurrencySettingsAnalyticsService;
    private final MediaRateLimiter mediaRateLimiter;
    private final Map<TaskType, List<StepType>> taskTypeToStepTypes = ImmutableMap.of((Object)((Object)TaskType.PACKED_SPACES), (Object)ImmutableList.of((Object)StepType.ATTACHMENT_UPLOAD, (Object)StepType.CONFLUENCE_EXPORT, (Object)StepType.SPACE_USERS_MIGRATION, (Object)StepType.DATA_UPLOAD, (Object)StepType.CONFLUENCE_IMPORT), (Object)((Object)TaskType.SPACE), (Object)ImmutableList.of((Object)StepType.ATTACHMENT_UPLOAD, (Object)StepType.CONFLUENCE_EXPORT, (Object)StepType.SPACE_USERS_MIGRATION, (Object)StepType.DATA_UPLOAD, (Object)StepType.CONFLUENCE_IMPORT), (Object)((Object)TaskType.USERS), (Object)ImmutableList.of((Object)StepType.USERS_MIGRATION), (Object)((Object)TaskType.GLOBAL_ENTITIES), (Object)ImmutableList.of((Object)StepType.GLOBAL_ENTITIES_EXPORT, (Object)StepType.GLOBAL_ENTITIES_DATA_UPLOAD, (Object)StepType.GLOBAL_ENTITIES_IMPORT), (Object)((Object)TaskType.ATTACHMENTS), (Object)ImmutableList.of((Object)StepType.ATTACHMENT_UPLOAD));

    public PlanExecutionService(PluginTransactionTemplate ptx, TaskPlanningEngine taskPlanningEngine, List<StepPlanningEngine<?>> planningEngines, PlanStore planStore, TaskStore taskStore, PlatformService platformService, UserMappingsFileManager userMappingsFileManager, UsersToTombstoneFileManager usersToTombstoneFileManager, MigrationLogService migrationLogService, DefaultRegistrar cloudMigrationRegistrar, EventPublisher eventPublisher, UsersMappingService usersMappingService, ClusterInformationService clusterInformationService, SchedulerService schedulerService, StepStore stepStore, ProgressTracker progressTracker, ClusterLockService lockService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, InfraOptimisationService infraOptimisationService, MigrationDarkFeaturesManager darkFeaturesManager, PlanConverter planConverter, MigrationMappingService migrationMappingService, AssessmentApplinkService assessmentApplinkService, PrometheusMetricExportController prometheusMetricExportController, ConcurrencySettingsAnalyticsService concurrencySettingsAnalyticsService, MediaRateLimiter mediaRateLimiter) {
        this(ptx, taskPlanningEngine, new StepPlanningEngines(planningEngines), planStore, taskStore, stepStore, progressTracker, platformService, userMappingsFileManager, usersToTombstoneFileManager, migrationLogService, cloudMigrationRegistrar, eventPublisher, usersMappingService, clusterInformationService, schedulerService, lockService, analyticsEventService, analyticsEventBuilder, Clock.systemUTC(), () -> UUID.randomUUID().toString(), infraOptimisationService, darkFeaturesManager, Executors.newSingleThreadExecutor(new GroupedThreadFactory("PlanExecutionService")), new MigrationCreationHelper(platformService, darkFeaturesManager, ptx, taskStore), planConverter, migrationMappingService, assessmentApplinkService, prometheusMetricExportController, concurrencySettingsAnalyticsService, mediaRateLimiter);
    }

    public PlanExecutionService(PluginTransactionTemplate ptx, TaskPlanningEngine taskPlanningEngine, StepPlanningEngines stepPlanningEngines, PlanStore planStore, TaskStore taskStore, StepStore stepStore, ProgressTracker progressTracker, PlatformService platformService, UserMappingsFileManager userMappingsFileManager, UsersToTombstoneFileManager usersToTombstoneFileManager, MigrationLogService migrationLogService, DefaultRegistrar cloudMigrationRegistrar, EventPublisher eventPublisher, UsersMappingService usersMappingService, ClusterInformationService clusterInformationService, SchedulerService schedulerService, ClusterLockService lockService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Clock clock, Supplier<String> idGenerator, InfraOptimisationService infraOptimisationService, MigrationDarkFeaturesManager darkFeaturesManager, ExecutorService executor, MigrationCreationHelper migrationCreationHelper, PlanConverter planConverter, MigrationMappingService migrationMappingService, AssessmentApplinkService assessmentApplinkService, PrometheusMetricExportController prometheusMetricExportController, ConcurrencySettingsAnalyticsService concurrencySettingsAnalyticsService, MediaRateLimiter mediaRateLimiter) {
        this.ptx = ptx;
        this.taskPlanningEngine = taskPlanningEngine;
        this.stepPlanningEngines = stepPlanningEngines;
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.stepStore = stepStore;
        this.progressTracker = progressTracker;
        this.platformService = platformService;
        this.userMappingsFileManager = userMappingsFileManager;
        this.usersToTombstoneFileManager = usersToTombstoneFileManager;
        this.migrationLogService = migrationLogService;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.eventPublisher = eventPublisher;
        this.usersMappingService = usersMappingService;
        this.clusterInformationService = clusterInformationService;
        this.schedulerService = schedulerService;
        this.lockService = lockService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.migrationMappingService = migrationMappingService;
        this.assessmentApplinkService = assessmentApplinkService;
        this.mediaRateLimiter = mediaRateLimiter;
        this.receivedHeartbeats = new ConcurrentHashMap<String, StepExecutorHeartbeatEvent>();
        this.infraOptimisationService = infraOptimisationService;
        this.darkFeaturesManager = darkFeaturesManager;
        this.executor = executor;
        this.migrationCreationHelper = migrationCreationHelper;
        this.planConverter = planConverter;
        this.prometheusMetricExportController = prometheusMetricExportController;
        this.concurrencySettingsAnalyticsService = concurrencySettingsAnalyticsService;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void postConstruct() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
        log.debug("Successfully registered ClusterNodeStatusChecker job {}.", (Object)RUNNER_KEY);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)RESCHEDULE_INTERVAL.toMillis(), (Date)new Date(System.currentTimeMillis() + 5000L))));
        log.debug("Successfully started ClusterNodeStatusChecker.");
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void handleHeartbeatEvent(StepExecutorHeartbeatEvent heartbeatEvent) {
        this.receivedHeartbeats.put(heartbeatEvent.getNodeId(), heartbeatEvent);
    }

    @EventListener
    public void handlePlanCompletionEvent(PlanCompletionEvent planCompletionEvent) {
        Plan plan = this.planStore.getPlanWithTasksEagerly(planCompletionEvent.getPlanId());
        this.onPlanCompletion(plan);
        this.infraOptimisationService.updateDataMovementStatus(plan);
    }

    @EventListener
    public void handleClusteredEvent(ClusterEventWrapper clusterEventWrapper) {
        try {
            Method method = clusterEventWrapper.getClass().getMethod("getEvent", new Class[0]);
            Object wrappedEvent = method.invoke((Object)clusterEventWrapper, new Object[0]);
            if (wrappedEvent instanceof StepExecutorHeartbeatEvent) {
                this.handleHeartbeatEvent((StepExecutorHeartbeatEvent)((Object)wrappedEvent));
            } else if (wrappedEvent instanceof PlanCompletionEvent) {
                log.info("Received plan completion event.");
                this.handlePlanCompletionEvent((PlanCompletionEvent)((Object)wrappedEvent));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to handle clustered event", (Throwable)e);
        }
    }

    @EventListener
    public void handle(MediaRateLimiterResetEvent e) {
        this.mediaRateLimiter.reset();
    }

    public void runPlan(String planId) {
        log.info("Starting execution of plan {}", (Object)planId);
        Plan plan = this.planStore.getPlanWithTasksEagerly(planId);
        LoggingContextBuilder logCtxBuilder = LoggingContextBuilder.logCtx().withMigrationId(plan.getMigrationId());
        this.eventPublisher.publish((Object)new MediaRateLimiterResetEvent(this));
        this.prometheusMetricExportController.start(plan.getMigrationId());
        this.concurrencySettingsAnalyticsService.buildStartEvent(plan);
        if (MigrationProtocol.V4.equals((Object)plan.getMigrationProtocol())) {
            logCtxBuilder.withAttribute("migrationProtocol", "V4");
            logCtxBuilder.execute(() -> this.runV4Plan(plan, null));
        } else {
            logCtxBuilder.withAttribute("migrationProtocol", "CV2");
            logCtxBuilder.execute(() -> this.runV2Plan(plan));
        }
        if (this.darkFeaturesManager.isUploadJiraAppLinkEnabled()) {
            log.info("Uploading Jira application link details for plan {}", (Object)planId);
            this.uploadApplicationLinkDetails(plan);
        }
    }

    private void runV4Plan(Plan plan, @Nullable @jakarta.annotation.Nullable String originalPlanId) {
        this.platformService.triggerMigrationRecipe(plan.getCloudSite().getCloudId(), plan, originalPlanId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runV2Plan(Plan plan) {
        List steps;
        ClusterLock lock = this.acquireLock();
        try {
            steps = this.ptx.write(() -> {
                List<Task> newTasks = this.taskPlanningEngine.getFirstTasks(plan.getId());
                this.progressTracker.updateDetailedStatusForPlan(newTasks);
                if (newTasks.isEmpty()) {
                    throw new IllegalArgumentException("A plan must have at least one task.");
                }
                newTasks.forEach(this::generateNextStep);
                return this.allocatePendingSteps(plan);
            });
        }
        finally {
            lock.unlock();
        }
        this.distributeToExecutors(steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopPlan(String planId) {
        boolean markedAsStopping;
        log.info("Stopping execution of plan {}", (Object)planId);
        ClusterLock lock = this.acquireLock();
        try {
            markedAsStopping = this.ptx.write(() -> {
                boolean stopping = this.tryMarkAsStopping(planId);
                Plan plan = this.planStore.getPlan(planId);
                if (plan.getMigrationProtocol() == MigrationProtocol.CV2 || plan.getMigrationProtocol() == MigrationProtocol.V2) {
                    if (stopping) {
                        log.info("Marked plan {} as stopping. Requesting all step executors to stop work.", (Object)planId);
                        Plan updatePlan = this.planStore.getPlanAndLock(planId);
                        this.taskStore.stopInactiveTasks(planId);
                        this.stepStore.stopCreatedSteps(planId);
                        if (!this.taskStore.hasRunningTasks(planId)) {
                            updatePlan.setProgress(updatePlan.getProgress().copy().stopped());
                            this.planStore.updatePlan(updatePlan);
                            this.progressTracker.updateMigrationStatus(updatePlan);
                        }
                    }
                } else {
                    this.platformService.stopMigrationRecipe(plan.getMigrationId(), plan.getMigrationScopeId(), plan.getCloudSite().getCloudId(), plan.getCloudSite().getContainerToken());
                }
                return stopping;
            });
        }
        finally {
            lock.unlock();
        }
        if (markedAsStopping) {
            this.stopPlanOnExecutors(planId);
        }
        return markedAsStopping;
    }

    private boolean tryMarkAsStopping(String planId) {
        Plan plan = this.planStore.getPlanAndLock(planId);
        ExecutionStatus status = plan.getProgress().getStatus();
        if (!status.canGo(ExecutionStatus.STOPPING)) {
            return false;
        }
        plan.setProgress(plan.getProgress().copy().stopping());
        this.planStore.updatePlan(plan);
        this.progressTracker.updateMigrationStatus(plan);
        return true;
    }

    private void stopPlanOnExecutors(String planId) {
        this.eventPublisher.publish((Object)new StopPlanEvent(this, planId));
    }

    private ClusterLock acquireLock() {
        ClusterLock lock = this.lockService.getLockForName(CLUSTER_LOCK);
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStepCompleted(StepAllocation stepAllocation, @Nullable @jakarta.annotation.Nullable StepResult result, @Nullable @jakarta.annotation.Nullable Throwable throwable) {
        List steps;
        block10: {
            steps = Collections.emptyList();
            ClusterLock lock = this.acquireLock();
            try {
                Step step = this.ptx.read(() -> this.stepStore.getStep(stepAllocation.getStepId()));
                log.info("Step {} completed execution {} with result={}", new Object[]{step.getId(), step.getNodeExecutionId(), result, throwable});
                if (!Objects.equals(step.getNodeExecutionId(), stepAllocation.getNodeExecutionId())) {
                    log.warn("Step {} completed by zombie executor. Ignoring. Actual executionId={} Expected executionId={}", new Object[]{step.getId(), result, stepAllocation.getNodeExecutionId()});
                    return;
                }
                steps = this.ptx.write(() -> {
                    this.updateStatus(step, result, throwable);
                    return this.allocateNewWork(step.getId());
                });
            }
            catch (Exception e) {
                try {
                    log.error("Failed to handle step completion for step {}", (Object)stepAllocation.getStepId(), (Object)e);
                    Step step = this.ptx.read(() -> this.stepStore.getStep(stepAllocation.getStepId()));
                    this.analyticsEventService.sendAnalyticsEvent(() -> this.analyticsEventBuilder.buildErrorOperationalEvent(new ErrorEvent.ErrorEventBuilder(MigrationErrorCode.UNHANDLED_ERROR, ErrorContainerType.MIGRATION_ERROR, step.getPlan().getMigrationId(), StepType.valueOf(step.getType())).setReason(e.getMessage()).setCloudid(step.getPlan().getCloudSite().getCloudId()).build()));
                    if (this.darkFeaturesManager.isEnhancedErrorHandlingEnabled()) {
                        this.progressTracker.failTask(stepAllocation.getTaskId(), "Failed to complete step: ", e);
                        break block10;
                    }
                    this.progressTracker.failTask(stepAllocation.getTaskId(), "Failed to complete step: " + e.getMessage());
                }
                catch (Exception ex) {
                    log.error("Unable to mark step {} as failed. The step will be treated as hung and retried.", (Object)stepAllocation.getStepId(), (Object)e);
                }
            }
            finally {
                lock.unlock();
            }
        }
        this.distributeToExecutors(steps);
    }

    private List<StepAllocation> allocateNewWork(String stepId) {
        Step step = this.stepStore.getStep(stepId);
        Task task = step.getTask();
        Plan plan = this.planStore.getPlanWithTasksEagerly(step.getPlan().getId());
        if (plan.getProgress().getStatus().isCompleted()) {
            log.info("Plan {} has completed execution with status {}.", (Object)plan.getId(), (Object)plan.getProgress().getStatus());
            this.onPlanCompletion(plan);
        } else if (plan.getProgress().getStatus() != ExecutionStatus.STOPPING) {
            if (!task.getProgress().getStatus().isCompleted()) {
                if (this.generateNextStep(task, step.getId()).isPresent()) {
                    return this.allocatePendingSteps(plan);
                }
                throw new IllegalStateException("Task generated no next step yet wasn't marked as completed.");
            }
            List<Task> nextTasks = this.taskPlanningEngine.getNextTasks(task);
            this.progressTracker.updateDetailedStatusForPlan(nextTasks);
            nextTasks.forEach(this::generateNextStep);
            return this.allocatePendingSteps(plan);
        }
        return Collections.emptyList();
    }

    private void updateStatus(Step step, @Nullable @jakarta.annotation.Nullable StepResult result) {
        this.updateStatus(step, result, null);
    }

    private void updateStatus(Step step, @Nullable @jakarta.annotation.Nullable StepResult result, @Nullable @jakarta.annotation.Nullable Throwable throwable) {
        String stepId = step.getId();
        StepType stepType = StepType.valueOf(step.getType());
        if (throwable != null) {
            log.error("An error occurred while running step with id: {}", (Object)stepId, (Object)throwable);
            this.analyticsEventService.sendAnalyticsEvent(() -> this.analyticsEventBuilder.buildErrorOperationalEvent(new ErrorEvent.ErrorEventBuilder(MigrationErrorCode.UNHANDLED_ERROR, ErrorContainerType.MIGRATION_ERROR, step.getPlan().getMigrationId(), stepType).setReason(throwable.getMessage()).setCloudid(step.getPlan().getCloudSite().getCloudId()).build()));
            this.progressTracker.completed(step, StepResult.failed(String.format("An unexpected error occurred during step: %s. Error: %s", stepType.getDisplayName(), throwable.getMessage()), throwable));
        } else if (result == null) {
            log.error("Step {} failed to produce a result, yet did not raise a throwable.", (Object)stepId);
            this.progressTracker.completed(step, StepResult.failed(String.format("An unexpected error occurred during step: %s. The step failed to produce a result.", stepType.getDisplayName())));
        } else {
            this.progressTracker.completed(step, result);
        }
    }

    @VisibleForTesting
    void onPlanCompletion(Plan plan) {
        log.info("Will execute post plan completion tasks for planId : {}", (Object)plan.getId());
        this.migrationLogService.uploadMigrationLogsZipFromClustersToMCS(plan.getCloudSite().getCloudId(), plan.getMigrationId(), plan.getId());
        if (plan.getProgress().getStatus().canTriggerAppMigration() && DefaultPlanService.getMigrateAppsTask(plan).isPresent()) {
            this.updateContainerStatusAndMigrateApps(plan);
        }
        if (plan.getProgress().getStatus() == ExecutionStatus.FAILED || plan.getProgress().getStatus() == ExecutionStatus.STOPPED || plan.getProgress().getStatus() == ExecutionStatus.INCOMPLETE) {
            this.uploadMigrationLogZipToMCS(plan.getId(), plan.getCloudSite().getCloudId(), plan.getMigrationId());
        }
        this.cleanupUserMappings(plan.getId());
        this.cleanupUsersToTombstone(plan.getId());
        this.prometheusMetricExportController.stop(plan.getMigrationId());
        if (plan.isShadowMigration()) {
            this.ptx.write(() -> {
                this.stepStore.deleteStepsForPlan(plan.getId());
                this.taskStore.deleteTasksForPlan(plan.getId());
                this.planStore.deletePlan(plan.getId());
            });
        }
        if (this.shouldTriggerShadowMigration(plan)) {
            this.executor.submit(() -> this.triggerShadowMigration(plan));
        }
    }

    boolean shouldTriggerShadowMigration(Plan plan) {
        return !plan.isShadowMigration() && !MigrationProtocol.V4.equals((Object)plan.getMigrationProtocol()) && !plan.getProgress().getStatus().isUnsuccessful() && this.darkFeaturesManager.isV4ShadowMigrationsEnabled();
    }

    @VisibleForTesting
    void triggerShadowMigration(Plan originalPlan) {
        log.info("Triggering shadow migration for plan {}", (Object)originalPlan.getId());
        Plan shadowPlan = this.ptx.write(() -> {
            Plan copiedPlan = this.createShadowPlan(originalPlan);
            copiedPlan.setProgress(copiedPlan.getProgress().copy().started(null));
            return copiedPlan;
        });
        MigrationDetails migrationDetails = this.migrationCreationHelper.retrieveMigrationDetails(shadowPlan);
        shadowPlan.setMigrationScopeId(migrationDetails.migrationScopeId);
        shadowPlan.setMigrationId(migrationDetails.migrationId);
        shadowPlan.setSchedulerVersion(PlanSchedulerVersion.PLAN_EXECUTION_SERVICE);
        Plan finalShadowPlan = shadowPlan;
        this.ptx.write(() -> this.planStore.createPlan(finalShadowPlan));
        shadowPlan = this.ptx.read(() -> this.planStore.getPlanWithTasksEagerlyByMigrationId(migrationDetails.migrationId));
        this.migrationCreationHelper.createContainersInMcs(shadowPlan.getCloudSite().getCloudId(), shadowPlan.getMigrationId(), shadowPlan);
        try {
            PlanDto planDto = this.planConverter.entityToDto(shadowPlan, true);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildStartPlanAnalyticsEvent(planDto, originalPlan.getCloudSite()));
        }
        catch (Exception e) {
            log.warn("Analytics failure while registering start events", (Throwable)e);
        }
        this.runV4Plan(shadowPlan, originalPlan.getId());
    }

    private Plan createShadowPlan(Plan plan) {
        Plan shadowPlan = new Plan(plan);
        shadowPlan.setMigrationProtocol(MigrationProtocol.V4);
        shadowPlan.setName("Shadow Migration for " + plan.getName());
        shadowPlan.setShadowMigration(true);
        shadowPlan.setTasks(plan.getTasks());
        return shadowPlan;
    }

    private void updateContainerStatusAndMigrateApps(Plan plan) {
        boolean containersUpdated = this.platformService.updateSpaceContainerStatuses(plan);
        if (containersUpdated) {
            log.info("All Space container for plan {} status is updated in MCS. Triggering app migration...", (Object)plan.getId());
            this.startAppMigration(plan);
        } else {
            String message = String.format("Space containers status were not updated completely in MCS for plan %s. App Migration will not begin", plan.getId());
            log.error(message);
            DefaultPlanService.getMigrateAppsTask(plan).ifPresent(task -> this.progressTracker.failTask(task.getId(), message));
        }
    }

    private void startAppMigration(Plan plan) {
        this.usersMappingService.saveUserMappingsToFile(plan.getCloudSite().getCloudId(), plan.getId(), plan.getMigrationScopeId());
        Set<AppContainerDetails> appContainerDetails = this.platformService.getAppContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId());
        this.cloudMigrationRegistrar.startMigration(plan.getCloudSite().getCloudId(), plan.getMigrationId(), appContainerDetails);
    }

    private void cleanupUserMappings(String planId) {
        log.info("Cleaning up user mappings for plan {}", (Object)planId);
        this.userMappingsFileManager.cleanupUserMappingsFile(planId);
    }

    private void cleanupUsersToTombstone(String planId) {
        log.info("Cleaning up users to tombstone file for plan {}", (Object)planId);
        this.usersToTombstoneFileManager.cleanupUsersToTombstoneFile(planId);
    }

    private void uploadMigrationLogZipToMCS(String planId, String cloudId, String migrationId) {
        this.migrationLogService.uploadMigrationErrorLogZipToMCS(planId, cloudId, migrationId);
    }

    private void distributeToExecutors(List<StepAllocation> steps) {
        if (CollectionUtils.isNotEmpty(steps)) {
            try {
                this.eventPublisher.publish((Object)new ExecuteStepsEvent(this, steps));
            }
            catch (Exception e) {
                log.error("Failed to distribute steps to executors", (Throwable)e);
                Step step = this.stepStore.getStep(steps.get(0).getStepId());
                Plan plan = step.getPlan();
                this.uploadMigrationLogZipToMCS(plan.getId(), plan.getCloudSite().getCloudId(), plan.getMigrationId());
                throw e;
            }
        }
    }

    @VisibleForTesting
    List<StepAllocation> allocatePendingSteps(Plan plan) {
        return this.allocatePendingSteps(plan.getId(), plan);
    }

    @VisibleForTesting
    List<StepAllocation> allocatePendingSteps(String planId) {
        return this.allocatePendingSteps(planId, null);
    }

    private List<StepAllocation> allocatePendingSteps(String planId, @Nullable @jakarta.annotation.Nullable Plan plan) {
        ArrayList<Step> unallocatedSteps = new ArrayList<Step>();
        for (StepType stepType : StepType.values()) {
            unallocatedSteps.addAll(this.stepStore.getCreatedStepsOfType(planId, stepType, this.clusterInformationService.getClusterLimits().getClusterConcurrencyLimit(stepType, plan)));
        }
        return this.tryAllocateSteps(planId, unallocatedSteps);
    }

    @VisibleForTesting
    List<StepAllocation> tryAllocateSteps(String planId, List<Step> unallocatedSteps) {
        List<String> nodes = this.clusterInformationService.getAllNodeIds();
        log.info("Allocating steps for plan {}. There are currently {} step(s) pending execution, and {} available execution node(s): {}", new Object[]{planId, unallocatedSteps.size(), nodes.size(), nodes});
        ArrayList<StepAllocation> newlyAllocatedSteps = new ArrayList<StepAllocation>();
        if (!unallocatedSteps.isEmpty()) {
            StepAllocations currentAllocations = this.getStepAllocationsForNodes(planId, nodes);
            for (Step step : unallocatedSteps) {
                Optional<String> bestNode = this.findBestNode(currentAllocations, step, this.clusterInformationService.getClusterLimits());
                if (!bestNode.isPresent()) continue;
                StepAllocation stepAllocation = this.allocateStepToNode(step, bestNode.get());
                currentAllocations.addStepToNode(bestNode.get(), step);
                newlyAllocatedSteps.add(stepAllocation);
            }
        }
        return newlyAllocatedSteps;
    }

    Optional<String> findBestNode(StepAllocations currentAllocations, Step step, ClusterLimits clusterLimits) {
        StepType stepType = StepType.valueOf(step.getType());
        SchedulingAlgorithm schedulingAlgorithm = clusterLimits.getSchedulingAlgorithm(stepType);
        return schedulingAlgorithm.findBestNode(currentAllocations, clusterLimits, stepType);
    }

    private StepAllocation allocateStepToNode(Step step, String nodeId) {
        String executionId = this.idGenerator.get();
        log.info("Allocating step {} to node {}. ExecutionId={}", new Object[]{step.getId(), nodeId, executionId});
        step.setNodeId(nodeId);
        step.setNodeExecutionId(executionId);
        step.setNodeHeartbeat(this.clock.instant());
        this.stepStore.update(step);
        this.progressTracker.started(step, StepType.valueOf(step.getType()).getDisplayName());
        return new StepAllocation(step.getId(), step.getTask().getId(), nodeId, executionId);
    }

    private StepAllocations getStepAllocationsForNodes(String planId, List<String> nodes) {
        HashMap<String, StepAllocations.NodeStepAllocations> allocationsByNode = new HashMap<String, StepAllocations.NodeStepAllocations>();
        Map<String, List<Step>> currentAllocations = this.stepStore.getRunningStepsForPlan(planId).stream().collect(Collectors.groupingBy(Step::getNodeId));
        for (String node : nodes) {
            List<Step> currentAllocation = currentAllocations.get(node);
            allocationsByNode.put(node, new StepAllocations.NodeStepAllocations(node, currentAllocation));
        }
        return new StepAllocations(allocationsByNode);
    }

    private Optional<Step> generateNextStep(Task task) {
        return this.generateNextStep(task, null);
    }

    private Optional<Step> generateNextStep(Task task, @Nullable @jakarta.annotation.Nullable String predecessorStepId) {
        Optional<Step> nextStep = this.ptx.read(() -> this.stepStore.getStepsByTaskId(task.getId()).stream().filter(step -> !step.getProgress().getStatus().isCompleted()).findFirst());
        if (!nextStep.isPresent()) {
            if (predecessorStepId == null) {
                this.createTransfers(task);
                Step step = this.getStepPlanningEngine(task).createFirstStep(task);
                step.setIndex(0);
                step.setTask(task);
                this.setTransferId(step);
                this.ptx.write(() -> this.stepStore.addSteps((Collection<Step>)ImmutableList.of((Object)step)));
                nextStep = Optional.of(step);
            } else {
                Step predecessor = this.ptx.read(() -> this.stepStore.getStep(predecessorStepId));
                nextStep = this.getStepPlanningEngine(task).createNextStep(task, predecessor);
                if (nextStep.isPresent()) {
                    Step step = nextStep.get();
                    step.setIndex(predecessor.getIndex() + 1);
                    step.setTask(task);
                    this.setTransferId(step);
                    this.ptx.write(() -> this.stepStore.addSteps((Collection<Step>)ImmutableList.of((Object)step)));
                }
            }
        }
        return nextStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(JobRunnerRequest req) {
        ArrayList<StepAllocation> steps = new ArrayList<StepAllocation>();
        ClusterLock lock = this.acquireLock();
        try {
            ImmutableList migrationProtocols = ImmutableList.of((Object)((Object)MigrationProtocol.CV2), (Object)((Object)MigrationProtocol.V2));
            List runningPlanIds = this.ptx.read(() -> this.lambda$runJob$22((List)migrationProtocols));
            for (String planId : runningPlanIds) {
                log.info("Running plan execution watchdog for plan {}", (Object)planId);
                steps.addAll(this.ptx.write(() -> {
                    Plan plan = this.planStore.getPlanAndLock(planId);
                    this.resetHungSteps(plan, this.findHungSteps(planId));
                    return this.allocatePendingSteps(planId);
                }));
            }
        }
        finally {
            lock.unlock();
        }
        this.distributeToExecutors(steps);
        return JobRunnerResponse.success();
    }

    private List<Step> findHungSteps(String planId) {
        Instant currentTime = this.clock.instant();
        List<Step> hungSteps = this.stepStore.getHungStepsForPlan(planId, currentTime, RESCHEDULE_INTERVAL.toMillis());
        return hungSteps.stream().filter(step -> {
            StepExecutorHeartbeatEvent heartbeat = (StepExecutorHeartbeatEvent)((Object)((Object)this.receivedHeartbeats.get(step.getNodeId())));
            return heartbeat == null || !heartbeat.containsExecution(step.getNodeExecutionId()) || currentTime.toEpochMilli() - heartbeat.getHeartbeatTime() > RESCHEDULE_INTERVAL.toMillis();
        }).collect(Collectors.toList());
    }

    private void resetHungSteps(Plan plan, List<Step> hungSteps) {
        String planId = plan.getId();
        if (!hungSteps.isEmpty()) {
            log.warn("Found hung steps for plan {}: {}", (Object)planId, hungSteps.stream().map(step -> ImmutableMap.of((Object)"id", (Object)step.getId(), (Object)"nodeExecutionId", (Object)(step.getNodeExecutionId() == null ? "no execution Id set" : step.getNodeExecutionId()), (Object)"nodeHeartbeat", (Object)(step.getNodeHeartbeat() == null ? "no heartbeat set" : step.getNodeHeartbeat()))).collect(Collectors.toList()));
            for (Step step2 : hungSteps) {
                this.clearStepAllocation(step2);
                this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildStuckStepAnalyticsEvent(step2, Optional.empty()));
                if (plan.getProgress().getStatus() != ExecutionStatus.STOPPING) continue;
                this.updateStatus(step2, StepResult.stopped());
            }
        }
    }

    private void clearStepAllocation(Step step) {
        log.info("Cleared step allocation for step {}", (Object)step.getId());
        step.setProgress(Progress.created());
        step.setNodeHeartbeat(null);
        step.setNodeId(null);
        step.setNodeExecutionId(null);
        if (step.getType().equals(StepType.USERS_MIGRATION.name())) {
            step.setExecutionState(null);
        }
        this.stepStore.update(step);
    }

    private StepPlanningEngine getStepPlanningEngine(Task task) {
        return this.stepPlanningEngines.of(task).orElseThrow(() -> new IllegalStateException("Could not find step planning engine for task of type: " + task.getClass().getCanonicalName()));
    }

    private void setTransferId(Step step) {
        try {
            Task task = step.getTask();
            StepType stepType = StepType.valueOf(step.getType());
            String transferId = this.taskToTransferMap.get(Pair.of((Object)task.getId(), (Object)stepType.getOperationKey()));
            this.ptx.write(() -> step.setTransferId(transferId));
            this.taskToTransferMap.remove(Pair.of((Object)task.getId(), (Object)stepType.getOperationKey()));
        }
        catch (Exception e) {
            log.error("Error while setting transfer id for step {}", (Object)step.getId(), (Object)e);
        }
    }

    private void createTransfers(Task task) {
        try {
            List<String> allStepsOperationKey = this.taskTypeToStepTypes.get((Object)task.getType()).stream().map(StepType::getOperationKey).collect(Collectors.toList());
            Optional<TransferResponseList> response = this.platformService.createTransfers(task.getPlan().getCloudSite().getCloudId(), task.getPlan().getMigrationId(), task.getContainerId(), allStepsOperationKey);
            response.ifPresent(transferResponseList -> transferResponseList.getTransfers().forEach(transferResponse -> this.taskToTransferMap.put((Pair<String, String>)Pair.of((Object)task.getId(), (Object)transferResponse.getOperationKey()), transferResponse.getTransferId())));
        }
        catch (Exception e) {
            log.error("Error while creating transfers for task {}", (Object)task.getId(), (Object)e);
        }
    }

    private void uploadApplicationLinkDetails(Plan plan) {
        String cloudId = plan.getCloudSite().getCloudId();
        String migrationScopeId = plan.getMigrationScopeId();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            List<ApplinkDto> appLinks = this.assessmentApplinkService.getApplinks();
            List jiraAppLinks = (List)appLinks.stream().filter(applink -> ApplinkAppType.JIRA.equals((Object)applink.getAppType())).collect(ImmutableList.toImmutableList());
            if (jiraAppLinks.isEmpty()) {
                log.info("No JIRA application links found");
                return;
            }
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (ApplinkDto jiraApplink : jiraAppLinks) {
                mappings.put(jiraApplink.getApplinkId(), jiraApplink.getAppRpcUrl());
            }
            log.info("Uploading application link details: {}", mappings);
            this.migrationMappingService.sendMappings(cloudId, migrationScopeId, mappings, JIRA_APPLINK);
        });
        ((CompletableFuture)future.thenRun(() -> log.info("Successfully uploaded jira application link details"))).exceptionally(e -> {
            log.error("Failed to upload jira application link details", e);
            return null;
        });
    }

    private /* synthetic */ List lambda$runJob$22(List migrationProtocols) {
        return this.planStore.getPlanIdsInStatusForSchedulerVersion((List<ExecutionStatus>)ImmutableList.of((Object)((Object)ExecutionStatus.RUNNING), (Object)((Object)ExecutionStatus.STOPPING)), PlanSchedulerVersion.PLAN_EXECUTION_SERVICE, migrationProtocols);
    }
}

