/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.network;

import java.net.InetSocketAddress;
import java.net.Socket;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketLoggingEventListener
extends EventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketLoggingEventListener.class);

    public void connectionAcquired(Call call, Connection connection) {
        HttpUrl url = call.request().url();
        Socket socket = connection.socket();
        InetSocketAddress localAddress = (InetSocketAddress)socket.getLocalSocketAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        log.debug("Socket URL: {}", (Object)url);
        log.debug("Socket Source (Local): {}:{}", (Object)localAddress.getAddress().getHostAddress(), (Object)localAddress.getPort());
        log.debug("Socket Destination (Remote): {}:{}", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
    }

    public static class Factory
    implements EventListener.Factory {
        public EventListener create(Call call) {
            return new SocketLoggingEventListener();
        }
    }
}

