/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.catalogue.model;

import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class PackedConfluenceSpaceContainer
extends AbstractContainer
implements Serializable {
    private static final long serialVersionUID = -7558406118441205053L;
    public static final int MAX_PACKED_SPACES_LIMIT = 25;
    private final List<String> sourceIds;
    private final List<SpaceInfo> spaces;
    private final Set<ConfluenceSpaceContainer.SpaceSelection> selections;

    public PackedConfluenceSpaceContainer(List<SpaceInfo> spaces, Set<ConfluenceSpaceContainer.SpaceSelection> selections) {
        super(AbstractContainer.ContainerType.PackedConfluenceSpace);
        this.spaces = spaces;
        this.sourceIds = spaces.stream().map(SpaceInfo::getSourceId).collect(Collectors.toList());
        this.selections = new HashSet<ConfluenceSpaceContainer.SpaceSelection>(selections);
    }

    public PackedConfluenceSpaceContainer(List<SpaceInfo> spaces, List<String> sourceIds, Set<ConfluenceSpaceContainer.SpaceSelection> selections, String containerId) {
        super(AbstractContainer.ContainerType.PackedConfluenceSpace, containerId);
        this.spaces = spaces;
        this.sourceIds = sourceIds;
        this.selections = new HashSet<ConfluenceSpaceContainer.SpaceSelection>(selections);
    }

    public int getSpaceCount() {
        return this.spaces.size();
    }

    public List<String> getSpaceKeys() {
        return this.spaces.stream().map(SpaceInfo::getKey).collect(Collectors.toList());
    }

    public boolean containsSpaceKey(String spaceKey) {
        return this.spaces.stream().anyMatch(space -> space.getKey().equals(spaceKey));
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public List<SpaceInfo> getSpaces() {
        return this.spaces;
    }

    @Generated
    public Set<ConfluenceSpaceContainer.SpaceSelection> getSelections() {
        return this.selections;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackedConfluenceSpaceContainer)) {
            return false;
        }
        PackedConfluenceSpaceContainer other = (PackedConfluenceSpaceContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$sourceIds = this.getSourceIds();
        List<String> other$sourceIds = other.getSourceIds();
        if (this$sourceIds == null ? other$sourceIds != null : !((Object)this$sourceIds).equals(other$sourceIds)) {
            return false;
        }
        List<SpaceInfo> this$spaces = this.getSpaces();
        List<SpaceInfo> other$spaces = other.getSpaces();
        if (this$spaces == null ? other$spaces != null : !((Object)this$spaces).equals(other$spaces)) {
            return false;
        }
        Set<ConfluenceSpaceContainer.SpaceSelection> this$selections = this.getSelections();
        Set<ConfluenceSpaceContainer.SpaceSelection> other$selections = other.getSelections();
        return !(this$selections == null ? other$selections != null : !((Object)this$selections).equals(other$selections));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PackedConfluenceSpaceContainer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $sourceIds = this.getSourceIds();
        result = result * 59 + ($sourceIds == null ? 43 : ((Object)$sourceIds).hashCode());
        List<SpaceInfo> $spaces = this.getSpaces();
        result = result * 59 + ($spaces == null ? 43 : ((Object)$spaces).hashCode());
        Set<ConfluenceSpaceContainer.SpaceSelection> $selections = this.getSelections();
        result = result * 59 + ($selections == null ? 43 : ((Object)$selections).hashCode());
        return result;
    }

    public static class SpaceInfo
    implements Serializable {
        private static final long serialVersionUID = -2566955015364440414L;
        private final String sourceId;
        private final String key;
        private final String name;

        public SpaceInfo(String sourceId, String key, String name) {
            this.sourceId = sourceId;
            this.key = key;
            this.name = name;
        }

        @Generated
        public String getSourceId() {
            return this.sourceId;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpaceInfo)) {
                return false;
            }
            SpaceInfo other = (SpaceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceId = this.getSourceId();
            String other$sourceId = other.getSourceId();
            if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SpaceInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceId = this.getSourceId();
            result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

