/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.AnalyticsEvent;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.service.analytics.AnalyticsSenderService;
import com.atlassian.migration.agent.service.analytics.MigrationAnalyticsEventRefusedException;
import com.atlassian.migration.agent.service.analytics.ProcessedAnalyticsEvents;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.store.impl.AnalyticsEventStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

@ParametersAreNonnullByDefault
public class AnalyticsEventConsumer
implements JobRunner {
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"migration-plugin:analytics-events-consumer-runner-key");
    private static final JobId JOB_ID = JobId.of((String)"migration-plugin:analytics-events-consumer-job-id");
    public static final int MAX_BATCHES_PER_RUN = 1000;
    private static final int INITIAL_DELAY_IN_SEC = 10;
    private static final Logger log = ContextLoggerFactory.getLogger(AnalyticsEventConsumer.class);
    private final PluginTransactionTemplate ptx;
    private final AnalyticsEventStore analyticsEventStore;
    private final SchedulerService schedulerService;
    private final AnalyticsSenderService analyticsSenderService;
    private final MigrationAgentConfiguration agentConfiguration;
    private final CloudSiteService cloudSiteService;
    private final LegalService legalService;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsConfigService analyticsConfigService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private Instant lastEventSubmission;

    public AnalyticsEventConsumer(PluginTransactionTemplate ptx, AnalyticsEventStore analyticsEventStore, SchedulerService schedulerService, AnalyticsSenderService analyticsSenderService, MigrationAgentConfiguration agentConfiguration, CloudSiteService cloudSiteService, LegalService legalService, AnalyticsConfigService analyticsConfigService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this(ptx, analyticsEventStore, schedulerService, analyticsSenderService, agentConfiguration, cloudSiteService, legalService, Instant::now, analyticsConfigService, migrationDarkFeaturesManager);
    }

    @VisibleForTesting
    AnalyticsEventConsumer(PluginTransactionTemplate ptx, AnalyticsEventStore analyticsEventStore, SchedulerService schedulerService, AnalyticsSenderService analyticsSenderService, MigrationAgentConfiguration agentConfiguration, CloudSiteService cloudSiteService, LegalService legalService, Supplier<Instant> instantSupplier, AnalyticsConfigService analyticsConfigService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.ptx = ptx;
        this.analyticsEventStore = analyticsEventStore;
        this.schedulerService = schedulerService;
        this.analyticsSenderService = analyticsSenderService;
        this.agentConfiguration = agentConfiguration;
        this.cloudSiteService = cloudSiteService;
        this.legalService = legalService;
        this.instantSupplier = instantSupplier;
        this.analyticsConfigService = analyticsConfigService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.setLastEventSubmission(instantSupplier.get());
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void postConstruct() throws SchedulerServiceException {
        log.info("Analytics event consumer bootstrap");
        if (this.agentConfiguration.isAnalyticsSenderDisabled()) {
            this.schedulerService.unscheduleJob(JOB_ID);
            log.warn("AnalyticsEventConsumer poller is disabled. Job {} is removed.", (Object)JOB_ID);
        } else {
            log.info("Registering AnalyticsEventConsumer job {}.", (Object)RUNNER_KEY);
            this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
            log.info("Successfully registered AnalyticsEventConsumer job {}.", (Object)RUNNER_KEY);
            ImmutableMap params = ImmutableMap.of();
            log.info("Scheduling AnalyticsEventConsumer params {}.", (Object)params);
            Schedule schedule = Schedule.forInterval((long)this.jobInterval(), (Date)Date.from(this.instantSupplier.get().plus(Duration.ofSeconds(10L))));
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)params).withSchedule(schedule));
            log.info("Successfully started AnalyticsEventConsumer poller.");
        }
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void cleanup() {
        log.info("Start unregistering AnalyticsEventConsumer[{}]...", (Object)RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
        log.info("Successfully unregistered AnalyticsEventConsumer[{}]", (Object)RUNNER_KEY);
    }

    public JobRunnerResponse runJob(JobRunnerRequest req) {
        log.info("Starting AnalyticsEventConsumer jobId={}, isCancellationRequested={}", (Object)req.getJobId(), (Object)req.isCancellationRequested());
        return this.runJob();
    }

    public JobRunnerResponse runJob() {
        if (!this.legalService.getRememberLegalOptIn() && !this.analyticsConfigService.canCollectAnalytics()) {
            return JobRunnerResponse.aborted((String)"User hasn't agreed with sending analytics");
        }
        if (this.noEventsToBeSent()) {
            return JobRunnerResponse.aborted((String)"Waiting a bit longer before sending analytics events");
        }
        return this.submitEvents();
    }

    public void triggerJobAndDeleteRemainingEvents() {
        log.info("Successfully triggered AnalyticsEventConsumer.");
        this.runJob();
        this.ptx.write(this.analyticsEventStore::deleteAllEvents);
    }

    private boolean noEventsToBeSent() {
        return this.ptx.read(this.analyticsEventStore::countAnalyticsEvents) < (long)this.getConfiguredBatchSize() && this.getLastEventSubmission().plus(Duration.ofMinutes(this.maxWait())).isAfter(this.instantSupplier.get());
    }

    private JobRunnerResponse submitEvents() {
        Optional<String> token = this.cloudSiteService.getNonFailingToken();
        if (!token.isPresent()) {
            return JobRunnerResponse.success((String)"No container tokens found. The user has to link a cloud site before we start sending analytics events");
        }
        this.setLastEventSubmission(this.instantSupplier.get());
        try {
            int batch;
            boolean morePendingEvents = false;
            boolean timeout = false;
            Instant maxProcessingTime = this.getMaxProcessingTime();
            for (batch = 0; batch < 1000; ++batch) {
                timeout = this.instantSupplier.get().isAfter(maxProcessingTime);
                morePendingEvents = this.ptx.write(() -> this.sendBatchOfEvents((String)token.get()));
                if (morePendingEvents && !timeout) continue;
                if (timeout) {
                    log.debug("The job reached max processing time, the job will be halted to allow a new node to pick up the task in order to rebalance its load.");
                    break;
                }
                log.debug("No more pending events.");
                break;
            }
            log.info("Events complete: morePendingEvents={}, timeout={}, batch={}", new Object[]{morePendingEvents, timeout, batch});
            return JobRunnerResponse.success();
        }
        catch (HttpServiceException e) {
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED.value()) {
                return this.tokenError(token.get());
            }
            return this.error(e);
        }
        catch (MigrationAnalyticsEventRefusedException e) {
            return JobRunnerResponse.success((String)e.getMessage());
        }
        catch (RuntimeException e) {
            return this.error(e);
        }
    }

    private JobRunnerResponse tokenError(String token) {
        log.warn("Token refused by Stargate. Marking cloud site as failing.");
        this.cloudSiteService.markTokenAsFailed(token);
        return JobRunnerResponse.failed((String)"Failed to authorise service. Marking cloud site as failing");
    }

    private boolean sendBatchOfEvents(String token) {
        int configuredBatchSize = this.getConfiguredBatchSize();
        Instant start = this.instantSupplier.get();
        List<AnalyticsEvent> batch = this.analyticsEventStore.pullAnalyticsEvents(configuredBatchSize);
        long elapsedTime = start.until(this.instantSupplier.get(), ChronoUnit.MILLIS);
        log.debug("Pulled {} analytics events in {} ms", (Object)batch.size(), (Object)elapsedTime);
        if (CollectionUtils.isEmpty(batch)) {
            log.warn("Empty analytics events in {} ms", (Object)elapsedTime);
            return false;
        }
        ProcessedAnalyticsEvents sentAnalyticsEvents = this.analyticsSenderService.processAndSendAnalyticsEvents(token, batch);
        List<AnalyticsEvent> successfullySentEvents = sentAnalyticsEvents.getSuccessfullySentEvents();
        List<AnalyticsEvent> unsuccessfullySentEvents = sentAnalyticsEvents.getUnsuccessfullySentEvents();
        if (!successfullySentEvents.isEmpty()) {
            log.debug("Removing batch of {} analytics events from {}.", (Object)batch.size(), (Object)successfullySentEvents.size());
            this.analyticsEventStore.deleteAnalyticsEvents(successfullySentEvents);
        }
        if (!unsuccessfullySentEvents.isEmpty()) {
            throw new MigrationAnalyticsEventRefusedException("Migration analytics actively refused events. They'll be locally preserved for a future retry.");
        }
        return batch.size() == configuredBatchSize;
    }

    private JobRunnerResponse error(RuntimeException e) {
        log.error("An unhandled exception occurred when processing a AnalyticsEventConsumer job request. Reason: {}", (Object)e.getMessage(), (Object)e);
        return JobRunnerResponse.failed((String)("AnalyticsEventConsumer job failed with reason " + e.getMessage()));
    }

    private int maxWait() {
        return this.agentConfiguration.getAnalyticsSenderMaxWaitInMinutes();
    }

    private Instant getMaxProcessingTime() {
        return this.instantSupplier.get().plus(Duration.ofMillis(this.jobInterval()));
    }

    private int getConfiguredBatchSize() {
        Integer migrationAnalyticsBatchSize = this.migrationDarkFeaturesManager.getMigrationAnalyticsBatchSize();
        log.info("Configured migration analytics batch size: {}", (Object)migrationAnalyticsBatchSize);
        return migrationAnalyticsBatchSize;
    }

    private long jobInterval() {
        Integer migrationAnalyticsJobIntervalInSeconds = this.migrationDarkFeaturesManager.getMigrationAnalyticsJobIntervalInSeconds();
        log.info("Configured migration analytics job interval in seconds: {}", (Object)migrationAnalyticsJobIntervalInSeconds);
        return Duration.ofSeconds(migrationAnalyticsJobIntervalInSeconds.intValue()).toMillis();
    }

    private synchronized Instant getLastEventSubmission() {
        return this.lastEventSubmission;
    }

    private synchronized void setLastEventSubmission(Instant lastEventSubmission) {
        this.lastEventSubmission = lastEventSubmission;
    }
}

