/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.PackedSpacesTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.exception.SpacePackingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePackingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpacePackingService.class);
    private final StatisticsService statisticsService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public SpacePackingService(StatisticsService statisticsService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.statisticsService = statisticsService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public List<AbstractSpaceTask> applySpacePackingLogic(Plan plan) {
        log.info("Applying space packing logic for plan: {}", (Object)plan.getId());
        List<ConfluenceSpaceTask> confluenceSpaceTasks = this.getConfluenceSpaceTasksFromPlan(plan);
        log.info("Found {} ConfluenceSpaceTask in plan", (Object)confluenceSpaceTasks.size());
        int minSpacesForPacking = this.getMinSpacesForPacking();
        if (confluenceSpaceTasks.size() < minSpacesForPacking) {
            log.info("Plan contains less than {} space tasks, skipping packing", (Object)minSpacesForPacking);
            return new ArrayList<AbstractSpaceTask>(confluenceSpaceTasks);
        }
        return this.packSpacesByPageCount(confluenceSpaceTasks);
    }

    private List<ConfluenceSpaceTask> getConfluenceSpaceTasksFromPlan(Plan plan) {
        return plan.getSpaceTaskOfPlan().stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).collect(Collectors.toList());
    }

    private List<AbstractSpaceTask> packSpacesByPageCount(List<ConfluenceSpaceTask> spaceTasks) {
        int maxPagesPerPack = this.getMaxPagesPerPack();
        log.info("Starting space packing for {} tasks with maxPagesPerPack {}", (Object)spaceTasks.size(), (Object)maxPagesPerPack);
        ArrayList<SpaceWithPageCount> packableSpaces = new ArrayList<SpaceWithPageCount>();
        ArrayList<ConfluenceSpaceTask> singleSpaceTasks = new ArrayList<ConfluenceSpaceTask>();
        for (ConfluenceSpaceTask confluenceSpaceTask : spaceTasks) {
            Long spacePageCount = this.getPageCountForSpace(confluenceSpaceTask.getSpaceKey());
            if (spacePageCount > (long)maxPagesPerPack) {
                singleSpaceTasks.add(confluenceSpaceTask);
                continue;
            }
            packableSpaces.add(new SpaceWithPageCount(confluenceSpaceTask, spacePageCount));
        }
        packableSpaces.sort(Comparator.comparingLong(SpaceWithPageCount::getPageCount).reversed());
        log.info("Sorted {} packable spaces by page count", (Object)packableSpaces.size());
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (SpaceWithPageCount spaceWithPageCount : packableSpaces) {
            boolean placed = false;
            for (Pack pack : packs) {
                if (!pack.canAddSpace(spaceWithPageCount, maxPagesPerPack)) continue;
                pack.addSpace(spaceWithPageCount);
                placed = true;
                break;
            }
            if (placed) continue;
            Pack newPack = new Pack();
            newPack.addSpace(spaceWithPageCount);
            packs.add(newPack);
        }
        ArrayList<AbstractSpaceTask> arrayList = new ArrayList<AbstractSpaceTask>();
        for (Pack pack : packs) {
            arrayList.add(pack.createSpaceTask());
        }
        arrayList.addAll(singleSpaceTasks);
        log.info("Space packing completed. Created total {} Space Tasks from {} spaces", (Object)arrayList.size(), (Object)spaceTasks.size());
        return arrayList;
    }

    private Long getPageCountForSpace(String spaceKey) {
        SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(spaceKey);
        if (spaceStats == null) {
            log.error("No statistics found for space {}", (Object)spaceKey);
            throw new SpacePackingException("No statistics found for space " + spaceKey);
        }
        Long pageCount = spaceStats.getSummary().getNumberOfPages();
        if (pageCount == null) {
            log.error("Page count is null for space {}", (Object)spaceKey);
            throw new SpacePackingException("Page count is null for space " + spaceKey);
        }
        return pageCount;
    }

    private int getMinSpacesForPacking() {
        return this.migrationDarkFeaturesManager.getMinSpacesForSpacePacking();
    }

    private int getMaxPagesPerPack() {
        return this.migrationDarkFeaturesManager.getMaxPagesPerPack();
    }

    private static class SpaceWithPageCount {
        private final ConfluenceSpaceTask spaceTask;
        private final Long pageCount;

        public SpaceWithPageCount(ConfluenceSpaceTask spaceTask, Long pageCount) {
            this.spaceTask = spaceTask;
            this.pageCount = pageCount;
        }

        public ConfluenceSpaceTask getSpaceTask() {
            return this.spaceTask;
        }

        public Long getPageCount() {
            return this.pageCount;
        }
    }

    private static class Pack {
        private final List<SpaceWithPageCount> spaces = new ArrayList<SpaceWithPageCount>();
        private int totalPageCount = 0;

        public boolean canAddSpace(SpaceWithPageCount space, int maxPagesPerPack) {
            return this.spaces.size() < 25 && (long)this.totalPageCount + space.getPageCount() <= (long)maxPagesPerPack;
        }

        public void addSpace(SpaceWithPageCount space) {
            this.spaces.add(space);
            this.totalPageCount = (int)((long)this.totalPageCount + space.getPageCount());
        }

        public AbstractSpaceTask createSpaceTask() {
            List<ConfluenceSpaceTask> spaceTasks = this.spaces.stream().map(SpaceWithPageCount::getSpaceTask).collect(Collectors.toList());
            if (spaceTasks.size() == 1) {
                return (AbstractSpaceTask)spaceTasks.get(0);
            }
            PackedSpacesTask packedSpacesTask = new PackedSpacesTask();
            List spaceKeys = spaceTasks.stream().map(AbstractSpaceTask::getSpaceKey).collect(Collectors.toList());
            packedSpacesTask.setSpaceKeys(String.join((CharSequence)",", spaceKeys));
            ConfluenceSpaceTask firstTask = (ConfluenceSpaceTask)spaceTasks.get(0);
            packedSpacesTask.setContainerId(firstTask.getContainerId());
            packedSpacesTask.setWeight(this.calculateTotalWeight(spaceTasks));
            return packedSpacesTask;
        }

        private int calculateTotalWeight(List<ConfluenceSpaceTask> spaceTasks) {
            return spaceTasks.stream().mapToInt(Task::getWeight).sum();
        }
    }
}

