/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.ScanSummaryDto;
import com.atlassian.migration.agent.rest.ContainerTokenState;
import com.atlassian.migration.agent.rest.UserBaseScanResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="userbase")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserBaseScanResourceJakarta {
    private final UserBaseScanResource originalResource;

    @Inject
    public UserBaseScanResourceJakarta(UserBaseScanResource originalResource) {
        this.originalResource = originalResource;
    }

    @POST
    @Path(value="/scan/{cloudId}")
    public Response scanUserBase(@PathParam(value="cloudId") String cloudId) {
        Pair<Boolean, ContainerTokenState> scanUserResult = this.originalResource.scanUserBaseDto(cloudId);
        if (Boolean.TRUE.equals(scanUserResult.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<Response> responseWhenNotValid = ((ContainerTokenState)((Object)scanUserResult.getRight())).toJakartaResponseWhenNotValid();
        return responseWhenNotValid.orElseGet(() -> Response.status((Response.Status)Response.Status.ACCEPTED).build());
    }

    @GET
    @Path(value="/scan/summary")
    public Response getScanSummary() {
        Pair<Boolean, ScanSummaryDto> summaryResponse = this.originalResource.getScanSummaryDto();
        if (Boolean.TRUE.equals(summaryResponse.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)summaryResponse.getRight()).build();
    }
}

