/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.RequestValidationException;
import com.atlassian.migration.agent.rest.ErrorResponse;
import com.atlassian.migration.agent.rest.ErrorResponseCode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class RequestValidationExceptionMapperJakarta
implements ExceptionMapper<RequestValidationException> {
    private static final Logger log = LoggerFactory.getLogger(RequestValidationExceptionMapperJakarta.class);

    public Response toResponse(RequestValidationException ex) {
        log.error("Failed to process request because of invalid parameters in request", (Throwable)ex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorResponse(ErrorResponseCode.INVALID_PARAMETER, ex.getMessage())).build();
    }
}

