/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.mma.model.token.SaveTokenRequest;
import com.atlassian.migration.agent.rest.CloudResource;
import com.atlassian.migration.agent.rest.GenerateCloudSiteSetupUrlDto;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="cloud")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CloudResourceJakarta {
    private final CloudResource originalResource;

    @Inject
    public CloudResourceJakarta(CloudResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/")
    public Response getSites() {
        List<CloudSiteDto> result = this.originalResource.getSitesDto();
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/rememberLegalOptIn")
    public void rememberLegalOptIn() {
        this.originalResource.rememberLegalOptInDto();
    }

    @DELETE
    @Path(value="/rememberLegalOptIn")
    public void forgetLegalOptIn() {
        this.originalResource.forgetLegalOptInDto();
    }

    @GET
    @Path(value="/rememberLegalOptIn")
    public Response getRememberLegalOptIn() {
        Object result = this.originalResource.getRememberLegalOptInDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/generateCloudSiteSetupUrl")
    public Response generateCloudSiteSetupUrl(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        String result = this.originalResource.generateCloudSiteSetupUrlDto(cloudSiteSetupDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/generateEctlRedirectUrl")
    public Response generateEctlRedirectUrl(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        String result = this.originalResource.generateEctlRedirectUrlDto(cloudSiteSetupDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="save/token")
    public Response saveToken(SaveTokenRequest saveTokenRequest) {
        Pair<Integer, Object> response = this.originalResource.saveTokenDto(saveTokenRequest);
        return Response.status((int)((Integer)response.getLeft())).entity(response.getRight()).build();
    }
}

