/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mma.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.event.events.user.UserEvent;
import com.atlassian.confluence.event.events.user.UserRemoveEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.UserDomainCountDto;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.dto.UserDomainRulesetDto;
import com.atlassian.migration.agent.dto.assessment.AppListResponse;
import com.atlassian.migration.agent.dto.assessment.AppSummaryDto;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.entity.SpaceStatistic;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.mma.model.AppMetadata;
import com.atlassian.migration.agent.mma.model.DomainMetadataDTO;
import com.atlassian.migration.agent.mma.model.EntityActionDTO;
import com.atlassian.migration.agent.mma.model.GlobalTemplateCount;
import com.atlassian.migration.agent.mma.model.MetadataEntityResult;
import com.atlassian.migration.agent.mma.model.MetadataRefreshState;
import com.atlassian.migration.agent.mma.model.MetadataRefreshStatus;
import com.atlassian.migration.agent.mma.model.MetadataType;
import com.atlassian.migration.agent.mma.model.ProductLicense;
import com.atlassian.migration.agent.mma.model.ServerInstanceDTO;
import com.atlassian.migration.agent.mma.model.SpaceMetadata;
import com.atlassian.migration.agent.mma.model.SpaceMetadataDTO;
import com.atlassian.migration.agent.mma.model.processor.MetadataBatch;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.ServerMetadataAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceLicenseDetails;
import com.atlassian.migration.agent.service.event.AppAssessmentUpdatedEvent;
import com.atlassian.migration.agent.service.extract.GlobalEntityExtractionService;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.DefaultSpaceStatistics;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.migration.agent.service.prc.model.RetryCMAState;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.store.CloudSiteStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.sql.Timestamp;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class MigrationMetadataAggregatorService {
    private final SystemInformationService sysInfoService;
    private final PluginVersionManager pluginVersionManager;
    private final LicenseHandler licenseHandler;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final SpaceStore spaceStore;
    private final CloudSiteStore cloudSiteStore;
    private final EventPublisher eventPublisher;
    private final AppAssessmentFacade appAssessmentFacade;
    private final DefaultSpaceStatistics defaultSpaceStatistics;
    private final ExecutorService executorService;
    private final GlobalEntityExtractionService globalEntityExtractionService;
    private final LabelManager labelManager;
    private final UserDomainService userDomainService;
    private final Clock clock;
    private static final Logger log = ContextLoggerFactory.getLogger(MigrationMetadataAggregatorService.class);
    private static final String CONFLUENCE_SERVER_PRODUCT_KEY = "confluence-server";
    private static final DomainRuleBehaviour DEFAULT_DOMAIN_RULE = DomainRuleBehaviour.NO_DECISION_MADE;
    static final int BATCH_SIZE_METADATA = 1000;
    @VisibleForTesting
    public AtomicBoolean isDomainRefreshPending;

    public MigrationMetadataAggregatorService(SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, LicenseHandler licenseHandler, EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceStore spaceStore, CloudSiteStore cloudSiteStore, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, EventPublisher eventPublisher, DefaultSpaceStatistics defaultSpaceStatistics, AppAssessmentFacade appAssessmentFacade, GlobalEntityExtractionService globalEntityExtractionService, LabelManager labelManager, UserDomainService userDomainService) {
        this(sysInfoService, pluginVersionManager, licenseHandler, enterpriseGatekeeperClient, migrationDarkFeaturesManager, spaceStore, cloudSiteStore, analyticsEventBuilder, analyticsEventService, eventPublisher, defaultSpaceStatistics, appAssessmentFacade, globalEntityExtractionService, labelManager, userDomainService, Clock.systemUTC());
    }

    @VisibleForTesting
    MigrationMetadataAggregatorService(SystemInformationService sysInfoService, PluginVersionManager pluginVersionManager, LicenseHandler licenseHandler, EnterpriseGatekeeperClient enterpriseGatekeeperClient, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceStore spaceStore, CloudSiteStore cloudSiteStore, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService, EventPublisher eventPublisher, DefaultSpaceStatistics defaultSpaceStatistics, AppAssessmentFacade appAssessmentFacade, GlobalEntityExtractionService globalEntityExtractionService, LabelManager labelManager, UserDomainService userDomainService, Clock clock) {
        this.sysInfoService = sysInfoService;
        this.pluginVersionManager = pluginVersionManager;
        this.licenseHandler = licenseHandler;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.spaceStore = spaceStore;
        this.cloudSiteStore = cloudSiteStore;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
        this.eventPublisher = eventPublisher;
        this.defaultSpaceStatistics = defaultSpaceStatistics;
        this.appAssessmentFacade = appAssessmentFacade;
        this.executorService = Executors.newSingleThreadExecutor(new GroupedThreadFactory("MigrationMetadataAggregatorService"));
        this.globalEntityExtractionService = globalEntityExtractionService;
        this.labelManager = labelManager;
        this.userDomainService = userDomainService;
        this.clock = clock;
        this.isDomainRefreshPending = new AtomicBoolean(false);
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    void init() {
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    void cleanup() {
        this.eventPublisher.unregister((Object)this);
        this.executorService.shutdown();
    }

    public void sendServerInstanceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.upsertServerInstanceCloudSitePairInMMA(site.getContainerToken(), site.getCloudId()));
    }

    public MetadataRefreshStatus upsertServerInstanceCloudSitePairInMMA(String containerToken, String cloudId) {
        ServerInstanceDTO serverInstance = this.mapServerInstanceDto(cloudId);
        MetadataBatch<ServerInstanceDTO> batchServerInstanceDTO = new MetadataBatch<ServerInstanceDTO>(serverInstance);
        long startTime = System.currentTimeMillis();
        try {
            List<EntityActionDTO> response = this.enterpriseGatekeeperClient.sendServerInstanceInfoToMigrationMetadataAggregator(containerToken, cloudId, batchServerInstanceDTO);
            if (!response.stream().allMatch(EntityActionDTO::isSuccess)) {
                throw new RuntimeException(String.format("Error upserting Server in MMA: [%s]", response.stream().filter(r -> !r.isSuccess()).map(EntityActionDTO::getError).collect(Collectors.toList())));
            }
            log.info("Sent request to MMA for Server Instance\n[{}]", batchServerInstanceDTO);
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, System.currentTimeMillis() - startTime, Optional.empty());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            return MetadataRefreshStatus.SUCCESS;
        }
        catch (Exception e) {
            log.error("Failed to send server instance metadata to MMA for cloud [{}].", (Object)cloudId, (Object)e);
            EventDto analyticEvent = this.analyticsEventBuilder.buildServerMetadataEvent(cloudId, System.currentTimeMillis() - startTime, Optional.of(e));
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
            return MetadataRefreshStatus.FAILURE;
        }
    }

    private ServerInstanceDTO mapServerInstanceDto(String cloudId) {
        return ServerInstanceDTO.builder().cloudId(cloudId).serverId(this.sysInfoService.getConfluenceInfo().getServerId()).supportEntitlementNumber(this.sysInfoService.getConfluenceInfo().getSupportEntitlementNumber()).productVersion(this.sysInfoService.getConfluenceInfo().getVersion()).serverBaseUrl(this.sysInfoService.getConfluenceInfo().getBaseUrl()).cmaVersion(this.pluginVersionManager.getPluginVersion()).organizationName(this.getOrganisationName()).productKey(CONFLUENCE_SERVER_PRODUCT_KEY).userCount(this.sysInfoService.getUsageInfo().getLocalUsers()).licenseDetails(this.buildLicenseDetails()).globalTemplateCount(this.getGlobalTemplateCount()).build();
    }

    private GlobalTemplateCount getGlobalTemplateCount() {
        return new GlobalTemplateCount(this.globalEntityExtractionService.getGlobalTemplatesCount(), this.globalEntityExtractionService.getSystemTemplatesCount());
    }

    private List<ProductLicense> buildLicenseDetails() {
        return Optional.ofNullable(this.licenseHandler.getProductLicenseDetails("conf")).map(ConfluenceLicenseDetails::from).map(ProductLicense::from).map(Collections::singletonList).orElse(null);
    }

    private String getOrganisationName() {
        return this.licenseHandler.getAllProductLicenses().stream().map(BaseLicenseDetails::getOrganisationName).findFirst().orElse(null);
    }

    public void sendSpaceMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMA(site.getContainerToken(), site.getCloudId(), serverId));
    }

    public void sendAppMetadataToMMAForAllCloudSites() {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        nonFailingCloudSites.forEach(site -> this.sendAppMetadataToMMA(site.getContainerToken(), site.getCloudId(), serverId));
    }

    public void deleteSpaceMetadata(String containerToken, String cloudId, String serverId) {
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
            log.info("Deleted Spaces in MMA for Cloud/Server ID pair [{},{}].", (Object)cloudId, (Object)serverId);
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, ex, null);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public MetadataRefreshStatus sendSpaceMetadataToMMA(String containerToken, String cloudId, String serverId) {
        this.deleteSpaceMetadata(containerToken, cloudId, serverId);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List<Object> spaceMetadata = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        try {
            spaceMetadata = this.buildSpaceMetadata(cloudId, serverId);
            List responses = Lists.partition(spaceMetadata, (int)1000).stream().map(spaceMetadataChunk -> {
                try {
                    return this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<SpaceMetadataDTO>((List<SpaceMetadataDTO>)spaceMetadataChunk));
                }
                catch (Exception e) {
                    log.error("There was an error sending a batch of metadata to MMA: {}", (Object)e.getMessage());
                    exceptions.add(e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("Emitted latest Space metadata to MMA. Sent [{}] spaces in [{}] successful batches", (Object)spaceMetadata.size(), (Object)responses.size());
            MetadataRefreshStatus metadataRefreshStatus = exceptions.isEmpty() ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
            return metadataRefreshStatus;
        }
        catch (Exception e) {
            exceptions.add(e);
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, 1000, spaceMetadata.size(), exceptions);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    @VisibleForTesting
    public List<SpaceMetadataDTO> buildSpaceMetadata(String cloudId, String serverId) {
        Map<Long, List<String>> spaceTeamLabels = this.spaceStore.getSpaceCategories();
        return this.spaceStore.getSpaceMetadata().stream().map(s -> new SpaceMetadataDTO((SpaceMetadata)s, spaceTeamLabels.getOrDefault(s.getSpaceId(), Collections.emptyList()), cloudId, serverId)).collect(Collectors.toList());
    }

    public void deleteAppMetadata(String containerToken, String cloudId, String serverId) {
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            this.enterpriseGatekeeperClient.deleteAppMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
            log.info("Deleted Apps in MMA for Cloud/Server ID pair [{},{}].", (Object)cloudId, (Object)serverId);
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, System.currentTimeMillis() - startTime, ex, null);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public void deleteDomainMetadata(String containerToken, String cloudId, String serverId) {
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            this.enterpriseGatekeeperClient.deleteDomainMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId);
            log.info("Deleted Domain in MMA for Cloud/Server ID pair [{},{}].", (Object)cloudId, (Object)serverId);
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.DOMAINS, System.currentTimeMillis() - startTime, ex, null);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public MetadataRefreshStatus sendAppMetadataToMMA(String containerToken, String cloudId, String serverId) {
        this.deleteAppMetadata(containerToken, cloudId, serverId);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        List appMetadata = Collections.emptyList();
        long startTime = System.currentTimeMillis();
        try {
            AppListResponse<AppSummaryDto> apps = this.appAssessmentFacade.getPlugins();
            appMetadata = apps.getApps().stream().map(app -> new AppMetadata((AppSummaryDto)app, cloudId, serverId)).collect(Collectors.toList());
            List responses = Lists.partition(appMetadata, (int)1000).stream().map(appMetadataChunk -> {
                try {
                    return this.enterpriseGatekeeperClient.sendAppMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<AppMetadata>((List<AppMetadata>)appMetadataChunk));
                }
                catch (Exception e) {
                    log.error("There was an error sending a batch of metadata to MMA: {}", (Object)e.getMessage());
                    exceptions.add(e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("Emitted latest App metadata to MMA. Sent [{}] app in [{}] successful batches", (Object)appMetadata.size(), (Object)responses.size());
            MetadataRefreshStatus metadataRefreshStatus = exceptions.isEmpty() ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
            return metadataRefreshStatus;
        }
        catch (Exception e) {
            exceptions.add(e);
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.APPS, System.currentTimeMillis() - startTime, 1000, appMetadata.size(), exceptions);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    public void replaceAllMetadata(String cloudId, RetryCMAState retryCMAState) {
        this.performMetadataRefresh(cloudId, retryCMAState);
    }

    public void replaceAllMetadata(String cloudId) {
        this.performMetadataRefresh(cloudId, RetryCMAState.createRetryCMAStateForConfluence());
    }

    private void performMetadataRefresh(String cloudId, RetryCMAState retryCMAState) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            log.warn("Discarding request to update all metadata in cloud because cloud first migrations is not enabled.");
        } else {
            Optional<Exception> maybeFailure = Optional.empty();
            long startTime = this.clock.millis();
            try {
                String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
                Optional<CloudSite> cloudSite = this.cloudSiteStore.getByCloudId(cloudId);
                if (!cloudSite.isPresent()) {
                    throw new IllegalArgumentException(String.format("The given cloud site (%s) does not exist or hasn't been connected to this server.", cloudId));
                }
                String validToken = cloudSite.get().getContainerToken();
                HashMap<MetadataType, MetadataEntityResult> results = this.performMetadataRefresh(cloudId, validToken, serverId, retryCMAState);
                this.sendStatusUpdate(cloudSite.get().getContainerToken(), cloudId, serverId, results);
            }
            catch (Exception e) {
                maybeFailure = Optional.of(e);
                throw e;
            }
            finally {
                long timeTaken = this.clock.millis() - startTime;
                EventDto eventDto = this.analyticsEventBuilder.buildMetadataReplaceEvent(cloudId, timeTaken, maybeFailure);
                this.analyticsEventService.saveAnalyticsEvent(eventDto);
            }
        }
    }

    private HashMap<MetadataType, MetadataEntityResult> performMetadataRefresh(String cloudId, String validToken, String serverId, RetryCMAState retryCMAState) {
        HashMap<MetadataType, MetadataEntityResult> results = new HashMap<MetadataType, MetadataEntityResult>();
        MetadataEntityResult serverInstanceResult = this.getMetadataResultForPartialRefresh(retryCMAState.getShouldRetryServerInstance(), () -> this.upsertServerInstanceCloudSitePairInMMA(validToken, cloudId));
        results.put(MetadataType.SERVER_INSTANCE, serverInstanceResult);
        MetadataEntityResult spaceResult = this.getMetadataResultForPartialRefresh(retryCMAState.getShouldRetrySpaces(), () -> this.sendSpaceMetadataToMMA(validToken, cloudId, serverId));
        results.put(MetadataType.SPACES, spaceResult);
        MetadataEntityResult appResult = this.getMetadataResultForPartialRefresh(retryCMAState.getShouldRetryApps(), () -> this.sendAppMetadataToMMA(validToken, cloudId, serverId));
        results.put(MetadataType.APPS, appResult);
        if (this.migrationDarkFeaturesManager.isCloudFirstMigrationDomainReviewEnabled()) {
            MetadataEntityResult domainResult = this.getMetadataResultForPartialRefresh(retryCMAState.getShouldRetryDomains(), () -> this.sendDomainMetadataToMMA(validToken, cloudId, serverId));
            results.put(MetadataType.DOMAINS, domainResult);
        } else {
            results.put(MetadataType.DOMAINS, new MetadataEntityResult(MetadataRefreshStatus.NOT_ENABLED));
        }
        return results;
    }

    public MetadataRefreshStatus sendDomainMetadataToMMA(String containerToken, String cloudId, String serverId) {
        this.deleteDomainMetadata(containerToken, cloudId, serverId);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        long startTime = System.currentTimeMillis();
        List<Object> domainMetadata = Collections.emptyList();
        try {
            domainMetadata = this.buildDomainMetadataDTO(serverId, cloudId);
            List responses = Lists.partition(domainMetadata, (int)1000).stream().map(domainMetadataChunk -> {
                try {
                    return this.enterpriseGatekeeperClient.sendDomainMetadataToMigrationMetadataAggregator(containerToken, cloudId, new MetadataBatch<DomainMetadataDTO>((List<DomainMetadataDTO>)domainMetadataChunk));
                }
                catch (Exception e) {
                    log.error("There was an error sending a domain batch of metadata to MMA: {}", (Object)e.getMessage());
                    exceptions.add(e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("Emitted latest Domain metadata to MMA. Sent [{}] app in [{}] successful batches", (Object)domainMetadata.size(), (Object)responses.size());
            MetadataRefreshStatus metadataRefreshStatus = exceptions.isEmpty() ? MetadataRefreshStatus.SUCCESS : MetadataRefreshStatus.FAILURE;
            return metadataRefreshStatus;
        }
        catch (Exception e) {
            exceptions.add(e);
            throw e;
        }
        finally {
            EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.DOMAINS, System.currentTimeMillis() - startTime, 1000, domainMetadata.size(), exceptions);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
        }
    }

    private List<DomainMetadataDTO> buildDomainMetadataDTO(String serverId, String cloudId) {
        List<UserDomainCountDto> userDomainCounts = this.userDomainService.getUserDomainCountsInternal();
        UserDomainRulesetDto rulesetDto = this.userDomainService.getDomainRules();
        Map<String, DomainRuleBehaviour> domainRuleMap = rulesetDto.getDomains().stream().collect(Collectors.toMap(UserDomainRuleDto::getDomainName, UserDomainRuleDto::getRule));
        return userDomainCounts.stream().map(countDto -> {
            DomainRuleBehaviour rule = domainRuleMap.getOrDefault(countDto.getDomainName(), DEFAULT_DOMAIN_RULE);
            return new DomainMetadataDTO(serverId, cloudId, countDto.getDomainName(), countDto.getUserCount(), rule);
        }).collect(Collectors.toList());
    }

    private MetadataEntityResult getMetadataResultForPartialRefresh(boolean shouldRetry, Supplier<MetadataRefreshStatus> supplier) {
        return shouldRetry ? new MetadataEntityResult(supplier.get()) : new MetadataEntityResult(MetadataRefreshStatus.NO_REFRESH_REQUESTED);
    }

    public void sendStatusUpdate(String containerToken, String cloudId, String serverId, @NotNull @jakarta.validation.constraints.NotNull Map<MetadataType, MetadataEntityResult> metadataStatus) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        MetadataRefreshState refreshState = new MetadataRefreshState(metadataStatus);
        this.enterpriseGatekeeperClient.sendRefreshStatusUpdtateToMigrationMetadataAggregatorForSingleEntity(containerToken, cloudId, serverId, refreshState);
    }

    @EventListener
    public void spaceCreatedEventHandler(SpaceCreateEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceCreatedEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in creating the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    @EventListener
    public void appAssessmentUpdatedEventHandler(AppAssessmentUpdatedEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.sendAppMetadataToMMAForAllCloudSites();
            }
            catch (Exception e) {
                log.error("There was an error in updating the app assessment for apps in MMA: {}", (Object)e.getMessage());
            }
        });
    }

    public void handleSpaceCreatedEvent(SpaceCreateEvent event) {
        SpaceStatistic defaultMetadata = this.defaultSpaceStatistics.createDefaultStats(event.getSpace().getId(), event.getSpace().getLastModificationDate());
        SpaceMetadata changedSpaceMetadata = new SpaceMetadata(event.getSpace().getId(), event.getSpace().getKey(), event.getSpace().getName(), event.getSpace().getType(), defaultMetadata.getSumOfPageBlogDraftCount(), defaultMetadata.getAttachmentSize(), defaultMetadata.getAttachmentCount(), defaultMetadata.getEstimatedMigrationTime(), new Timestamp(event.getSpace().getLastModificationDate().getTime()), defaultMetadata.getTeamCalendarCount());
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        List labelsResult = this.labelManager.getTeamLabelsForSpace(event.getSpace().getKey());
        List<String> spaceLabels = this.extractLabelName(labelsResult);
        nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(changedSpaceMetadata, spaceLabels, site.getContainerToken(), site.getCloudId()));
    }

    private List<String> extractLabelName(Object labelsResult) {
        List labelsList;
        if (labelsResult instanceof List && !(labelsList = (List)labelsResult).isEmpty()) {
            Object firstItem = labelsList.get(0);
            if (firstItem instanceof String) {
                return labelsList;
            }
            if (firstItem instanceof Label) {
                return labelsList.stream().map(label -> ((Label)label).getName()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public void sendSpaceMetadataToMMAForSingleEntity(SpaceMetadata changedSpaceMetadata, List<String> spaceLabels, String containerToken, String cloudId) {
        long startTime = System.currentTimeMillis();
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        SpaceMetadataDTO metadataToSend = new SpaceMetadataDTO(changedSpaceMetadata, spaceLabels, cloudId, serverId);
        Exception exception = null;
        try {
            this.enterpriseGatekeeperClient.sendSpaceMetadataToMigrationMetadataAggregatorForSingleEntity(containerToken, cloudId, serverId, metadataToSend);
        }
        catch (Exception e) {
            log.error("There was an error sending metadata for spaceId {} to MMA: {}", (Object)metadataToSend.getSpaceId(), (Object)e.getMessage());
            exception = e;
        }
        EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.UPDATED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, startTime - System.currentTimeMillis(), exception, 1);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
    }

    public void sendAllDomainsToMMAEvent(UserEvent userEvent) {
        this.sendAllDomainsToMMAEvent(userEvent, null);
    }

    public void sendAllDomainsToMMAEvent(UserEvent userEvent, @javax.annotation.Nullable @Nullable CountDownLatch latch) {
        CountDownLatch countDownLatch;
        CountDownLatch countDownLatch2 = countDownLatch = latch != null ? latch : new CountDownLatch(1);
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled() || !this.migrationDarkFeaturesManager.isCloudFirstMigrationDomainReviewEnabled()) {
            return;
        }
        if (this.isDomainRefreshPending.compareAndSet(false, true)) {
            this.executorService.submit(() -> {
                try {
                    this.isDomainRefreshPending.set(false);
                    List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
                    nonFailingCloudSites.forEach(cloudSite -> {
                        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
                        String validToken = cloudSite.getContainerToken();
                        String cloudId = cloudSite.getCloudId();
                        this.sendDomainMetadataToMMA(validToken, cloudId, serverId);
                    });
                }
                catch (Exception e) {
                    log.error("There was an error in updating the domain metadata after a user event: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
    }

    @EventListener
    public void onDomainsActionEvent(UserCreateEvent event) {
        this.sendAllDomainsToMMAEvent((UserEvent)event);
    }

    @EventListener
    public void onDomainsActionEvent(UserRemoveEvent event) {
        this.sendAllDomainsToMMAEvent((UserEvent)event);
    }

    @EventListener
    public void spaceRemoveEventHandler(SpaceRemoveEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceRemoveEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in removing the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    @EventListener
    public void labelAddEventHandler(LabelAddEvent event) {
        if (this.shouldHandleLabelEvent((LabelEvent)event)) {
            this.handleLabelEvent((LabelEvent)event);
        }
    }

    @EventListener
    public void labelRemoveEventHandler(LabelRemoveEvent event) {
        if (this.shouldHandleLabelEvent((LabelEvent)event)) {
            this.handleLabelEvent((LabelEvent)event);
        }
    }

    private boolean shouldHandleLabelEvent(LabelEvent event) {
        return this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled() && event.getLabel().getNamespace().equals((Object)Namespace.TEAM) && event.getLabelled() instanceof SpaceDescription;
    }

    private void handleLabelEvent(LabelEvent labelEvent) {
        SpaceDescription sd = (SpaceDescription)labelEvent.getLabelled();
        this.executorService.submit(() -> {
            try {
                this.updateCategoriesForSpace(sd.getSpace());
            }
            catch (Exception e) {
                log.error("There was an error updating the labels for spaceId {} in MMA: {}", (Object)sd.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    private void updateCategoriesForSpace(Space space) {
        SpaceMetadata spaceMetadata = this.spaceStore.getSpaceMetadataForIndividualSpace(space.getId());
        List<String> spaceLabelNames = this.getCategoriesForSpace(space);
        this.cloudSiteStore.getNonFailingSites().forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(spaceMetadata, spaceLabelNames, site.getContainerToken(), site.getCloudId()));
    }

    private List<String> getCategoriesForSpace(Space space) {
        List spaceLabels = this.labelManager.getTeamLabelsForSpace(space.getKey());
        return spaceLabels.stream().map(Label::getName).collect(Collectors.toList());
    }

    public void handleSpaceRemoveEvent(SpaceRemoveEvent event) {
        long spaceId = event.getSpace().getId();
        List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        nonFailingCloudSites.forEach(site -> this.deleteSpaceMetadataFromMMAForSingleEntity(site.getContainerToken(), site.getCloudId(), serverId, spaceId));
    }

    public void deleteSpaceMetadataFromMMAForSingleEntity(String containerToken, String cloudId, String serverId, long spaceId) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        try {
            this.enterpriseGatekeeperClient.deleteSpaceMetadataFromMigrationMetadataAggregator(containerToken, cloudId, serverId, spaceId);
        }
        catch (Exception e) {
            log.error("There was an error deleting metadata in MMA for a spaceId {}: {}", (Object)spaceId, (Object)e.getMessage());
            exception = e;
        }
        EventDto analyticEvent = this.analyticsEventBuilder.buildMetadataEvent(cloudId, ServerMetadataAnalyticsEventBuilder.ActionType.DELETED, ServerMetadataAnalyticsEventBuilder.ActionSubject.SPACES, startTime - System.currentTimeMillis(), exception, 1);
        this.analyticsEventService.saveAnalyticsEventAsync(() -> analyticEvent);
    }

    @EventListener
    public void spaceUpdateEventHandler(SpaceUpdateEvent event) {
        if (!this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
            return;
        }
        this.executorService.submit(() -> {
            try {
                this.handleSpaceUpdateEvent(event);
            }
            catch (Exception e) {
                log.error("There was an error in updating the metadata for spaceId {} in MMA: {}", (Object)event.getSpace().getId(), (Object)e.getMessage());
            }
        });
    }

    public void handleSpaceUpdateEvent(SpaceUpdateEvent event) {
        if (!event.getOriginalSpace().getName().equals(event.getSpace().getName())) {
            SpaceMetadata oldSpaceMetadata = this.spaceStore.getSpaceMetadataForIndividualSpace(event.getOriginalSpace().getId());
            SpaceMetadata changedSpaceMetadata = new SpaceMetadata(event.getSpace().getId(), event.getSpace().getKey(), event.getSpace().getName(), event.getSpace().getType(), oldSpaceMetadata.getSumOfPageBlogDraftCount(), oldSpaceMetadata.getAttachmentSize(), oldSpaceMetadata.getAttachmentCount(), oldSpaceMetadata.getEstimatedMigrationTime(), new Timestamp(event.getSpace().getLastModificationDate().getTime()), oldSpaceMetadata.getTeamCalendarCount());
            List<CloudSite> nonFailingCloudSites = this.cloudSiteStore.getNonFailingSites();
            List<String> spaceLabels = this.getCategoriesForSpace(event.getSpace());
            nonFailingCloudSites.forEach(site -> this.sendSpaceMetadataToMMAForSingleEntity(changedSpaceMetadata, spaceLabels, site.getContainerToken(), site.getCloudId()));
        }
    }
}

