/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.TaskType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lombok.Generated;

@Entity
@DiscriminatorValue(value="PACKED_SPACES")
public class PackedSpacesTask
extends AbstractSpaceTask {
    @Column(name="spaceKeys")
    private String spaceKeys;

    public PackedSpacesTask() {
    }

    public PackedSpacesTask(PackedSpacesTask task) {
        super(task);
        this.spaceKeys = task.spaceKeys;
    }

    @Override
    public PackedSpacesTask copy() {
        return new PackedSpacesTask(this);
    }

    @Override
    public String getName() {
        if (this.spaceKeys != null && !this.spaceKeys.isEmpty()) {
            int count = this.spaceKeys.split(",").length;
            return String.format("Migrate %d packed spaces", count);
        }
        return "Migrate packed spaces";
    }

    @Override
    public TaskType getType() {
        return TaskType.PACKED_SPACES;
    }

    @Override
    public void onPostPersistOrUpdate() {
    }

    @Generated
    public String getSpaceKeys() {
        return this.spaceKeys;
    }

    @Generated
    public void setSpaceKeys(String spaceKeys) {
        this.spaceKeys = spaceKeys;
    }
}

