/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.compatibility;

import com.atlassian.migration.agent.service.ServiceInitializeException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExceptionMapperBridgeConfiguration {
    private static boolean isJakartaAvailable() {
        try {
            Class.forName("jakarta.ws.rs.ext.ExceptionMapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object newInstance(String fqcn) {
        try {
            return Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to instantiate provider '" + fqcn + "' in ExceptionMapperBridgeConfiguration", e);
        }
    }

    @Bean
    public Object invalidPlanExceptionMapperProvider() {
        String clazz = ExceptionMapperBridgeConfiguration.isJakartaAvailable() ? "com.atlassian.migration.agent.rest.InvalidPlanExceptionMapperJakarta" : "com.atlassian.migration.agent.rest.InvalidPlanExceptionMapper";
        return ExceptionMapperBridgeConfiguration.newInstance(clazz);
    }

    @Bean
    public Object incompatibleDarkFeatureExceptionMapperProvider() {
        String clazz = ExceptionMapperBridgeConfiguration.isJakartaAvailable() ? "com.atlassian.migration.agent.rest.IncompatibleDarkFeatureExceptionMapperJakarta" : "com.atlassian.migration.agent.rest.IncompatibleDarkFeatureExceptionMapper";
        return ExceptionMapperBridgeConfiguration.newInstance(clazz);
    }

    @Bean
    public Object jsonMappingExceptionMapperProvider() {
        String clazz = ExceptionMapperBridgeConfiguration.isJakartaAvailable() ? "com.atlassian.migration.agent.rest.JsonMappingExceptionMapperJakarta" : "com.atlassian.migration.agent.rest.JsonMappingExceptionMapper";
        return ExceptionMapperBridgeConfiguration.newInstance(clazz);
    }

    @Bean
    public Object queryFailedExceptionMapperProvider() {
        String clazz = ExceptionMapperBridgeConfiguration.isJakartaAvailable() ? "com.atlassian.migration.agent.rest.QueryFailedExceptionMapperJakarta" : "com.atlassian.migration.agent.rest.QueryFailedExceptionMapper";
        return ExceptionMapperBridgeConfiguration.newInstance(clazz);
    }
}

