/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.guardrails.macro.DefaultMacroResultSetConverter;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.service.guardrails.macro.StaticMacroInformation;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroAssessmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MacroAssessmentService.class);
    private final SystemInformationService sysInfoService;
    private final Set<MacroAssessmentSupplier<MacroTuple>> macroAssessmentSuppliers;
    private final EntityManagerTemplate entityManagerTemplate;

    public MacroAssessmentService(SystemInformationService sysInfoService, Set<MacroAssessmentSupplier<MacroTuple>> macroAssessmentSuppliers, EntityManagerTemplate entityManagerTemplate) {
        this.sysInfoService = sysInfoService;
        this.macroAssessmentSuppliers = macroAssessmentSuppliers;
        this.entityManagerTemplate = entityManagerTemplate;
    }

    public MacroAssessmentResult assess() {
        return this.assess(() -> false);
    }

    public MacroAssessmentResult assess(BooleanSupplier isAssessmentCanceled) {
        Set<MacroTuple> macroTuples = this.macroAssessmentSuppliers.parallelStream().flatMap(mas -> mas.fetch(isAssessmentCanceled)).collect(Collectors.toSet());
        return new DefaultMacroResultSetConverter(new StaticMacroInformation(), this.sysInfoService, this.entityManagerTemplate).convert(macroTuples);
    }

    public MacroAssessmentResult example() {
        ImmutableSet macroTuples = ImmutableSet.of((Object)new MacroTuple((Long)123L, (Long)1L, (Long)15L, "html", "PAGE"), (Object)new MacroTuple((Long)124L, (Long)1L, (Long)15L, "html-include", "COMMENT"), (Object)new MacroTuple((Long)125L, (Long)1L, (Long)17L, "viewxls", "BLOGPOST"), (Object)new MacroTuple((Long)126L, (Long)2L, (Long)21L, "change-history", "PAGE"));
        return new DefaultMacroResultSetConverter(new StaticMacroInformation(), this.sysInfoService, this.entityManagerTemplate).convert((Set<MacroTuple>)macroTuples);
    }
}

