/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import com.atlassian.migration.udc.common.model.usermapping.model.UserMappingConfigDTO;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class GlobalEmailFixesConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalEmailFixesConfigService.class);
    public static final String DUPLICATE_EMAILS_CONFIG = "duplicateEmailsConfig";
    public static final String INVALID_EMAILS_CONFIG = "invalidEmailsConfig";
    private final Supplier<PluginSettings> pluginSettingsSupplier = () -> ((PluginSettingsFactory)pluginSettingsFactory).createGlobalSettings();
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final com.atlassian.migration.udc.config.GlobalEmailFixesConfigService udcGlobalEmailFixesConfigService;

    public GlobalEmailFixesConfigService(PluginSettingsFactory pluginSettingsFactory, MigrationAgentConfiguration migrationAgentConfiguration, com.atlassian.migration.udc.config.GlobalEmailFixesConfigService udcGlobalEmailFixesConfigService) {
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.udcGlobalEmailFixesConfigService = udcGlobalEmailFixesConfigService;
    }

    public DuplicateEmailsConfigDto getDuplicateEmailsConfig() {
        String savedConfig = (String)this.pluginSettingsSupplier.get().get(this.getPluginKey(DUPLICATE_EMAILS_CONFIG));
        if (StringUtils.isNotBlank((CharSequence)savedConfig)) {
            return Jsons.readValue(savedConfig, DuplicateEmailsConfigDto.class);
        }
        return new DuplicateEmailsConfigDto();
    }

    public void saveDuplicateEmailsConfig(DuplicateEmailsConfigDto duplicateEmailsConfigDto) {
        this.pluginSettingsSupplier.get().put(this.getPluginKey(DUPLICATE_EMAILS_CONFIG), (Object)Jsons.valueAsString(duplicateEmailsConfigDto));
    }

    public InvalidEmailsConfigDto getInvalidEmailsConfig() {
        String savedConfig = (String)this.pluginSettingsSupplier.get().get(this.getPluginKey(INVALID_EMAILS_CONFIG));
        if (StringUtils.isNotBlank((CharSequence)savedConfig)) {
            return Jsons.readValue(savedConfig, InvalidEmailsConfigDto.class);
        }
        return new InvalidEmailsConfigDto();
    }

    public void saveInvalidEmailsConfig(InvalidEmailsConfigDto invalidEmailsConfig) {
        this.pluginSettingsSupplier.get().put(this.getPluginKey(INVALID_EMAILS_CONFIG), (Object)Jsons.valueAsString(invalidEmailsConfig));
    }

    public UDCMode getUdcModeConfig() {
        return this.udcGlobalEmailFixesConfigService.getUdcModeConfig();
    }

    @Nullable
    public UDCMode getConfirmedUdcModeConfig() {
        return this.udcGlobalEmailFixesConfigService.getConfirmedUdcModeConfig();
    }

    public UserMappingConfigDTO getUserMappingConfig() {
        return this.udcGlobalEmailFixesConfigService.getUserMappingConfig();
    }

    @NotNull
    private String getPluginKey(String configKey) {
        return this.migrationAgentConfiguration.getPluginKey() + ":" + configKey;
    }

    public static String getPluginKey(String pluginKeyPrefix, String configKey) {
        return pluginKeyPrefix + ":" + configKey;
    }
}

