/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.UsersGroupsStatsRequestDto;
import com.atlassian.migration.agent.model.stats.GlobalEntitiesStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.model.stats.UsersGroupsStats;
import com.atlassian.migration.agent.rest.StatisticsResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@Path(value="stats")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatisticsResourceJakarta {
    private final StatisticsResource originalResource;

    @Inject
    public StatisticsResourceJakarta(StatisticsResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="server")
    public ServerStats getServerStatistics() {
        return this.originalResource.getServerStatistics();
    }

    @GET
    @Path(value="usersGroups")
    public UsersGroupsStats getUsersGroupsStatistics() {
        return this.originalResource.getUsersGroupsStatistics();
    }

    @POST
    @Path(value="usersGroups")
    public UsersGroupsStats getUsersGroupsStatisticsForSpace(UsersGroupsStatsRequestDto usersGroupsStatsRequestDto) {
        return this.originalResource.getUsersGroupsStatisticsForSpace(usersGroupsStatsRequestDto);
    }

    @GET
    @Path(value="globalEntities")
    public GlobalEntitiesStats getGlobalEntitiesStatistics(@Nullable @QueryParam(value="planId") String planId) {
        return this.originalResource.getGlobalEntitiesStatistics(planId);
    }
}

