/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.rest.PlanResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="plan")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PlanResourceJakarta {
    private final PlanResource originalResource;

    @Inject
    public PlanResourceJakarta(PlanResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/{planId}")
    public Response getPlan(@PathParam(value="planId") String planId, @DefaultValue(value="false") @QueryParam(value="omitSpaceTasks") Boolean omitSpaceTasks) {
        return Response.ok((Object)this.originalResource.getPlanDto(planId, omitSpaceTasks)).build();
    }

    @GET
    @Path(value="/")
    public Response getAllPlans() {
        return Response.ok((Object)this.originalResource.getAllPlansDto()).build();
    }

    @POST
    @Path(value="/")
    public Response createPlan(PlanDto plan, @QueryParam(value="omitTasks") @DefaultValue(value="false") Boolean shouldOmitTasks) {
        Pair<Integer, Object> result = this.originalResource.createPlanDto(plan, shouldOmitTasks);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @PUT
    @Path(value="/")
    public Response updatePlan(PlanDto planDto) {
        return Response.ok((Object)this.originalResource.updatePlanDto(planDto)).build();
    }

    @PUT
    @Path(value="/{planId}/apps")
    public Response updatePlanApps(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.updatePlanAppsDto(planId)).build();
    }

    @GET
    @Path(value="/{planId}/progress")
    public Response getProgress(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.originalResource.getProgressDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{planId}/start")
    public Response start(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.originalResource.startDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{planId}/stop")
    public Response stop(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.originalResource.stopDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/validate/nameExists")
    public Response checkPlanNameExists(@QueryParam(value="name") String planName, @Nullable @QueryParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.checkPlanNameExistsDto(planName, planId)).build();
    }

    @POST
    @Path(value="/{planId}/copy")
    public Response copy(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.copyDto(planId)).build();
    }

    @POST
    @Path(value="{planId}/archive")
    public Response archive(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.archiveDto(planId)).build();
    }

    @DELETE
    @Path(value="{planId}/archive")
    public Response undoArchive(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.undoArchiveDto(planId)).build();
    }

    @DELETE
    @Path(value="{planId}")
    public Response delete(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.deleteDto(planId)).build();
    }

    @GET
    @Path(value="{planId}/spaces")
    public Response getSpaces(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.getSpacesDto(planId)).build();
    }

    @GET
    @Path(value="{planId}/paginated-spaces")
    public Response getSpaces(@PathParam(value="planId") String planId, @Nullable @QueryParam(value="startIndex") Integer startIndex, @Nullable @QueryParam(value="pageSize") Integer pageSize, @Nullable @QueryParam(value="spaceType") String spaceType, @Nullable @QueryParam(value="status") String status, @Nullable @QueryParam(value="query") String nameQuery, @Nullable @QueryParam(value="sortKey") String sortKey, @DefaultValue(value="ASC") @QueryParam(value="sortOrder") SortOrder sortOrder) {
        try {
            return Response.ok((Object)this.originalResource.getSpacesPaginatedDto(planId, startIndex, pageSize, spaceType, status, nameQuery, sortKey, sortOrder)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new MessageDto(e.getMessage())).build();
        }
    }
}

