/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.entity.UserBaseScanSortKey;
import com.atlassian.migration.agent.rest.ContainerTokenValidator;
import com.atlassian.migration.agent.service.email.GlobalEmailFixesConfigService;
import com.atlassian.migration.agent.service.email.IncorrectEmailResponse;
import com.atlassian.migration.agent.service.email.IncorrectEmailService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="incorrect-email")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IncorrectEmailResource {
    private final GlobalEmailFixesConfigService globalEmailFixesConfigService;
    private final IncorrectEmailService incorrectEmailService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final ContainerTokenValidator containerTokenValidator;

    @Inject
    public IncorrectEmailResource(GlobalEmailFixesConfigService globalEmailFixesConfigService, IncorrectEmailService incorrectEmailService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ContainerTokenValidator containerTokenValidator) {
        this.globalEmailFixesConfigService = globalEmailFixesConfigService;
        this.incorrectEmailService = incorrectEmailService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.containerTokenValidator = containerTokenValidator;
    }

    @GET
    @Path(value="/duplicated/config")
    public Response getDuplicateEmailConfig() {
        Pair<Boolean, DuplicateEmailsConfigDto> result = this.getDuplicateEmailConfigDto();
        if (Boolean.TRUE.equals(result.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result.getRight()).build();
    }

    @POST
    @Path(value="/duplicated/config")
    public Response saveDuplicateEmailConfig(DuplicateEmailsConfigDto duplicateEmailsConfigDto) {
        if (!this.saveDuplicateEmailConfigDto(duplicateEmailsConfigDto)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/invalid/config")
    public Response getInvalidEmailConfig() {
        Pair<Boolean, InvalidEmailsConfigDto> result = this.getInvalidEmailConfigDto();
        if (Boolean.TRUE.equals(result.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result.getRight()).build();
    }

    @POST
    @Path(value="/invalid/config")
    public Response saveInvalidEmailConfig(InvalidEmailsConfigDto invalidEmailsConfigDto) {
        if (!this.saveInvalidEmailConfigDto(invalidEmailsConfigDto)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/invalid/{cloudId}")
    public Response getInvalidEmails(@PathParam(value="cloudId") String cloudId, @QueryParam(value="userBaseScanId") String userBaseScanId, @QueryParam(value="page") @DefaultValue(value="1") Integer page, @QueryParam(value="limit") @DefaultValue(value="10") Integer limit, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") SortOrder sortOrder) {
        return this.handleEmailsRequest(cloudId, userBaseScanId, page, limit, () -> this.getInvalidEmailsDto(cloudId, userBaseScanId, page, limit, sortKey, sortOrder));
    }

    @GET
    @Path(value="/duplicated/{cloudId}")
    public Response getDuplicateEmails(@PathParam(value="cloudId") String cloudId, @QueryParam(value="userBaseScanId") String userBaseScanId, @QueryParam(value="page") @DefaultValue(value="1") Integer page, @QueryParam(value="limit") @DefaultValue(value="10") Integer limit, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") SortOrder sortOrder) {
        return this.handleEmailsRequest(cloudId, userBaseScanId, page, limit, () -> this.getDuplicateEmailsDto(cloudId, userBaseScanId, page, limit, sortKey, sortOrder));
    }

    public Pair<Boolean, DuplicateEmailsConfigDto> getDuplicateEmailConfigDto() {
        if (this.isGlobalEmailFixesDisabled()) {
            return Pair.of((Object)true, null);
        }
        return Pair.of((Object)false, (Object)this.globalEmailFixesConfigService.getDuplicateEmailsConfig());
    }

    public boolean saveDuplicateEmailConfigDto(DuplicateEmailsConfigDto duplicateEmailsConfigDto) {
        if (this.isGlobalEmailFixesDisabled()) {
            return false;
        }
        this.globalEmailFixesConfigService.saveDuplicateEmailsConfig(duplicateEmailsConfigDto);
        return true;
    }

    public Pair<Boolean, InvalidEmailsConfigDto> getInvalidEmailConfigDto() {
        if (this.isGlobalEmailFixesDisabled()) {
            return Pair.of((Object)true, null);
        }
        return Pair.of((Object)false, (Object)this.globalEmailFixesConfigService.getInvalidEmailsConfig());
    }

    public boolean saveInvalidEmailConfigDto(InvalidEmailsConfigDto invalidEmailsConfigDto) {
        if (this.isGlobalEmailFixesDisabled()) {
            return false;
        }
        this.globalEmailFixesConfigService.saveInvalidEmailsConfig(invalidEmailsConfigDto);
        return true;
    }

    public Pair<Integer, Object> getInvalidEmailsDto(String cloudId, String userBaseScanId, Integer page, Integer limit, UserBaseScanSortKey sortKey, SortOrder sortOrder) {
        Optional<IncorrectEmailResponse> emails = this.incorrectEmailService.getInvalidEmails(userBaseScanId, cloudId, page, limit, sortKey, sortOrder);
        return emails.isPresent() ? Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)emails.get()) : Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), null);
    }

    public Pair<Integer, Object> getDuplicateEmailsDto(String cloudId, String userBaseScanId, Integer page, Integer limit, UserBaseScanSortKey sortKey, SortOrder sortOrder) {
        Optional<IncorrectEmailResponse> emails = this.incorrectEmailService.getDuplicateEmails(userBaseScanId, cloudId, page, limit, sortKey, sortOrder);
        return emails.isPresent() ? Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)emails.get()) : Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), null);
    }

    private Response handleEmailsRequest(String cloudId, String userBaseScanId, Integer page, Integer limit, Supplier<Pair<Integer, Object>> dtoCall) {
        if (this.isGlobalEmailFixesDisabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<Response> invalid = this.containerTokenValidator.validateContainerToken(cloudId).toResponseWhenNotValid();
        if (invalid.isPresent()) {
            return invalid.get();
        }
        try {
            this.validateParameters(userBaseScanId, page, limit);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        Pair<Integer, Object> result = dtoCall.get();
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    public boolean isGlobalEmailFixesDisabled() {
        return !this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes();
    }

    private void validateParameters(String userBaseScanId, Integer page, Integer limit) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)userBaseScanId) ? 1 : 0) != 0, (Object)"userBaseScanId must be set");
        Preconditions.checkArgument((page > 0 ? 1 : 0) != 0, (Object)"page must be a positive integer");
        Preconditions.checkArgument((limit > 0 && limit <= 100 ? 1 : 0) != 0, (Object)"limit must be a number between 1 and 100");
    }
}

