/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.MapiArtifacts;
import com.atlassian.migration.agent.store.MapiArtifactsStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import java.util.Optional;

public class MapiArtifactsStoreImpl
implements MapiArtifactsStore {
    public static final String TASK_ID = "taskId";
    private final EntityManagerTemplate tmpl;

    public MapiArtifactsStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public void saveOrUpdate(MapiArtifacts mapiArtifacts) {
        this.tmpl.saveOrUpdate(mapiArtifacts);
    }

    @Override
    public int deleteArtifact(String taskId, String checkName) {
        String query = "delete from MapiArtifacts m where m.id.taskId = :taskId and m.id.checkName = :checkName";
        return this.tmpl.query(query).param(TASK_ID, (Object)taskId).param("checkName", (Object)checkName).update();
    }

    @Override
    public int deleteArtifactByTaskId(String taskId) {
        String query = "delete from MapiArtifacts m where m.id.taskId = :taskId";
        return this.tmpl.query(query).param(TASK_ID, (Object)taskId).update();
    }

    @Override
    public Optional<MapiArtifacts> getArtifact(String taskId, String checkName) {
        String query = "select m from MapiArtifacts m where m.id.taskId = :taskId and m.id.checkName = :checkName";
        return this.tmpl.query(MapiArtifacts.class, query).param(TASK_ID, (Object)taskId).param("checkName", (Object)checkName).first();
    }

    @Override
    public List<MapiArtifacts> getArtifactsByTaskId(String taskId) {
        String query = "select m from MapiArtifacts m where m.id.taskId = :taskId order by m.lastUpdate desc";
        return this.tmpl.query(MapiArtifacts.class, query).param(TASK_ID, (Object)taskId).list();
    }
}

