/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.stepexecutor.attachment.CustomConnectionResetException;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

class AttachmentsToMigrateProducer
implements Runnable {
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentsToMigrateProducer.class);
    private final BlockingQueue<Attachment> buffer;
    private final Stream<Attachment> attachmentStream;
    private final BooleanSupplier forceStop;
    private final V4Logger v4Logger;

    AttachmentsToMigrateProducer(Stream<Attachment> attachmentStream, BlockingQueue<Attachment> buffer, BooleanSupplier forceStop, V4Logger v4Logger) {
        this.buffer = buffer;
        this.attachmentStream = attachmentStream;
        this.forceStop = forceStop;
        this.v4Logger = v4Logger;
    }

    @Override
    public void run() {
        Iterator attachments = this.attachmentStream.iterator();
        RetryPolicy retryPolicy = RetryPolicyBuilder.customConnectionResetExceptionRetryPolicy();
        Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            try {
                this.produceAttachments(attachments);
            }
            catch (Throwable e) {
                if (ExceptionUtils.getThrowableList((Throwable)e).stream().anyMatch(throwable -> throwable.getMessage().contains("Connection reset"))) {
                    V4LogContext logContext = V4LogContext.builder().build();
                    this.v4Logger.logError(log, logContext, "Connection reset detected during attachment production", e);
                    throw new CustomConnectionResetException("Connection reset", e);
                }
                throw e;
            }
        });
    }

    private void produceAttachments(Iterator<Attachment> attachments) {
        while (this.canRun() && attachments.hasNext()) {
            Attachment attachment = attachments.next();
            boolean added = false;
            while (!added && this.canRun()) {
                added = this.addToBuffer(attachment);
                if (!added) continue;
                V4LogContext logContext = V4LogContext.builder().build();
                logContext.addAdditionalProperties("attachmentId", attachment.getId());
                this.v4Logger.logInfo(log, logContext, "Attachment added to upload buffer");
            }
        }
    }

    private boolean canRun() {
        return !this.forceStop.getAsBoolean();
    }

    private boolean addToBuffer(Attachment attachmentCandidate) {
        try {
            return this.buffer.offer(attachmentCandidate, 200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            V4LogContext logContext = V4LogContext.builder().build();
            logContext.addAdditionalProperties("attachmentId", attachmentCandidate.getId());
            this.v4Logger.logError(log, logContext, "Failed to add attachment to buffer due to interruption", ex);
            throw new IllegalStateException("Failed to add attachment to buffer because action was interrupted.", ex);
        }
    }
}

