/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MapiTaskMapping;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.SpaceAttachmentsOnlyTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.mapi.entity.MapiTaskStatus;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.MCSAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.TransferProgressRequest;
import com.atlassian.migration.agent.service.catalogue.TransferStatusUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.MapiTaskMappingService;
import com.atlassian.migration.agent.service.impl.PlanConverter;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.infraoptimisation.InfraOptimisationService;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.service.planning.StepPlanningEngines;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.stepexecutor.ProgressItem;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepProgressPropertiesStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.pollers.status.TransferResultStatus;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.statusrouter.model.CommandProgressRequest;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class ProgressTracker {
    private static final Logger log = ContextLoggerFactory.getLogger(ProgressTracker.class);
    private static final int LAST_PROGRESS_UPDATE_TIME_THRESHOLD = 60;
    private final PluginTransactionTemplate ptx;
    private final StepPlanningEngines planningEngines;
    private final StepStore stepStore;
    private final TaskStore taskStore;
    private final PlanStore planStore;
    private final StepProgressPropertiesStore stepProgressPropertiesStore;
    private final PlatformService platformService;
    private final TaskPlanningEngine taskPlanningEngine;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final PlanConverter planConverter;
    private final MigrationLogService migrationLogService;
    private final MapiTaskMappingService mapiTaskMappingService;
    private final InfraOptimisationService infraOptimisationService;
    private final ExecutorService completedStepExecutorService;
    private final ExecutorService inProgressStepExecutorService;
    private final MCSAnalyticsEventBuilder mcsAnalyticsEventBuilder;
    private final OnDemandPrcPoller prcPoller;
    private final Set<String> clubbedStepTypesForStandardisedEvents = new HashSet<String>(Arrays.asList(StepType.CONFLUENCE_EXPORT.name(), StepType.SPACE_USERS_MIGRATION.name(), StepType.GLOBAL_ENTITIES_EXPORT.name()));
    private static final Map<TaskType, String> translationMapToFetchDetailedStatusForPlan = new HashMap<TaskType, String>();
    private final Map<String, Instant> transferIdLastProgressUpdateTimeMap = new HashMap<String, Instant>();
    private final V4Logger v4Logger;
    private static final String STATUS = "status";
    private static final String PROGRESS = "progress";
    private static final String ERROR_FILENAME = "ProgressTracker";
    private static final String USERS_EXPORTED = "usersExported";
    private static final String GROUPS_EXPORTED = "groupsExported";
    private static final String USER_GROUPS_EXPORT = "usersGroupsExport";
    private static final String EXPORT_FILEID = "exportFileId";
    static final String CHANNEL_NAME_PREFIX = "confluence-server-to-cloud-";
    private static final String MESSAGE = "message";
    private static final String PERCENT = "percent";
    private static final String DETAILED_STATUS = "detailedStatus";
    private final Map<String, Instant> lastProgressUpdateTimeMap = new HashMap<String, Instant>();

    public ProgressTracker(PluginTransactionTemplate ptx, List<StepPlanningEngine<?>> planningEngines, StepStore stepStore, TaskStore taskStore, PlanStore planStore, TaskPlanningEngine taskPlanningEngine, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanConverter planConverter, MigrationLogService migrationLogService, MapiTaskMappingService mapiTaskMappingService, PlatformService platformService, StepProgressPropertiesStore stepProgressPropertiesStore, MCSAnalyticsEventBuilder mcsAnalyticsEventBuilder, OnDemandPrcPoller prcPoller, InfraOptimisationService infraOptimisationService, V4Logger v4Logger) {
        this(ptx, planningEngines, stepStore, taskStore, planStore, taskPlanningEngine, analyticsEventService, analyticsEventBuilder, planConverter, migrationLogService, mapiTaskMappingService, platformService, ProgressTracker.newFixedThreadPool(4, new GroupedThreadFactory(ERROR_FILENAME)), ProgressTracker.newFixedThreadPool(1, new GroupedThreadFactory(ERROR_FILENAME)), stepProgressPropertiesStore, mcsAnalyticsEventBuilder, prcPoller, infraOptimisationService, v4Logger);
    }

    @VisibleForTesting
    ProgressTracker(PluginTransactionTemplate ptx, List<StepPlanningEngine<?>> planningEngines, StepStore stepStore, TaskStore taskStore, PlanStore planStore, TaskPlanningEngine taskPlanningEngine, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanConverter planConverter, MigrationLogService migrationLogService, MapiTaskMappingService mapiTaskMappingService, PlatformService platformService, ExecutorService inProgressStepExecutorService, ExecutorService completedStepExecutorService, StepProgressPropertiesStore stepProgressPropertiesStore, MCSAnalyticsEventBuilder mcsAnalyticsEventBuilder, OnDemandPrcPoller prcPoller, InfraOptimisationService infraOptimisationService, V4Logger v4Logger) {
        this.ptx = ptx;
        this.planningEngines = new StepPlanningEngines(planningEngines);
        this.stepStore = stepStore;
        this.taskStore = taskStore;
        this.planStore = planStore;
        this.taskPlanningEngine = taskPlanningEngine;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planConverter = planConverter;
        this.migrationLogService = migrationLogService;
        this.platformService = platformService;
        this.mapiTaskMappingService = mapiTaskMappingService;
        this.inProgressStepExecutorService = inProgressStepExecutorService;
        this.completedStepExecutorService = completedStepExecutorService;
        this.stepProgressPropertiesStore = stepProgressPropertiesStore;
        this.mcsAnalyticsEventBuilder = mcsAnalyticsEventBuilder;
        this.prcPoller = prcPoller;
        this.infraOptimisationService = infraOptimisationService;
        this.v4Logger = v4Logger;
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    @VisibleForTesting
    void preDestroy() {
        this.completedStepExecutorService.shutdown();
        this.inProgressStepExecutorService.shutdown();
    }

    private static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nThreads, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void started(Step step, String message) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(message);
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(MESSAGE, message);
        this.v4Logger.logInfo(log, logContext, "Step Started");
        Progress stepsPrevProgress = step.getProgress();
        step.setProgress(step.getProgress().copy().started(message));
        this.stepStore.update(step);
        this.updateTransferAsync(step, stepsPrevProgress);
        Task task = step.getTask();
        StepPlanningEngine.PercentRange percentRange = this.getStepPercentRange(step);
        ExecutionStatus status = task.getProgress().getStatus();
        if (percentRange.isFirst() && status != ExecutionStatus.RUNNING) {
            task.setProgress(task.getProgress().copy().started(message));
            task.setProgress(task.getProgress().copy().progress(percentRange.from, message, step.getDetailedStatus()));
            this.updateContainer(task);
            this.saveTaskAnalyticsEvent(task, status);
        } else {
            task.setProgress(task.getProgress().copy().progress(percentRange.from, message, step.getDetailedStatus()));
        }
        this.taskStore.update(task);
    }

    public void progress(String stepId, int percent, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String detailedStatus) {
        this.progress(stepId, percent, message, detailedStatus, Collections.emptyMap());
    }

    public void updateProgressAndStatus(String stepId, int transferPercent, TransferResultStatus transferStatus, @javax.annotation.Nullable @Nullable String progressMessage, @javax.annotation.Nullable @Nullable String detailedStatus) {
        this.progress(stepId, transferPercent, progressMessage, detailedStatus, Collections.emptyMap());
    }

    public void progress(String stepId, int percent, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String detailedStatus, @javax.annotation.Nonnull @Nonnull Map<String, Object> progressProperties) {
        this.progress(stepId, percent, message, detailedStatus, progressProperties, Optional.empty());
    }

    public void progress(String stepId, int percent, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String detailedStatus, @javax.annotation.Nonnull @Nonnull Map<String, Object> progressProperties, Optional<PrcTask> prcTask) {
        Instant lastUpdateTime;
        Objects.requireNonNull(stepId);
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).build();
        logContext.addAdditionalProperties(PERCENT, percent, MESSAGE, message, DETAILED_STATUS, detailedStatus);
        this.v4Logger.logInfo(log, logContext, "Updating progress for step");
        Progress stepsPrevProgress = this.ptx.read(() -> this.stepStore.getStep(stepId).getProgress());
        Step updatedStep = this.ptx.write(() -> {
            Step step = this.stepStore.getAndLock(stepId);
            step.setProgress(step.getProgress().copy().progress(percent, message, detailedStatus));
            this.storeStepProgressPropertiesSafely(stepId, progressProperties);
            LoggingContextBuilder.logCtx().withStep(step).execute(() -> {
                this.stepStore.update(step);
                MigrationProtocol migrationProtocol = step.getPlan().getMigrationProtocol();
                if (migrationProtocol.equals((Object)MigrationProtocol.CV2) || migrationProtocol.equals((Object)MigrationProtocol.V2)) {
                    this.updateTaskProgress(step, percent, message, detailedStatus);
                }
            });
            return step;
        });
        MigrationProtocol migrationProtocol = this.ptx.read(() -> this.stepStore.getStep(stepId).getPlan().getMigrationProtocol());
        if (MigrationProtocol.CV2.equals((Object)migrationProtocol) || MigrationProtocol.V2.equals((Object)migrationProtocol)) {
            this.updateTransferAsync(updatedStep, stepsPrevProgress);
            return;
        }
        Instant now = Instant.now();
        if (now.isBefore((lastUpdateTime = this.lastProgressUpdateTimeMap.getOrDefault(stepId, Instant.MIN)).plusSeconds(60L)) && percent != 100) {
            this.v4Logger.logInfo(log, logContext, "Progress update for step is rejected as it is within 1 minute of the last update");
            return;
        }
        if (MigrationProtocol.V4.equals((Object)migrationProtocol)) {
            if (prcTask.isPresent()) {
                HashMap<String, Object> modifiableMap = new HashMap<String, Object>(progressProperties);
                modifiableMap.put(DETAILED_STATUS, detailedStatus);
                TransferProgressRequest transferProgressRequest = new TransferProgressRequest(percent, message, modifiableMap);
                this.sendV4ProgressUpdates(transferProgressRequest, prcTask.get());
            } else {
                this.v4Logger.logError(log, logContext, "PrcTask is not present for step", null);
            }
        }
        this.lastProgressUpdateTimeMap.put(stepId, now);
    }

    private void storeStepProgressPropertiesSafely(String stepId, @NotNull Map<String, Object> progressProperties) {
        try {
            this.stepProgressPropertiesStore.storeStepProgressProperties(stepId, progressProperties);
        }
        catch (Exception e) {
            V4LogContext logContext = V4LogContext.builder().stepId(stepId).build();
            this.v4Logger.logError(log, logContext, "There was an error when storing progress properties for step", e);
        }
    }

    public void progressSubStep(String stepId, int percent, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String detailedStatus, @javax.annotation.Nullable @Nullable StepSubType subType, @javax.annotation.Nonnull @Nonnull Map<String, Object> progressProperties) {
        Objects.requireNonNull(stepId);
        Progress stepsPrevProgress = this.ptx.read(() -> this.stepStore.getStep(stepId).getProgress());
        MigrationProtocol migrationProtocol = this.stepStore.getStep(stepId).getPlan().getMigrationProtocol();
        Step updatedStep = this.ptx.write(() -> {
            Step step = this.stepStore.getAndLock(stepId);
            step.setProgress(step.getProgress().copy().progress(percent, message, detailedStatus));
            this.storeStepProgressPropertiesSafely(stepId, progressProperties);
            if (subType != null) {
                step.setSubType(subType.name());
            }
            LoggingContextBuilder.logCtx().withStep(step).execute(() -> {
                this.stepStore.update(step);
                if (MigrationProtocol.CV2.equals((Object)migrationProtocol) || MigrationProtocol.V2.equals((Object)migrationProtocol)) {
                    this.updateTaskProgress(step, percent, message, detailedStatus);
                }
            });
            return step;
        });
        if (MigrationProtocol.CV2.equals((Object)migrationProtocol) || MigrationProtocol.V2.equals((Object)migrationProtocol)) {
            this.updateTransferAsync(updatedStep, stepsPrevProgress);
        }
    }

    public void sendV4ProgressUpdates(TransferProgressRequest outputProperties, PrcTask prcTask) {
        V4LogContext logContext = V4LogContext.builder().prcTaskId(((TransferTask)prcTask.getTransferTask()).getTaskId()).build();
        this.v4Logger.logInfo(log, logContext, "Sending V4 progress updates");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)outputProperties);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        CommandProgressRequest commandProgressRequest = new CommandProgressRequest(prcTask.getCommandSource(), ((TransferTask)prcTask.getTransferTask()).getTaskId(), jsonNode);
        this.prcPoller.sendCommandProgress(prcTask.getGenericPollerConfig().getOnDemandPollerPostConfig(), prcTask.getPrcCommandId().longValue(), commandProgressRequest);
    }

    public void updateProgressPropertiesWithoutTransferUpdate(String stepId, Map<String, Object> progressProperties) {
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).build();
        this.v4Logger.logInfo(log, logContext, "Updating progress properties without transfer update");
        this.ptx.write(() -> {
            Step step = this.stepStore.getAndLock(stepId);
            this.storeStepProgressPropertiesSafely(stepId, progressProperties);
            LoggingContextBuilder.logCtx().withStep(step).execute(() -> this.stepStore.update(step));
        });
    }

    private void updateTaskProgress(Step step, int percent, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String detailedStatus) {
        StepPlanningEngine.PercentRange percentRange;
        try {
            percentRange = this.getStepPercentRange(step);
        }
        catch (IllegalStateException e) {
            V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).build();
            logContext.addAdditionalProperties(PERCENT, percent, MESSAGE, message, DETAILED_STATUS, detailedStatus);
            this.v4Logger.logError(log, logContext, "Cannot get step range, skipping update of task", e);
            return;
        }
        Task task = step.getTask();
        int newPercent = percentRange.from + (percentRange.to - percentRange.from) * percent / 100;
        task.setProgress(task.getProgress().copy().progress(newPercent, message, detailedStatus));
        this.taskStore.update(task);
    }

    public void progressUpdateForSubStep(String stepId, int percent, @javax.annotation.Nullable @Nullable String message, String detailedStatus, @javax.annotation.Nullable @Nullable StepSubType nextSubStep, Map<String, Object> progressProperties, Optional<PrcTask> prcTask) {
        StepPlanningEngine.PercentRange percentRange;
        Objects.requireNonNull(stepId);
        Step step = this.stepStore.getStep(stepId);
        V4LogContext logContext = V4LogContext.builder().stepId(stepId).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(PERCENT, percent, MESSAGE, message, DETAILED_STATUS, detailedStatus, "nextSubStep", nextSubStep);
        try {
            percentRange = this.getSubStepPercentRange(step);
        }
        catch (IllegalStateException e) {
            this.v4Logger.logError(log, logContext, "Cannot get step range, skipping update of task", e);
            return;
        }
        int newStepPercent = percentRange.from + (percentRange.to - percentRange.from) * percent / 100;
        this.progressSubStep(stepId, newStepPercent, message, detailedStatus, nextSubStep, progressProperties);
        if (MigrationProtocol.V4.equals((Object)step.getPlan().getMigrationProtocol())) {
            if (prcTask.isPresent()) {
                this.sendV4ProgressUpdates(progressProperties, detailedStatus, prcTask.get(), newStepPercent, message);
            } else {
                this.v4Logger.logError(log, logContext, "PrcTask is not present for step", null);
            }
        }
    }

    public void sendV4ProgressUpdates(Map<String, Object> progressProperties, String detailedStatus, PrcTask prcTask, int percent, @javax.annotation.Nullable @Nullable String message) {
        HashMap<String, Object> modifiableMap = new HashMap<String, Object>(progressProperties);
        modifiableMap.put(DETAILED_STATUS, detailedStatus);
        TransferProgressRequest transferProgressRequest = new TransferProgressRequest(percent, message, modifiableMap);
        this.sendV4ProgressUpdates(transferProgressRequest, prcTask);
    }

    public void sendV4SpaceUserCompletionStatus(UsersMigrationV2FilePayload filePayload, @javax.annotation.Nullable @Nullable String fileId, String exportFileId, PrcTask prcTask, String statusMessage) {
        log.info("Sending completion status for space users migration");
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        outputProperties.put(USERS_EXPORTED, String.valueOf(filePayload.getUsers().size()));
        outputProperties.put(GROUPS_EXPORTED, String.valueOf(filePayload.getGroups().size()));
        outputProperties.put(USER_GROUPS_EXPORT, fileId);
        outputProperties.put(EXPORT_FILEID, exportFileId);
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4UserCompletionStatus(UsersMigrationV2FilePayload filePayload, String fileId, PrcTask prcTask, String statusMessage) {
        log.info("Sending completion status for users and groups migration with fileId {}", (Object)fileId);
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        outputProperties.put(USERS_EXPORTED, String.valueOf(filePayload.getUsers().size()));
        outputProperties.put(GROUPS_EXPORTED, String.valueOf(filePayload.getGroups().size()));
        outputProperties.put(USER_GROUPS_EXPORT, fileId);
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4SpaceUploadCompletionStatus(List<MigrationCatalogueStorageFile> uploadedFiles, String spaceId, PrcTask prcTask, String statusMessage) {
        log.info("Sending completion status for space upload");
        HashMap<String, List<Object>> outputProperties = new HashMap<String, List<Object>>();
        ArrayList<String> spaceIds = new ArrayList<String>();
        spaceIds.add(spaceId);
        outputProperties.put("spaceIds", spaceIds);
        outputProperties.put("dataExport", uploadedFiles);
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4AttachmentSuccessStatus(String spaceKey, PrcTask<AttachmentUploadTransferTask> prcTask, @javax.annotation.Nullable @Nullable UploadState uploadTracker, String statusMessage) {
        V4LogContext logContext = V4LogContext.builder().prcTaskId(prcTask.getTransferTask().getTaskId()).build();
        logContext.addAdditionalProperties("spaceKey", spaceKey, "statusMessage", statusMessage);
        this.v4Logger.logInfo(log, logContext, "Sending completion status for attachments migration");
        String successfullyMigratedBytes = "successfullyMigratedBytes";
        String totalSpaceAttachmentSize = "totalSpaceAttachmentSize";
        String totalSpaceAttachments = "totalSpaceAttachments";
        HashMap outputProperties = new HashMap();
        HashMap<String, String> migrationAnalytics = new HashMap<String, String>();
        if (uploadTracker != null) {
            migrationAnalytics.put(successfullyMigratedBytes, String.valueOf(uploadTracker.getUploadedBytes()));
            migrationAnalytics.put(totalSpaceAttachmentSize, String.valueOf(uploadTracker.getTotalBytes()));
            migrationAnalytics.put(totalSpaceAttachments, String.valueOf(uploadTracker.getNumOfAttachments()));
        }
        outputProperties.put("migrationAnalytics", migrationAnalytics);
        outputProperties.put(successfullyMigratedBytes, migrationAnalytics.get(successfullyMigratedBytes));
        outputProperties.put(totalSpaceAttachmentSize, migrationAnalytics.get(totalSpaceAttachmentSize));
        outputProperties.put(totalSpaceAttachments, migrationAnalytics.get(totalSpaceAttachments));
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4UserFailureStatus(PrcTask prcTask, CommandStatus commandStatus, String statusMessage) {
        log.info("Sending failure completion status for users and groups migration");
        HashMap outputProperties = new HashMap();
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.fromCommandStatus(commandStatus), statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4SpaceFailureStatus(PrcTask prcTask, String statusMessage) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap outputProperties = new HashMap();
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.FAILED, statusMessage, outputProperties);
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4SpaceUploadFailureStatus(PrcTask prcTask, String statusMessage) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap outputProperties = new HashMap();
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.FAILED, statusMessage, outputProperties);
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4SpaceUploadCancelledStatus(PrcTask prcTask, String statusMessage) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap outputProperties = new HashMap();
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.CANCELLED, statusMessage, outputProperties);
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4GlobalEntitiesSuccessStatus(PrcTask<GlobalEntitiesTransferTask> prcTask, String result, String statusMessage) {
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        outputProperties.put("dataExport", result);
        outputProperties.put("globalTemplates", String.valueOf(true));
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNode(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, transferStatusUpdateRequest.getStatus().toCommandStatus());
    }

    public void sendV4GlobalEntitiesStatus(PrcTask<GlobalEntitiesTransferTask> prcTask, TransferStatus status, String statusMessage) {
        ObjectMapper mapper = new ObjectMapper();
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(status, statusMessage);
        JsonNode jsonNode = mapper.valueToTree((Object)transferStatusUpdateRequest);
        jsonNode = this.setMigrationAsParentNodeWithOutputProperties(jsonNode);
        this.sendV4CompletionStatus(jsonNode, prcTask, status.toCommandStatus());
    }

    public void sendV4CompletionStatus(JsonNode jsonNode, PrcTask prcTask, CommandStatus commandStatus) {
        CommandStatusRequest commandStatusRequest = new CommandStatusRequest(prcTask.getCommandSource(), commandStatus, ((TransferTask)prcTask.getTransferTask()).getTaskId(), jsonNode);
        this.prcPoller.sendCommandCompletionStatus(prcTask.getGenericPollerConfig().getOnDemandPollerPostConfig(), prcTask.getPrcCommandId().longValue(), commandStatusRequest);
    }

    @VisibleForTesting
    JsonNode setMigrationAsParentNodeWithOutputProperties(JsonNode payload) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.createObjectNode().set("migration", mapper.createObjectNode().set("outputProperties", payload));
    }

    @VisibleForTesting
    JsonNode setMigrationAsParentNode(JsonNode payload) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.createObjectNode().set("migration", payload);
    }

    public void completed(Step step, StepResult result) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(result);
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties("result", result.isSuccess() ? "success" : "failure", "resultMessage", result.getMessage());
        if (result.isSuccess()) {
            this.v4Logger.logInfo(log, logContext, "Step completed successfully");
            this.done(step, result.getMessage(), result.getResult());
        } else if (result.isStopped()) {
            this.v4Logger.logInfo(log, logContext, "Step stopped");
            this.stopped(step);
        } else {
            this.v4Logger.logError(log, logContext, "Step Failed with Exception", result.getException());
            this.failed(step, result.getMessage(), result.getException());
        }
        this.sendStandardisedStepCompletionEvents(step, step.getProgress().getStatus());
    }

    private StepPlanningEngine.PercentRange getStepPercentRange(Step step) {
        Task task = step.getTask();
        StepPlanningEngine<? extends Task> engine = this.planningEngines.of(task).orElseThrow(() -> new IllegalStateException("Unknown task type " + task.getClass()));
        Optional<StepPlanningEngine.PercentRange> maybeRange = engine.getStepPercentRange(step);
        return maybeRange.orElseThrow(() -> new IllegalStateException("Unknown step type " + step.getType()));
    }

    private StepPlanningEngine.PercentRange getSubStepPercentRange(Step step) {
        Task task = step.getTask();
        StepPlanningEngine<? extends Task> engine = this.planningEngines.of(task).orElseThrow(() -> new IllegalStateException("Unknown task type " + task.getClass()));
        Optional<StepPlanningEngine.PercentRange> maybeRange = engine.getSubStepPercentRange(step);
        return maybeRange.orElseThrow(() -> new IllegalStateException("Unknown step type " + step.getType()));
    }

    private void updatePlanWhenStepDone(Task task) {
        String planId = task.getPlan().getId();
        Plan plan = this.planStore.getPlanAndLock(planId);
        Progress planProgress = plan.getProgress();
        if (planProgress.getStatus().isCompleted()) {
            log.debug("Plan is completed, progress will not be updated further");
            return;
        }
        Progress newProgress = planProgress.copy().updatePercent(this.taskStore.calculatePlanPercent(planId));
        plan.setProgress(newProgress);
        if (this.taskPlanningEngine.hasReachedTerminalState(planId)) {
            this.setPlanAsComplete(plan);
            this.planStore.updatePlan(plan);
            this.setMapiTaskStatus(plan);
            this.savePlanAnalyticsEvents(planId, plan.getProgress().getStatus() == ExecutionStatus.DONE);
        } else {
            this.planStore.updatePlan(plan);
        }
        this.updateMigrationStatus(plan);
    }

    private void setMapiTaskStatus(Plan plan) {
        try {
            Optional<MapiTaskMapping> mapiTaskMapping = this.mapiTaskMappingService.getTaskMapping(plan.getId(), Optional.of(ImmutableList.of((Object)((Object)MapiTaskStatus.CHECKS_IN_PROGRESS), (Object)((Object)MapiTaskStatus.CHECKS_COMPLETED))), Optional.of(ImmutableList.of((Object)CommandName.MIGRATE.getValue())));
            if (mapiTaskMapping.isPresent()) {
                this.mapiTaskMappingService.updateTaskMappingStatus(mapiTaskMapping.get(), MapiTaskStatus.MIGRATION_COMPLETED);
            }
        }
        catch (Exception e) {
            log.error("Error while setting mapi task status", (Throwable)e);
        }
    }

    private void setPlanAsComplete(Plan plan) {
        Progress newProgress;
        Optional<Task> failedTask = this.taskStore.findFirstTaskWithStatusForPlan(plan.getId(), ExecutionStatus.FAILED);
        boolean hasSuccessfulSpaceTask = this.taskStore.existTaskByStatusByTypeInPlan(plan.getId(), ExecutionStatus.DONE, (List<Class<? extends Task>>)ImmutableList.of(ConfluenceSpaceTask.class, SpaceAttachmentsOnlyTask.class));
        if (plan.getProgress().getStatus() == ExecutionStatus.STOPPING) {
            newProgress = plan.getProgress().copy().stopped();
        } else if (failedTask.isPresent() && !hasSuccessfulSpaceTask) {
            String message = failedTask.get().getProgress().getMessage();
            newProgress = plan.getProgress().copy().failed(message);
        } else {
            newProgress = failedTask.isPresent() ? plan.getProgress().copy().incomplete(failedTask.get().getProgress().getMessage()) : plan.getProgress().copy().done();
        }
        plan.setProgress(newProgress);
    }

    public void failPlan(String planId, String message) {
        Plan updatedPlan = this.ptx.write(() -> {
            Plan plan = this.planStore.getPlanAndLock(planId);
            Progress newProgress = plan.getProgress().copy().failed(message);
            plan.setProgress(newProgress);
            this.planStore.updatePlan(plan);
            return plan;
        });
        this.updateMigrationStatus(updatedPlan);
        this.savePlanAnalyticsEvents(planId, false);
    }

    public void failPlan(String planId, String message, Throwable exception) {
        String detailedMessage = String.format("%s %s", message, ProgressItem.throwableToDetailsMessage(exception));
        this.failPlan(planId, detailedMessage);
    }

    public void failTask(String taskId, String message) {
        this.ptx.write(() -> {
            Task task = this.taskStore.getTask(taskId);
            ExecutionStatus status = task.getProgress().getStatus();
            task.setProgress(task.getProgress().copy().failed(message));
            this.taskStore.update(task);
            this.stepStore.getStepsByTaskId(taskId).stream().filter(step -> !step.getProgress().getStatus().isCompleted()).forEach(step -> {
                Progress stepsPrevProgress = step.getProgress();
                step.setProgress(step.getProgress().copy().failed(message));
                this.stepStore.update((Step)step);
                this.updateTransferAsync((Step)step, stepsPrevProgress);
            });
            this.updateContainer(task);
            this.saveTaskAnalyticsEvent(task, status);
            this.updatePlanWhenStepDone(task);
        });
    }

    public void failTask(String taskId, String message, Throwable exception) {
        String detailedMessage = String.format("%s %s", message, ProgressItem.throwableToDetailsMessage(exception));
        this.failTask(taskId, detailedMessage);
    }

    private void done(Step step, @javax.annotation.Nullable @Nullable String message, @javax.annotation.Nullable @Nullable String result) {
        StepPlanningEngine.PercentRange percentRange;
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties("result", result, "resultMessage", message);
        this.v4Logger.logDebug(log, logContext, "Step done successfully");
        try {
            percentRange = this.getStepPercentRange(step);
        }
        catch (IllegalStateException e) {
            this.v4Logger.logError(log, logContext, "Failed to get the step percent, just try to mark it fail", e);
            this.failed(step, "Failed to get the step percent, just try to mark it fail", e);
            return;
        }
        Progress stepsPrevProgress = step.getProgress();
        step.setProgress(step.getProgress().copy().done(message, result));
        this.stepStore.update(step);
        this.updateTransferAsync(step, stepsPrevProgress);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        if (percentRange.isLast()) {
            task.setProgress(task.getProgress().copy().done(message, null));
            this.saveTaskAnalyticsEvent(task, status);
        } else if (step.getPlan().getProgress().getStatus() == ExecutionStatus.STOPPING) {
            task.setProgress(task.getProgress().copy().stopped());
            this.saveTaskAnalyticsEvent(task, status);
        } else {
            task.setProgress(task.getProgress().copy().progress(percentRange.to, message, step.getDetailedStatus()));
        }
        this.taskStore.update(task);
        this.updateContainer(task);
        this.updatePlanWhenStepDone(task);
    }

    public void updateDetailedStatusForPlan(List<Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Task currentTask = tasks.get(0);
        Plan plan = currentTask.getPlan();
        plan.setProgress(plan.getProgress().copy().updateDetailedStatus(translationMapToFetchDetailedStatusForPlan.get((Object)currentTask.getType())));
    }

    private void stopped(Step step) {
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        this.v4Logger.logDebug(log, logContext, "Step stopped");
        Progress stepsPrevProgress = step.getProgress();
        step.setProgress(step.getProgress().copy().stopped());
        this.stepStore.update(step);
        this.updateTransferAsync(step, stepsPrevProgress);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().stopped());
        this.taskStore.update(task);
        this.updateContainer(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
    }

    private void failed(Step step, String message, @javax.annotation.Nullable @Nullable Throwable e) {
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(MESSAGE, message);
        this.v4Logger.logError(log, logContext, "Step failed", e);
        String detailedMessage = message + '.' + ProgressItem.throwableToDetailsMessage(e);
        Progress stepsPrevProgress = step.getProgress();
        step.setProgress(step.getProgress().copy().failed(message));
        this.stepStore.update(step);
        step.setProgress(step.getProgress().copy().failed(detailedMessage));
        this.updateTransferAsync(step, stepsPrevProgress);
        Task task = step.getTask();
        ExecutionStatus status = task.getProgress().getStatus();
        task.setProgress(task.getProgress().copy().failed(message));
        this.taskStore.update(task);
        this.updateContainer(task);
        this.saveTaskAnalyticsEvent(task, status);
        this.updatePlanWhenStepDone(task);
        this.saveToLogFile(step, detailedMessage, e);
    }

    public void savePlanAnalyticsEvents(String planId, boolean success) {
        try {
            this.ptx.write(() -> {
                Plan plan = this.planStore.getPlanAndLock(planId);
                ExecutionStatus status = plan.getProgress().getStatus();
                PlanDto planDto = this.planConverter.entityToDto(plan, true);
                ArrayList<EventDto> analyticsEvents = new ArrayList<EventDto>();
                analyticsEvents.add(this.analyticsEventBuilder.buildUpdatedPlanStatusAnalyticEvent(planDto, ProgressDto.convertStatus(status, null)));
                analyticsEvents.add(this.analyticsEventBuilder.buildCompletedPlanAnalyticsEvent(planDto, plan.getCloudSite()));
                if (plan.getMigrationProtocol() == MigrationProtocol.CV2 || plan.getMigrationProtocol() == MigrationProtocol.V2) {
                    analyticsEvents.add(this.analyticsEventBuilder.buildPlatformPlanCompletionOperationalEvent(planDto, plan.getMigrationScopeId(), status));
                    analyticsEvents.add(this.analyticsEventBuilder.buildPlatformPlanCompletionMetricEvent(status, planDto.getMigrationTag(), planDto.getMigrationCreator()));
                }
                this.analyticsEventService.sendAnalyticsEvents(() -> analyticsEvents);
            });
        }
        catch (Exception e) {
            log.error("Failed to save analytics", (Throwable)e);
        }
    }

    private void sendStandardisedStepCompletionEvents(Step currentStep, ExecutionStatus status) {
        String currentStepType = currentStep.getType();
        if (this.clubbedStepTypesForStandardisedEvents.contains(currentStepType) && status == ExecutionStatus.DONE) {
            return;
        }
        MigrationTag migrationTag = currentStep.getPlan().getMigrationTag();
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildPlatformStepCompletionOperationalEvent(currentStep, status), (Object)this.analyticsEventBuilder.buildPlatformStepCompletionExtendedMetricEvent(currentStepType, status, migrationTag)));
    }

    void saveTaskAnalyticsEvent(Task task, ExecutionStatus status) {
        boolean abstractSpaceTask = task instanceof AbstractSpaceTask;
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildUpdatedTaskStatusAnalyticEvent(task.getPlan().getId(), task.getId(), task.getAnalyticsEventType(), ProgressDto.convertStatus(status, null), ProgressDto.convertStatus(task.getProgress().getStatus(), null), abstractSpaceTask ? ((AbstractSpaceTask)task).getSpaceKey() : null));
    }

    private void saveToLogFile(Step step, String reason, @javax.annotation.Nullable @Nullable Throwable exception) {
        this.migrationLogService.saveToLogFile(step, reason, exception);
    }

    public void updateMigrationStatus(Plan plan) {
        try {
            if (plan.getProgress().getStatus().isCompleted()) {
                this.infraOptimisationService.updateDataMovementStatus(plan);
                this.platformService.updateMigrationStatusToMcs(plan);
            }
        }
        catch (Exception e) {
            log.error("Failed to update migration status for migration {}", (Object)plan.getMigrationId(), (Object)e);
            this.sendMCSMigrationStatusOperationalEvent(STATUS, plan.getMigrationId(), plan.getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()));
        }
    }

    @VisibleForTesting
    void updateContainer(Task task) {
        try {
            Plan plan = this.ptx.read(() -> this.taskStore.getTask(task.getId()).getPlan());
            boolean isGlobalEntitiesTaskPresent = plan.getGlobalEntitiesTaskOfPlan().isPresent();
            ExecutionStatus status = task.getProgress().getStatus();
            if (isGlobalEntitiesTaskPresent && (status.equals((Object)ExecutionStatus.DONE) && task.getType().equals((Object)TaskType.USERS) || !ExecutionStatus.COMPLETE_STATUSES.contains((Object)status) && task.getType().equals((Object)TaskType.GLOBAL_ENTITIES))) {
                return;
            }
            if (task.getContainerId() != null && !task.getContainerId().isEmpty()) {
                this.completedStepExecutorService.submit(() -> this.platformService.updateContainersStatus(plan.getCloudSite().getCloudId(), plan.getMigrationId(), task.getContainerId(), status.getContainerStatus(), task.getProgress().getMessage()));
            }
        }
        catch (Exception e) {
            log.error("Failed to update container status for task {}", (Object)task.getId(), (Object)e);
            this.sendMCSContainerStatusOperationalEvent(STATUS, task.getContainerId(), task.getPlan().getMigrationId(), task.getPlan().getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()));
        }
    }

    @VisibleForTesting
    void updateTransferAsync(Step step, Progress stepsPrevProgress) {
        Progress progress = step.getProgress();
        if (!Strings.isNullOrEmpty((String)step.getTransferId())) {
            if (progress.getStatus().getTransferStatus() != stepsPrevProgress.getStatus().getTransferStatus()) {
                this.updateTransferOnStatusChanged(step);
            } else {
                this.updateInProgressTransfers(step, stepsPrevProgress);
            }
        }
    }

    @VisibleForTesting
    void updateInProgressTransfers(Step step, Progress stepsPrevProgress) {
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        try {
            if (this.shouldUpdateTransferProgress(step, stepsPrevProgress)) {
                this.inProgressStepExecutorService.submit(() -> {
                    this.updateTransferProgress(step);
                    this.transferIdLastProgressUpdateTimeMap.put(step.getTransferId(), Instant.now());
                });
            }
        }
        catch (Exception e) {
            this.v4Logger.logDebug(log, logContext, "Failed to update transfer progress task", e);
            this.sendMCSTransferProgressStatusOperationalEvent(PROGRESS, step.getTransferId(), step.getPlan().getMigrationId(), step.getPlan().getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()));
        }
    }

    private void updateTransferOnStatusChanged(Step step) {
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).stepConfig(step.getConfig()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        try {
            this.completedStepExecutorService.submit(() -> {
                Progress progress = step.getProgress();
                this.updateTransferProgress(step);
                this.transferIdLastProgressUpdateTimeMap.remove(step.getTransferId());
                this.platformService.updateTransferStatus(step.getPlan().getCloudSite().getCloudId(), step.getPlan().getMigrationId(), step.getTransferId(), progress.getStatus().getTransferStatus(), progress.getMessage());
            });
        }
        catch (Exception e) {
            logContext.addAdditionalProperties("transferId", step.getTransferId(), "cloudId", step.getPlan().getCloudSite().getCloudId());
            this.v4Logger.logWarn(log, logContext, "Failed to update transfer status or progress", e);
            this.sendMCSTransferProgressStatusOperationalEvent(STATUS, step.getTransferId(), step.getPlan().getMigrationId(), step.getPlan().getCloudSite().getCloudId(), Optional.ofNullable(e.getMessage()));
        }
    }

    private void updateTransferProgress(Step step) {
        Progress progress = step.getProgress();
        Map stepProgressProperties = this.ptx.read(() -> this.stepProgressPropertiesStore.getStepProgressProperties(step.getId()));
        Plan plan = step.getPlan();
        this.platformService.updateTransferProgress(plan.getCloudSite().getCloudId(), plan.getMigrationId(), step.getTransferId(), new TransferProgressRequest(progress.getPercent(), progress.getMessage(), stepProgressProperties));
    }

    private boolean shouldUpdateTransferProgress(Step step, Progress stepsPrevProgress) {
        if (step.getProgress().getPercent() <= stepsPrevProgress.getPercent()) {
            return false;
        }
        Instant lastUpdateTime = this.transferIdLastProgressUpdateTimeMap.getOrDefault(step.getTransferId(), Instant.MIN);
        return lastUpdateTime.isBefore(Instant.now().minusSeconds(60L));
    }

    private void sendMCSTransferProgressStatusOperationalEvent(String eventType, String actionSubjectId, String migrationId, String cloudId, Optional<String> errorReason) {
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.mcsAnalyticsEventBuilder.buildMCSTransferStatusProgressUpdateOperationalEvent(eventType, actionSubjectId, migrationId, cloudId, ERROR_FILENAME, errorReason)));
    }

    private void sendMCSContainerStatusOperationalEvent(String eventType, String actionSubjectId, String migrationId, String cloudId, Optional<String> errorReason) {
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.mcsAnalyticsEventBuilder.buildMCSContainerStatusUpdateOperationalEvent(eventType, actionSubjectId, migrationId, cloudId, ERROR_FILENAME, errorReason)));
    }

    private void sendMCSMigrationStatusOperationalEvent(String eventType, String actionSubjectId, String cloudId, Optional<String> errorReason) {
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.mcsAnalyticsEventBuilder.buildMCSMigrationStatusUpdateOperationalEvent(eventType, actionSubjectId, cloudId, ERROR_FILENAME, errorReason)));
    }

    static {
        translationMapToFetchDetailedStatusForPlan.put(TaskType.SPACE, "Migrating spaces");
        translationMapToFetchDetailedStatusForPlan.put(TaskType.USERS, "Migrating users and groups");
        translationMapToFetchDetailedStatusForPlan.put(TaskType.GLOBAL_ENTITIES, "Migrating global templates");
        translationMapToFetchDetailedStatusForPlan.put(TaskType.ATTACHMENTS, "Migrating attachments");
        translationMapToFetchDetailedStatusForPlan.put(TaskType.APPS, "Migrating apps");
    }
}

