/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;

public class ProgressItem {
    private static final int ABBREVIATION_LENGTH = 4096;

    public static String throwableToDetailsMessage(Throwable t) {
        if (t == null) {
            return "Unknown error occurred";
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            t.printStackTrace(printWriter);
        }
        String stackTrace = stringWriter.toString();
        String abbreviatedStackTrace = StringUtils.abbreviateMiddle((String)stackTrace, (String)"...", (int)4096);
        return String.format("%s (StackTrace=%s)", t.toString(), abbreviatedStackTrace);
    }

    public static String throwableToSimpleMessage(Throwable t) {
        if (t == null) {
            return "Unknown error occurred";
        }
        return t.toString();
    }

    public static String extractExceptionMessage(Throwable t) {
        if (t == null) {
            return "Unknown error occurred";
        }
        String message = t.getMessage();
        if (message != null && !message.trim().isEmpty()) {
            return message;
        }
        return t.getClass().getSimpleName();
    }
}

