/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;

@ParametersAreNonnullByDefault
public class StepPlanningEngines {
    private final Map<Class<? extends Task>, StepPlanningEngine<? extends Task>> engines;

    public StepPlanningEngines(List<StepPlanningEngine<? extends Task>> engines) {
        this.engines = engines.stream().collect(Collectors.toMap(StepPlanningEngine::getTaskType, Function.identity()));
    }

    @javax.annotation.Nonnull
    @Nonnull
    public Optional<StepPlanningEngine<? extends Task>> of(Task task) {
        return Optional.ofNullable(this.engines.get(Hibernate.getClass((Object)task)));
    }
}

