/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.infraoptimisation;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementRegisterRequest;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementRegisterResponse;
import com.atlassian.migration.agent.model.infraoptimisation.InfraOptimisationStatus;
import com.atlassian.migration.agent.model.infraoptimisation.ResourceOptimisationStatusResponse;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.InstanceStats;
import com.atlassian.migration.agent.model.stats.ServerStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.DataMovementAnalyticsBuilder;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.infraoptimisation.exception.InfraOptimisationException;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.time.Duration;
import java.util.Optional;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.PolicyListeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.Timeout;
import net.jodah.failsafe.TimeoutExceededException;
import net.jodah.failsafe.function.CheckedSupplier;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class InfraOptimisationService {
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final StatisticsService statisticsService;
    private final DataMovementAnalyticsBuilder dataMovementAnalyticsBuilder;
    private final AnalyticsEventService analyticsEventService;
    private final PlanStore planStore;
    private final PluginTransactionTemplate ptx;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private static final Logger log = ContextLoggerFactory.getLogger(InfraOptimisationService.class);
    private static final Duration RDS_POLLING_TIMEOUT = Duration.ofMinutes(45L);
    private static final Duration WAIT_TIME_FOR_RESOURCE_OPTIMISATION_STATUS_CHECK = Duration.ofMinutes(5L);

    public InfraOptimisationService(EnterpriseGatekeeperClient enterpriseGatekeeperClient, StatisticsService statisticsService, DataMovementAnalyticsBuilder dataMovementAnalyticsBuilder, AnalyticsEventService analyticsEventService, PlanStore planStore, PluginTransactionTemplate ptx, MigrationDarkFeaturesManager darkFeaturesManager) {
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.statisticsService = statisticsService;
        this.dataMovementAnalyticsBuilder = dataMovementAnalyticsBuilder;
        this.analyticsEventService = analyticsEventService;
        this.planStore = planStore;
        this.ptx = ptx;
        this.darkFeaturesManager = darkFeaturesManager;
    }

    public void registerDataMovement(Plan plan) {
        if (!this.darkFeaturesManager.isInfraOptimisationEnabled(plan)) {
            log.warn("Data Movement Register will not be called. Infra Optimisation FF is disabled");
            return;
        }
        try {
            Optional<DataMovementRegisterResponse.DataMovementResponseData> dataMovementRegisterResponseData = Optional.ofNullable(this.enterpriseGatekeeperClient.registerDataMovement(plan, this.getDataMovementMetaData())).map(DataMovementRegisterResponse::getResponseData);
            if (!dataMovementRegisterResponseData.isPresent()) {
                log.error("Data Movement registration response is empty for planId - {}, migrationId - {}", (Object)plan.getId(), (Object)plan.getMigrationId());
            }
            log.info("Data Movement Register Response {}", (Object)dataMovementRegisterResponseData.get());
            plan.setDataMovementId(dataMovementRegisterResponseData.get().getDataMovementId());
            if (dataMovementRegisterResponseData.get().isInfraScaling()) {
                plan.setInfraOptimisationStatus(InfraOptimisationStatus.IN_PROGRESS);
            } else {
                plan.setInfraOptimisationStatus(InfraOptimisationStatus.COMPLETED);
            }
            log.info("Plan Details after Data Movement Registration - InfraOptimisationStatus {}, DataMovementId {}", (Object)plan.getInfraOptimisationStatus(), (Object)plan.getDataMovementId());
        }
        catch (Exception e) {
            String errorMessage = "Data Movement could not be registered for plan " + plan.getId();
            log.error(errorMessage, (Throwable)e);
            throw new InfraOptimisationException(errorMessage, e);
        }
    }

    public void updateDataMovementStatus(Plan plan) {
        if (!this.darkFeaturesManager.isInfraOptimisationEnabled(plan)) {
            log.warn("Data Movement will not be updated. Infra Optimisation FF is disabled");
            return;
        }
        if (plan.getDataMovementId() == null) {
            log.warn("Data Movement not found. Will not update the data movement status for planId - {}", (Object)plan.getId());
            return;
        }
        try {
            this.enterpriseGatekeeperClient.updateDataMovement(plan);
            log.info("Data Movement updated successfully for dataMovementId {}", (Object)plan.getDataMovementId());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.dataMovementAnalyticsBuilder.buildDataMovementUpdateEvent(plan, Boolean.TRUE));
        }
        catch (Exception e) {
            String error = "Data Movement could not be updated for dataMovementId - %s, planId - %s";
            String errorMessage = String.format(error, plan.getDataMovementId(), plan.getId());
            log.error(errorMessage, (Throwable)e);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.dataMovementAnalyticsBuilder.buildDataMovementUpdateEvent(plan, Boolean.FALSE));
            throw new InfraOptimisationException(errorMessage, e);
        }
    }

    public boolean isResourceOptimisationComplete(String containerToken, String migrationId, String dataMovementId) {
        Optional<ResourceOptimisationStatusResponse.ResourceOptimisationResponse> response = Optional.ofNullable(this.enterpriseGatekeeperClient.getResourceOptimisationStatus(containerToken, migrationId, dataMovementId)).map(ResourceOptimisationStatusResponse::getResponseData);
        response.ifPresent(resourceOptimisationResponse -> log.info("RDS Status Response {}", resourceOptimisationResponse));
        return response.map(resourceOptimisationResponse -> resourceOptimisationResponse.getResourceOptimisationStatus().equals((Object)ResourceOptimisationStatusResponse.ResourceOptimisationStatus.COMPLETED)).orElse(false);
    }

    private DataMovementRegisterRequest.DataMovementMetadata getDataMovementMetaData() {
        ServerStats serverStats = this.statisticsService.loadServerStatistics();
        InstanceStats instanceStats = serverStats.getInstanceStats();
        ContentSummary contentSummary = serverStats.getContentSummary();
        return DataMovementRegisterRequest.DataMovementMetadata.builder().numberOfPages(contentSummary.getNumberOfPages()).numberOfAttachments(contentSummary.getNumberOfAttachments()).numberOfSpaces(instanceStats.getNumberOfSpaces()).numberOfGroups(instanceStats.getNumberOfGroups()).numberOfUsers(instanceStats.getNumberOfUsers()).build();
    }

    public void handleResourceOptimisationPolling(Plan plan) {
        String planId = plan.getId();
        String containerToken = plan.getCloudSite().getContainerToken();
        String migrationId = plan.getMigrationId();
        String dataMovementId = plan.getDataMovementId();
        log.info("Received handleResourceOptimisationStatusPolling request - planId - {}, migrationId - {}, dataMovementId - {}", new Object[]{planId, migrationId, dataMovementId});
        if (!this.darkFeaturesManager.isInfraOptimisationEnabled(plan)) {
            log.warn("Resource Optimisation polling will not be executed. Infra Optimisation FF is disabled");
            return;
        }
        if (plan.getDataMovementId() == null) {
            log.info("Data Movement not found. Skipping resource optimisation polling for planId - {}", (Object)plan.getId());
            return;
        }
        RetryPolicy retryPolicy = ((RetryPolicy)((RetryPolicy)new RetryPolicy().handleResult((Object)false)).withDelay(WAIT_TIME_FOR_RESOURCE_OPTIMISATION_STATUS_CHECK).withMaxRetries(10).onRetry(e -> log.info("Retrying resource optimisation status polling for planId - {}, dataMovementId - {}. Attempt #{}", new Object[]{planId, dataMovementId, e.getAttemptCount()})).onSuccess(e -> {
            log.info("Resource optimisation status polling completed successfully for planId - {}, dataMovementId - {}", (Object)planId, (Object)dataMovementId);
            this.updateInfraOptimisationStatus(plan, InfraOptimisationStatus.COMPLETED);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.dataMovementAnalyticsBuilder.buildInfraOptimisationStatusEvent(migrationId, dataMovementId, InfraOptimisationStatus.COMPLETED, planId, Boolean.TRUE));
        })).abortOn(Exception.class);
        Timeout timeout = Timeout.of((Duration)RDS_POLLING_TIMEOUT);
        CheckedSupplier resourceOptimisationStatusChecker = () -> {
            boolean isResourceOptimisationComplete = this.isResourceOptimisationComplete(containerToken, migrationId, dataMovementId);
            if (!isResourceOptimisationComplete) {
                log.info("Resource optimisation has not completed for planId - {}, dataMovementId - {}. Sleeping for 5 mins", (Object)planId, (Object)dataMovementId);
            }
            return isResourceOptimisationComplete;
        };
        try {
            Failsafe.with((Policy)timeout, (Policy[])new PolicyListeners[]{retryPolicy}).get(resourceOptimisationStatusChecker);
        }
        catch (TimeoutExceededException e2) {
            log.info("Resource optimisation status poller timed out for planId - {}, dataMovementId - {}", new Object[]{planId, dataMovementId, e2});
            this.updateInfraOptimisationStatus(plan, InfraOptimisationStatus.FAILED);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.dataMovementAnalyticsBuilder.buildInfraOptimisationStatusEvent(migrationId, dataMovementId, InfraOptimisationStatus.FAILED, planId, Boolean.FALSE));
        }
        catch (Exception e3) {
            log.error("Failed to handle handleResourceOptimisationStatusPolling for planId - {}, migrationId - {}, dataMovementId - {}", new Object[]{planId, migrationId, dataMovementId, e3});
            this.updateInfraOptimisationStatus(plan, InfraOptimisationStatus.FAILED);
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.dataMovementAnalyticsBuilder.buildInfraOptimisationStatusEvent(migrationId, dataMovementId, InfraOptimisationStatus.FAILED, planId, Boolean.FALSE));
        }
    }

    public void updateInfraOptimisationStatus(Plan plan, InfraOptimisationStatus infraOptimisationStatus) {
        log.info("Updating infra optimisation status for planId {} to {}", (Object)plan.getId(), (Object)infraOptimisationStatus);
        plan.setInfraOptimisationStatus(infraOptimisationStatus);
        this.ptx.write(() -> this.planStore.updatePlan(plan));
    }
}

