/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.compatibility.WebApplicationExceptionFactory;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.dto.SpaceDto;
import com.atlassian.migration.agent.dto.SpaceSearchResultDto;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.entity.Space;
import com.atlassian.migration.agent.entity.SpaceStatisticsProgress;
import com.atlassian.migration.agent.entity.SpaceWithStatisticResult;
import com.atlassian.migration.agent.model.stats.AttachmentStats;
import com.atlassian.migration.agent.model.stats.ContentSummary;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.impl.MigrationTimeEstimationUtils;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.migration.agent.store.ConfluenceSpaceTaskStore;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.impl.SpaceStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SpaceCatalogService {
    private final PluginTransactionTemplate ptx;
    private final SpaceStore spaceStore;
    private final ConfluenceSpaceTaskStore confluenceSpaceTaskStore;
    private final PlanStore planStore;
    private final StatisticsService statisticsService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final MigrationTimeEstimationUtils migrationTimeEstimationUtils;
    @VisibleForTesting
    public static final long AVG_ESTIMATION_SECONDS = 30L;

    public SpaceCatalogService(PluginTransactionTemplate ptx, SpaceStore spaceStore, ConfluenceSpaceTaskStore confluenceSpaceTaskStore, PlanStore planStore, StatisticsService statisticsService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationTimeEstimationUtils migrationTimeEstimationUtils) {
        this.ptx = ptx;
        this.spaceStore = spaceStore;
        this.confluenceSpaceTaskStore = confluenceSpaceTaskStore;
        this.planStore = planStore;
        this.statisticsService = statisticsService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.migrationTimeEstimationUtils = migrationTimeEstimationUtils;
    }

    public Collection<SpaceDto> getSpacesSummaryForPlan(String planId) {
        List spaces = this.ptx.read(() -> this.spaceStore.getSpaces(planId));
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map<String, ContentSummary> spaceKeyToSummary = this.mapContentSummariesForSpaceKeys(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDto((Space)space, spaceKeyToSummary, Collections.emptyMap())).collect(Collectors.toList());
    }

    public Collection<SpaceDto> getSpacesForPlan(@NotNull String planId) {
        List spaces = this.ptx.read(() -> this.spaceStore.getSpaces(planId));
        return spaces.stream().map(space -> this.spaceToDto((Space)space, Collections.emptyMap(), Collections.emptyMap())).collect(Collectors.toList());
    }

    private List<String> commaDelimitedStatusesToListOfStatuses(String value) {
        try {
            if (Strings.isNullOrEmpty((String)value)) {
                return Collections.emptyList();
            }
            String decodedString = URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
            return Arrays.asList(decodedString.split(","));
        }
        catch (Exception e) {
            throw WebApplicationExceptionFactory.create("Invalid space catalog request", Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    public SpaceSearchResultDto getSpacesPaginatedForPlan(@NotNull String planId, int startIndex, int pageSize, @NotNull SpaceTypeFilter spaceTypeFilter, @NotNull String status, @javax.annotation.Nullable @Nullable String nameQuery, @javax.annotation.Nullable @Nullable String sortKey, @NotNull SortOrder sortOrder) {
        List<String> statuses = this.commaDelimitedStatusesToListOfStatuses(status);
        List pagedSpaces = this.ptx.read(() -> this.spaceStore.getSpacesPagedForPlan(planId, nameQuery, spaceTypeFilter, statuses, startIndex, pageSize, sortKey, sortOrder));
        Plan plan = this.planStore.getPlan(planId);
        boolean isAttachmentOnlyMigration = plan.isAttachmentOnlyMigration().isPresent() && plan.isAttachmentOnlyMigration().get() != false;
        Collection<SpaceDto> pagedSpaceDtos = this.getSpaceDtosByPlan(planId, pagedSpaces, isAttachmentOnlyMigration);
        Long spaceCount = this.spaceStore.getSpaceCountForPlan(planId, nameQuery, spaceTypeFilter, statuses);
        SpaceStatisticsProgress spaceStatisticsProgress = this.spaceStore.getSpaceStatsProgress();
        int totalSpaces = Math.toIntExact(this.spaceStore.getSpaceCountForPlan(planId, null, SpaceTypeFilter.ALL, Arrays.asList("READY", "RUNNING", "STOPPING", "STOPPED", "INCOMPLETE", "FAILED", "FINISHED")));
        return new SpaceSearchResultDto(spaceCount.intValue(), startIndex, pageSize, pagedSpaceDtos, totalSpaces, spaceStatisticsProgress.getPercentage(), spaceStatisticsProgress.isCalculating());
    }

    public SpaceSearchResultDto getSpaces(String cloudId, String nameQuery, SpaceTypeFilter spaceTypeFilter, List<String> statuses, int startIndex, int pageSize, String sortKey, SortOrder sortOrder, @javax.annotation.Nullable @Nullable Instant lastEditedStartDate, @javax.annotation.Nullable @Nullable Instant lastEditedEndDate) {
        int totalSpaces = this.ptx.read(this.spaceStore::getTotalSpaces);
        if (this.migrationDarkFeaturesManager.isNewSpaceSelectorEnabled()) {
            List executionStatuses = statuses.stream().map(ExecutionStatus::mapToExecutionStatus).collect(Collectors.toList());
            List spaceWithStatisticResults = this.ptx.read(() -> this.spaceStore.getSpacesWithStatistic(cloudId, nameQuery, spaceTypeFilter, executionStatuses, startIndex, pageSize, sortKey, sortOrder, lastEditedStartDate, lastEditedEndDate));
            int spaceCount = this.ptx.read(() -> this.spaceStore.getSpaceCountByNewSpaceSelector(cloudId, nameQuery, spaceTypeFilter, executionStatuses, lastEditedStartDate, lastEditedEndDate));
            SpaceStatisticsProgress spaceStatisticsProgress = this.spaceStore.getSpaceStatsProgress();
            return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, this.getSpaceDTOsForNewSpaceSelector(spaceWithStatisticResults), totalSpaces, spaceStatisticsProgress.getPercentage(), spaceStatisticsProgress.isCalculating());
        }
        int spaceCount = this.ptx.read(() -> this.spaceStore.getSpacesCount(nameQuery, spaceTypeFilter));
        List pagedSpaces = this.ptx.read(() -> this.spaceStore.getSpacesPaged(cloudId, nameQuery, spaceTypeFilter, startIndex, pageSize));
        if (pageSize == Integer.MAX_VALUE) {
            return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, this.createSpaceDtosWithoutSummaryProgress(pagedSpaces), totalSpaces, 0.0, false);
        }
        if (pagedSpaces.isEmpty()) {
            return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, Collections.emptyList(), totalSpaces, 0.0, false);
        }
        return new SpaceSearchResultDto(spaceCount, startIndex, pageSize, this.getSpaceDtos(cloudId, pagedSpaces), totalSpaces, 0.0, false);
    }

    private Collection<SpaceDto> createSpaceDtosWithoutSummaryProgress(List<Space> spaces) {
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map<String, ContentSummary> spaceKeyToSummary = this.mapContentSummariesForSpaceKeys(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDtoWithOutProgress((Space)space, spaceKeyToSummary)).collect(Collectors.toList());
    }

    private SpaceDto spaceToDtoWithOutProgress(Space space, Map<String, ContentSummary> spaceKeyToSummary) {
        String spaceKey = space.getKey();
        return new SpaceDto(spaceKey, space.getId(), space.getName(), spaceKeyToSummary.getOrDefault(spaceKey, ContentSummary.ZERO), null, 30L, Optional.ofNullable(space.getType()).map(SpaceType::forName).orElse(null));
    }

    private Map<String, ContentSummary> mapContentSummariesForSpaceKeys(List<String> spaceKeys) {
        return this.statisticsService.loadSpaceStatistics(spaceKeys).stream().collect(Collectors.toMap(SpaceStats::getSpaceKey, SpaceStats::getSummary));
    }

    private Collection<SpaceDto> getSpaceDtosByPlan(String planId, List<Space> spaces, boolean attachmentsOnly) {
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map spaceKeyToProgress = attachmentsOnly ? this.ptx.read(() -> this.confluenceSpaceTaskStore.getSpaceAttachmentsOnlyTaskProgressByPlan(planId, spaceKeys)) : this.ptx.read(() -> this.confluenceSpaceTaskStore.getSpaceProgressByPlan(planId, spaceKeys));
        Map<String, ContentSummary> spaceKeyToSummary = this.mapContentSummariesForSpaceKeys(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDto((Space)space, spaceKeyToSummary, spaceKeyToProgress)).collect(Collectors.toList());
    }

    private Collection<SpaceDto> getSpaceDtos(String cloudId, List<Space> spaces) {
        List<String> spaceKeys = spaces.stream().map(Space::getKey).collect(Collectors.toList());
        Map spaceKeyToProgress = this.ptx.read(() -> this.confluenceSpaceTaskStore.getLatestSpaceProgress(cloudId, spaceKeys));
        Map<String, ContentSummary> spaceKeyToSummary = this.mapContentSummariesForSpaceKeys(spaceKeys);
        return spaces.stream().map(space -> this.spaceToDto((Space)space, spaceKeyToSummary, spaceKeyToProgress)).collect(Collectors.toList());
    }

    private SpaceDto spaceToDto(Space space, Map<String, ContentSummary> spaceKeyToSummary, Map<String, Progress> spaceKeyToProgress) {
        String spaceKey = space.getKey();
        ContentSummary spaceSummary = spaceKeyToSummary.getOrDefault(spaceKey, ContentSummary.ZERO);
        long estimationSeconds = this.migrationTimeEstimationUtils.estimateSpaceMigrationTime(spaceSummary).getSeconds();
        return new SpaceDto(spaceKey, space.getId(), space.getName(), spaceSummary, Optional.ofNullable(spaceKeyToProgress.get(spaceKey)).map(ProgressDto::fromPlanEntity).orElse(null), estimationSeconds, Optional.ofNullable(space.getType()).map(SpaceType::forName).orElse(null));
    }

    @VisibleForTesting
    SpaceDto mapSpaceWithStatisticResultToSpaceDto(SpaceWithStatisticResult space) {
        AttachmentStats attachmentStats = AttachmentStats.builder().totalSize(space.getAttachmentSize()).build();
        ContentSummary contentSummary = ContentSummary.builder().numberOfPages(space.getPageBlogDraftCount()).numberOfAttachments(space.getAttachmentCount()).numberOfTeamCalendars(space.getTeamCalendarCount()).attachments(attachmentStats).lastModified(space.getLastModified()).build();
        return new SpaceDto(space.getKey(), space.getId(), space.getName(), contentSummary, space.getStatus() != null ? ProgressDto.fromStatus(space.getStatus()) : null, space.getEstimatedMigrationTime() != null ? Long.valueOf(space.getEstimatedMigrationTime() / 1000L) : null, space.getSpaceType() != null ? SpaceType.forName((String)space.getSpaceType()) : null);
    }

    private Collection<SpaceDto> getSpaceDTOsForNewSpaceSelector(List<SpaceWithStatisticResult> spacesWithStatistics) {
        return spacesWithStatistics.stream().map(this::mapSpaceWithStatisticResultToSpaceDto).collect(Collectors.toList());
    }
}

