/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.config.url.MigrationEnvironment;
import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.PlanService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventConsumer;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.migration.agent.service.impl.CloudSettingsException;
import com.atlassian.migration.agent.service.impl.CloudTypeSettingsService;
import com.atlassian.migration.agent.service.impl.PlanDecoratorService;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudTypeSettingsWrapperService {
    private static final Logger log = LoggerFactory.getLogger(CloudTypeSettingsWrapperService.class);
    private final PlanService planService;
    private final CheckResultsService checkResultsService;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventConsumer analyticsEventConsumer;
    private final CloudSiteService cloudSiteService;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final PlanDecoratorService planDecoratorService;
    private final FeatureFlagClient featureFlagClient;
    private final CloudTypeSettingsService cloudTypeSettingsService;

    public CloudTypeSettingsWrapperService(MigrationAgentConfiguration migrationAgentConfiguration, PlanService planService, CheckResultsService checkResultsService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventConsumer analyticsEventConsumer, CloudSiteService cloudSiteService, PlanDecoratorService planDecoratorService, FeatureFlagClient featureFlagClient, CloudTypeSettingsService cloudTypeSettingsService) {
        this.planService = planService;
        this.checkResultsService = checkResultsService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventConsumer = analyticsEventConsumer;
        this.cloudSiteService = cloudSiteService;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.planDecoratorService = planDecoratorService;
        this.featureFlagClient = featureFlagClient;
        this.cloudTypeSettingsService = cloudTypeSettingsService;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void initialize() {
        this.setMigrationConfigurationUrlProviderAndFx3Client(this.getCloudTypeSettings());
    }

    public Map<CloudType, Boolean> getCloudTypeSettings() {
        return this.cloudTypeSettingsService.getCloudTypeSettings();
    }

    public void setCloudTypeSettings(Map<CloudType, Boolean> cloudTypeMap) {
        if (this.checkResultsService.hasRunningPreflights()) {
            log.warn("Cannot change environment while preflights are running");
            throw new CloudSettingsException("Cannot change environment while preflights are running");
        }
        if (this.planService.hasPlansRunningOrStopping()) {
            log.warn("Cannot change environment while plans are running/stopping");
            throw new CloudSettingsException("Cannot change environment while plans are running/stopping");
        }
        if (this.planDecoratorService.hasAppMigrationInProgress()) {
            log.warn("Cannot change environment while app migrations are running");
            throw new CloudSettingsException("Cannot change environment while app migrations are running");
        }
        boolean settingsSuccessfullyUpdated = this.cloudTypeSettingsService.setCloudTypeSettings(cloudTypeMap);
        if (settingsSuccessfullyUpdated) {
            String cloudTypeMapStr = Jsons.valueAsString(cloudTypeMap);
            this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.analyticsEventBuilder.buildUpdatedCloudTypeSettingsAnalyticEvent(cloudTypeMapStr)));
            this.analyticsEventConsumer.triggerJobAndDeleteRemainingEvents();
            this.setMigrationConfigurationUrlProviderAndFx3Client(cloudTypeMap);
            log.info("Successfully set the environment from settings to {}", (Object)cloudTypeMapStr);
            this.cloudSiteService.markAllTokensAsFailed();
        }
    }

    public void setMigrationConfigurationUrlProviderAndFx3Client(Map<CloudType, Boolean> cloudTypeMap) {
        if (cloudTypeMap.get((Object)CloudType.FEDRAMP).booleanValue()) {
            this.featureFlagClient.setFx3ActiveClient(this.featureFlagClient.getFx3ClientFedramp());
            this.migrationAgentConfiguration.setUrlProvider(MigrationEnvironment.FEDRAMP);
        } else {
            this.featureFlagClient.setFx3ActiveClient(this.featureFlagClient.getFx3Client());
            this.migrationAgentConfiguration.setUrlProvider(MigrationEnvironment.DEFAULT);
        }
    }
}

