/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.migration.agent.v4.recipe.RecipeConstants;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;

public enum StatsigDynamicConfigs {
    DISABLE_READ_SPACE_UPLOAD_CONFIG_FROM_DB("disable-read-upload-config-db", ConfigType.BOOLEAN, false),
    DISABLE_TEAM_CALENDARS_MIGRATION("disable-team-calendar-mig", ConfigType.BOOLEAN, false),
    KEEP_FILENAME_AS_PARAM_TO_MEDIA_API("keep-filename-media-config", ConfigType.BOOLEAN, true),
    DISABLE_SAFE_DESERIALIZATION("disable-safe-deserializ-config", ConfigType.BOOLEAN, true),
    ENABLE_V4_SHADOW_MIGRATIONS("enablev4shadowmigration-config", ConfigType.BOOLEAN, false),
    ENABLE_V4_MIGRATION_PROTOCOL("enable-v4-migration-config", ConfigType.BOOLEAN, false),
    ENABLE_V4_LITHIUM("enable-v4-lithium", ConfigType.BOOLEAN, false),
    V4_LITHIUM_RECIPE_VERSION("v4-lithium-recipe-version", ConfigType.NUMBER, RecipeConstants.V4_LITHIUM_RECIPE_VERSION_DEFAULT),
    ENABLE_RDS_INFRA_OPTIMISATION("enable-infra-optimis-config", ConfigType.BOOLEAN, false),
    ENABLE_MS_FOR_CONNECT_TO_CLOUD("ms-for-connect-to-cloud-config", ConfigType.BOOLEAN, false),
    ENABLE_PARALLEL_SCOPED_USERS_AND_GROUPS_EXPORT("enable-parallel-ug-export", ConfigType.BOOLEAN, false),
    ENABLE_PARALLEL_SCOPED_UG_MIN_MAX("enable-scoped-ug-min-max", ConfigType.NUMBER_LIST, new Double[]{1.0, 4.0}),
    OVERRIDE_CLUSTER_CONCURRENCY("override-cluster-concurrency", ConfigType.NUMBER_LIST, Arrays.asList(2.0, 2.0, 1.0, 1.0, 2.0, 2.0, 4.0, 4.0, 25.0)),
    ENABLE_TRANSFORMERS_FOR_CONTENT_IN_BODY_CONTENT("enable-transformers-content", ConfigType.BOOLEAN, false),
    ENABLE_P2_TO_FORGE_MACRO_CONVERSION("enable-p2-to-forge-macro", ConfigType.BOOLEAN, false),
    PROMETHEUS_POLLER_POLL_INTERVAL("prometheus-poll-interval", ConfigType.NUMBER, Duration.ofMinutes(1L).toMillis()),
    PROMETHEUS_POLLER_EXPORT_INTERVAL("prometheus-export-interval", ConfigType.NUMBER, Duration.ofMinutes(5L).toMillis()),
    MEDIA_PER_MINUTE_STABLE_RATE_LIMIT("media-per-min-max-rate-limit", ConfigType.NUMBER, 84000.0),
    MEDIA_RATE_LIMIT_RAMP_UP_TIME_SECONDS("media-rate-limit-ramp-in-sec", ConfigType.NUMBER, 600.0),
    DISABLE_BROWSER_METRICS_APIS("disable-browser-metrics-apis", ConfigType.BOOLEAN, true);

    private final String configName;
    private final ConfigType configType;
    private final Object defaultValue;

    private StatsigDynamicConfigs(String configName, ConfigType configType, Object defaultValue) {
        this.configName = configName;
        this.configType = configType;
        this.defaultValue = defaultValue;
    }

    public String getConfigName() {
        return "migration-assistant-" + this.configName;
    }

    @Generated
    public ConfigType getConfigType() {
        return this.configType;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static enum ConfigType {
        STRING,
        NUMBER,
        BOOLEAN,
        STRING_LIST,
        NUMBER_LIST;

    }
}

