/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.model.ProductEditionDetails;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientFactory;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.sal.api.license.LicenseChangedEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fx3Helper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Fx3Helper.class);
    private final Fx3ClientFactory fx3ClientFactory;
    private final FeatureFlagClient featureFlagClient;
    private final MigrationPlatformService migrationService;
    private final EventPublisher eventPublisher;
    private static final String MIGRATION_TYPE = "MigrationType";
    private static final String SPACE_COUNT = "SpaceCount";
    private static final String CLOUD_ID = "CloudId";
    private static final String REGION = "Region";
    private static final String CLOUD_TYPE = "CloudType";
    private static final String EDITION = "Edition";
    private static final List<String> CONFLUENCE_PRODUCTS = Collections.singletonList("Confluence");
    private static final String DEFAULT_CLOUD_EDITION = "free";
    private static final String PRODUCT_EDITION = "ProductEdition";

    @javax.inject.Inject
    @Inject
    public Fx3Helper(Fx3ClientFactory fx3ClientFactory, FeatureFlagClient featureFlagClient, MigrationPlatformService migrationService, EventPublisher eventPublisher) {
        this.fx3ClientFactory = fx3ClientFactory;
        this.featureFlagClient = featureFlagClient;
        this.migrationService = migrationService;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    void init() {
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    void cleanup() {
        this.eventPublisher.unregister((Object)this);
    }

    public void updateUserCustomAttributes(Plan plan) {
        Map<String, Object> fx3UserCustomAttributesMap = this.fx3ClientFactory.createCustomAttributesMap();
        this.populatePlanCustomAttributes(fx3UserCustomAttributesMap, plan);
        this.featureFlagClient.updateCustomAttributes(fx3UserCustomAttributesMap);
    }

    @EventListener
    public void handleLicenseChangedEvent(LicenseChangedEvent event) {
        Map<String, Object> customAttributesMap = this.fx3ClientFactory.createCustomAttributesMap();
        this.featureFlagClient.updateCustomAttributes(customAttributesMap);
    }

    private void populatePlanCustomAttributes(Map<String, Object> fx3UserCustomAttributesMap, Plan plan) {
        CloudSite cloudSite = plan.getCloudSite();
        Optional<CloudEdition> cloudEdition = Optional.ofNullable(cloudSite.getEdition());
        fx3UserCustomAttributesMap.put(MIGRATION_TYPE, this.evaluateMigrationType(plan));
        fx3UserCustomAttributesMap.put(SPACE_COUNT, this.getSpacesCount(plan));
        fx3UserCustomAttributesMap.put(CLOUD_ID, cloudSite.getCloudId());
        fx3UserCustomAttributesMap.put(REGION, StringUtils.isEmpty((CharSequence)cloudSite.getMicrosRegion()) ? this.migrationService.getConfluenceShardDetails(plan.getCloudSite().getContainerToken()).getShardInfo().get("region") : cloudSite.getMicrosRegion());
        fx3UserCustomAttributesMap.put(CLOUD_TYPE, (Object)cloudSite.getCloudType());
        fx3UserCustomAttributesMap.put(EDITION, cloudEdition.map(Enum::name).orElse("NOT PRESENT"));
        fx3UserCustomAttributesMap.put(PRODUCT_EDITION, this.fetchProductEditionDetails(plan.getCloudSite()));
    }

    private Integer getSpacesCount(Plan plan) {
        return plan.getTasks().stream().filter(task -> task.getType().equals((Object)TaskType.SPACE) || task.getType().equals((Object)TaskType.ATTACHMENTS)).collect(Collectors.toSet()).size();
    }

    private String evaluateMigrationType(Plan plan) {
        List<Task> tasks = plan.getTasks();
        if (this.hasAppsTask(tasks)) {
            return TaskType.APPS.name();
        }
        if (this.isSpaceAttachmentsOnlyTasks(tasks)) {
            return TaskType.ATTACHMENTS.name();
        }
        if (this.isUsersAndGroupsOnlyTasks(tasks)) {
            return TaskType.USERS.name();
        }
        if (this.hasSpaceTasks(tasks)) {
            return TaskType.SPACE.name();
        }
        if (this.hasGlobalEntitiesTasks(tasks)) {
            return TaskType.GLOBAL_ENTITIES.name();
        }
        return "NONE";
    }

    private String fetchProductEditionDetails(CloudSite cloudSite) {
        try {
            Set productEditionList = this.migrationService.fetchProductEditionDetails(cloudSite.getContainerToken()).getData().getEssotEntitlement().stream().filter(entitlement -> CONFLUENCE_PRODUCTS.stream().anyMatch(product -> {
                String productName = entitlement.getProductCatalogItem().getName();
                return productName != null && Pattern.compile(product).matcher(productName).find();
            })).map(ProductEditionDetails.Entitlement::getEdition).filter(Objects::nonNull).collect(Collectors.toSet());
            String productEditionListString = productEditionList.toString();
            log.info("Fetched Product edition details from Hydra {}", (Object)productEditionListString);
            return productEditionListString;
        }
        catch (Exception e) {
            log.error("Error Occurred while fetching product edition details from Hydra", (Throwable)e);
            return DEFAULT_CLOUD_EDITION;
        }
    }

    private boolean isSpaceAttachmentsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.ATTACHMENTS));
    }

    private boolean isUsersAndGroupsOnlyTasks(List<Task> tasks) {
        return tasks.stream().allMatch(task -> task.getType().equals((Object)TaskType.USERS));
    }

    private boolean hasGlobalEntitiesTasks(List<Task> tasks) {
        return tasks.stream().anyMatch(task -> task.getType().equals((Object)TaskType.GLOBAL_ENTITIES));
    }

    private boolean hasAppsTask(List<Task> tasks) {
        return tasks.stream().anyMatch(task -> task.getType().equals((Object)TaskType.APPS));
    }

    private boolean hasSpaceTasks(List<Task> tasks) {
        return tasks.stream().anyMatch(task -> task.getType().equals((Object)TaskType.SPACE));
    }
}

