/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.cloud;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.rest.GenerateCloudSiteSetupUrlDto;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.cloud.NonceService;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class CloudSiteSetupService {
    private static final String QUERY_PARAM_ECTL_REDIRECT = "ectl_redirect";
    private static final String ECTL_BUNDLE_CONFLUENCE = "confluence";
    private static final String CONFLUENCE_PRODUCT_FAMILY = "confluence";
    private static final String CONFLUENCE_MIGRATION_TYPE = "S2C_MIGRATION";
    private final NonceService nonceService;
    private final SENSupplier senSupplier;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final ApplicationProperties applicationProperties;
    private final LegalService legalService;
    private final AnalyticsConfigService analyticsConfigService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public CloudSiteSetupService(NonceService nonceService, SENSupplier senSupplier, MigrationAgentConfiguration migrationAgentConfiguration, ApplicationProperties applicationProperties, LegalService legalService, AnalyticsConfigService analyticsConfigService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.nonceService = nonceService;
        this.senSupplier = senSupplier;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.applicationProperties = applicationProperties;
        this.legalService = legalService;
        this.analyticsConfigService = analyticsConfigService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public String generateCloudSiteSetupUrl(GenerateCloudSiteSetupUrlDto setupDto) {
        return this.setupUrlBuilder(setupDto, this.migrationDarkFeaturesManager.isSiteAdminMigrationsEnabled()).build().toString();
    }

    public String generateEctlRedirectUrl(GenerateCloudSiteSetupUrlDto setupDto) {
        return this.setupUrlBuilder(setupDto, false).addQueryParameter(QUERY_PARAM_ECTL_REDIRECT, "confluence").build().toString();
    }

    private HttpUrl.Builder setupUrlBuilder(GenerateCloudSiteSetupUrlDto setupDto, boolean includeVersionParam) {
        String sen;
        String mgBaseUrl = this.migrationDarkFeaturesManager.enableMsForConnectToCloud() ? this.migrationAgentConfiguration.getMigrationServiceGatewayURI() : this.migrationAgentConfiguration.getMigrationGatewayUrl();
        HttpUrl.Builder setupUrlBuilder = HttpUrl.parse((String)mgBaseUrl).newBuilder().addPathSegment("setup").addQueryParameter("back", setupDto.returnUrl.toString()).addQueryParameter("product", "confluence").addQueryParameter("migrationType", CONFLUENCE_MIGRATION_TYPE);
        String nonce = this.nonceService.generateAndSaveNonce();
        HttpUrl.Builder continueURIBuilder = HttpUrl.parse((String)this.applicationProperties.getBaseUrl(UrlMode.CANONICAL)).newBuilder().addPathSegment("admin").addPathSegment("save-cloud-site.action").addQueryParameter("nonce", nonce).addQueryParameter("cloudType", setupDto.cloudType.toString()).addQueryParameter("redirectTo", setupDto.redirectTo);
        if (StringUtils.isNotEmpty((CharSequence)setupDto.planId)) {
            continueURIBuilder.addQueryParameter("planId", setupDto.planId);
        }
        HttpUrl continueUrl = continueURIBuilder.build();
        setupUrlBuilder.addQueryParameter("continue", continueUrl.toString());
        if ((this.legalService.getRememberLegalOptIn() || this.analyticsConfigService.canCollectAnalytics()) && StringUtils.isNotEmpty((CharSequence)(sen = this.senSupplier.get()))) {
            setupUrlBuilder.addQueryParameter("sen", sen);
        }
        if (includeVersionParam) {
            setupUrlBuilder.addQueryParameter("version", "2");
        }
        return setupUrlBuilder;
    }
}

