/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.space;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.check.PreflightLogContext;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.space.SpaceConflictContext;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.confluence.ConfluenceCloudService;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class SpaceConflictChecker
implements Checker<SpaceConflictContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceConflictChecker.class);
    private static final String VIOLATIONS_KEY = "violations";
    private final CloudSiteService cloudSiteService;
    private final ConfluenceCloudService confluenceCloudService;
    private final PreflightLogger preflightLogger;

    public SpaceConflictChecker(CloudSiteService cloudSiteService, ConfluenceCloudService confluenceCloudService, PreflightLogger preflightLogger) {
        this.cloudSiteService = cloudSiteService;
        this.confluenceCloudService = confluenceCloudService;
        this.preflightLogger = preflightLogger;
    }

    public CheckResult check(SpaceConflictContext ctx) {
        PreflightLogContext logContext = PreflightLogContext.builder().checkType(SpaceConflictChecker.class.getName()).isSuccess(null).checkExecutionId(ctx.checkExecutionId).build();
        logContext.addAdditionalProperties("spaceKeys", ctx.spaceKeys, "cloudId", ctx.cloudId);
        if (CollectionUtils.isEmpty(ctx.spaceKeys)) {
            logContext.setIsSuccess(true);
            this.preflightLogger.logInfo(log, logContext, "No space keys provided, skipping conflict check.");
            return new CheckResult(true);
        }
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(ctx.cloudId);
        if (!cloudSite.isPresent()) {
            PreflightErrorCode errorCode = PreflightErrorCode.CLOUD_ERROR;
            logContext.setIsSuccess(false);
            logContext.addAdditionalProperties("errorCode", errorCode.getCode(), "errorMessage", errorCode.getMessage());
            this.preflightLogger.logError(log, logContext, "Space Conflict Check failed due to cloudId not found", null);
            return Checker.buildCheckResultWithExecutionError((int)errorCode.getCode());
        }
        try {
            Set<SpaceConflict> spaceConflictsResult = this.confluenceCloudService.getConflictingSpaces(cloudSite.get(), ctx.spaceKeys);
            List spaceConflicts = spaceConflictsResult.stream().sorted(Comparator.comparing(space -> space.key)).collect(Collectors.toList());
            logContext.setIsSuccess(spaceConflicts.isEmpty());
            logContext.addAdditionalProperties(VIOLATIONS_KEY, spaceConflicts);
            if (spaceConflicts.isEmpty()) {
                this.preflightLogger.logInfo(log, logContext, "No space conflicts detected.");
            } else {
                this.preflightLogger.logInfo(log, logContext, "Space conflicts detected.");
            }
            return new CheckResult(spaceConflicts.isEmpty(), Collections.singletonMap(VIOLATIONS_KEY, spaceConflicts));
        }
        catch (RuntimeException e) {
            logContext.setIsSuccess(false);
            logContext.addAdditionalProperties("errorMessage", e.getMessage());
            this.preflightLogger.logError(log, logContext, "Error executing space keys conflict check.", e);
            return Checker.buildCheckResultWithExecutionError((int)PreflightErrorCode.SPACE_CONFLICTS_CHECK_ERROR.getCode());
        }
    }

    static List<SpaceConflict> retrieveConflictingSpaces(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS_KEY, Collections.emptyList());
    }
}

