/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.space;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.PreflightLogContext;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.space.SpaceAnonymousPermissionContext;
import com.atlassian.migration.agent.store.impl.SpacePermissionStore;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class SpaceAnonymousPermissionChecker
implements Checker<SpaceAnonymousPermissionContext> {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceAnonymousPermissionChecker.class);
    static final String SPACE_ANONYMOUS_PERMISSIONS_FILE_PREFIX = "SpacesWithAnonymousPermissions";
    private final SpacePermissionStore spacePermissionStore;
    private final CheckResultFileManager checkResultFileManager;
    private final PreflightLogger preflightLogger;

    public SpaceAnonymousPermissionChecker(SpacePermissionStore spacePermissionStore, CheckResultFileManager checkResultFileManager, PreflightLogger preflightLogger) {
        this.spacePermissionStore = spacePermissionStore;
        this.checkResultFileManager = checkResultFileManager;
        this.preflightLogger = preflightLogger;
    }

    public CheckResult check(SpaceAnonymousPermissionContext ctx) {
        PreflightLogContext logContext = PreflightLogContext.builder().checkType(SpaceAnonymousPermissionChecker.class.getName()).isSuccess(null).checkExecutionId(ctx.checkExecutionId).build();
        logContext.addAdditionalProperties("spaceKeys", ctx.spaceKeys);
        this.preflightLogger.logInfo(log, logContext, String.format("Running space anonymous permissions check for %d spaces", ctx.spaceKeys.size()));
        try {
            List<String> spaceKeysWithAnonPermissions = this.spacePermissionStore.getSpacesWithAnonymousPermissions(ctx.spaceKeys);
            if (spaceKeysWithAnonPermissions.isEmpty()) {
                logContext.setIsSuccess(true);
                logContext.addAdditionalProperties("violationsCount", 0);
                this.preflightLogger.logInfo(log, logContext, "No spaces with anonymous permissions found.");
                return new CheckResult(true, Collections.singletonMap("violationsCount", 0));
            }
            String path = this.checkResultFileManager.writeToJsonFile(SPACE_ANONYMOUS_PERMISSIONS_FILE_PREFIX, spaceKeysWithAnonPermissions);
            logContext.setIsSuccess(false);
            logContext.addAdditionalProperties("violationsCount", spaceKeysWithAnonPermissions.size(), "detailsPath", path);
            this.preflightLogger.logInfo(log, logContext, "Spaces with anonymous permissions detected.");
            return new CheckResult(false, (Map)ImmutableMap.of((Object)"violationsCount", (Object)spaceKeysWithAnonPermissions.size(), (Object)"path", (Object)path));
        }
        catch (Exception e) {
            logContext.setIsSuccess(false);
            logContext.addAdditionalProperties("errorMessage", e.getMessage());
            this.preflightLogger.logError(log, logContext, "Error executing space anonymous permissions check.", e);
            return Checker.buildCheckResultWithExecutionError((int)PreflightErrorCode.GENERIC_ERROR.getCode());
        }
    }

    public static Integer retrieveSpaceWithAnonymousAccessCount(Map<String, Object> details) {
        return Integer.valueOf(details.getOrDefault("violationsCount", 0).toString());
    }
}

