/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.SpaceConflict;
import com.atlassian.migration.agent.service.analytics.AppsPreflightAnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.PreflightAnalyticsEventParams;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.network.NetworkCheckResult;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.app.dto.check.CheckDetail;
import com.atlassian.migration.app.dto.check.CheckStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import jakarta.annotation.Nullable;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PreflightChecksAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final PluginVersionManager pluginVersionManager;
    private final MigrationDarkFeaturesManager featuresManager;

    public PreflightChecksAnalyticsEventBuilder(SENSupplier senSupplier, PluginVersionManager pluginVersionManager, MigrationDarkFeaturesManager featuresManager) {
        this(senSupplier, Instant::now, pluginVersionManager, featuresManager);
    }

    @VisibleForTesting
    PreflightChecksAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, PluginVersionManager pluginVersionManager, MigrationDarkFeaturesManager featuresManager) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.pluginVersionManager = pluginVersionManager;
        this.featuresManager = featuresManager;
    }

    private ImmutableMap.Builder<String, Object> getBuilderWithCommonAttributes() {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            attributes.put((Object)"processCpuLoad", (Object)String.format("%.2f", osBean.getProcessCpuLoad() * 100.0));
        }
        catch (Exception | NoClassDefFoundError e) {
            attributes.put((Object)"processCpuLoad", (Object)"NA");
        }
        attributes.put((Object)"freeHeapSizeInBytes", (Object)Runtime.getRuntime().freeMemory());
        attributes.put((Object)"productFamily", (Object)"confluence");
        attributes.put((Object)"migrationType", (Object)"S2C_MIGRATION");
        return attributes;
    }

    private void addCommonAttributesInPreflightCheck(PreflightAnalyticsEventParams eventParams, ImmutableMap.Builder<String, Object> attributes) {
        attributes.put((Object)"success", (Object)eventParams.isSuccess());
        attributes.put((Object)"totalTime", (Object)String.format(Locale.US, "%.1f", (double)eventParams.getTotalTime() / 1000.0));
        if (eventParams.getUniqueId() != null) {
            attributes.put((Object)"uniqueId", (Object)eventParams.getUniqueId());
        }
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
    }

    public EventDto buildPreflightDuplicateEmails(PreflightAnalyticsEventParams eventParams, List<EmailDuplicate> duplicateEmails) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        LongAdder numberOfEmails = new LongAdder();
        LongAdder numberOfUsers = new LongAdder();
        duplicateEmails.forEach(duplicateEmail -> {
            numberOfEmails.increment();
            numberOfUsers.add(duplicateEmail.ids.size());
        });
        attributes.put((Object)"numberOfSharedEmails", (Object)Long.toString(numberOfEmails.longValue()));
        attributes.put((Object)"numberOfUsers", (Object)Long.toString(numberOfUsers.longValue()));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("sharedEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightInvalidEmails(PreflightAnalyticsEventParams eventParams, List<EmailData> invalidEmails) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfInvalidEmails", (Object)Long.toString(invalidEmails.size()));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("invalidEmailsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGroupNamesConflict(PreflightAnalyticsEventParams eventParams, List<String> groups) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfGroups", (Object)Long.toString(groups.size()));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("cloudExistantGroupsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceKeysConflict(PreflightAnalyticsEventParams eventParams, List<SpaceConflict> conflicts) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfSpaces", (Object)Long.toString(conflicts.size()));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("spaceConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightGlobalDataTemplatesConflict(PreflightAnalyticsEventParams eventParams, int numOfConflicts) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfTemplates", (Object)Integer.toString(numOfConflicts));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("globalDataTemplateConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppOutdated(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("migrationAssistantOutdatedCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightConfluenceSupportedVersionCheck(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject(CheckType.CONFLUENCE_SUPPORTED_VERSION.value())).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudFreeUsersCheck(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("cloudFreeUsersConflictCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightCloudPremiumEditionCheck(PreflightAnalyticsEventParams eventParams, String edition) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        if (edition != null) {
            attributes.put((Object)"edition", (Object)edition);
        }
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("cloudPremiumEditionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightSpaceAnonymousAccess(PreflightAnalyticsEventParams eventParams, Integer numberOfSpaces) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfSpaces", (Object)Integer.toString(numberOfSpaces));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("spaceAnonymousPermissionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightTcAppVersion(PreflightAnalyticsEventParams eventParams, String appVersion) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        if (appVersion != null) {
            attributes.put((Object)"tcAppVersion", (Object)appVersion);
        }
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("teamCalendarsVersionCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreFlightContainerTokenExpiration(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("containerTokenExpirationCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreFlightMigrationOrchestratorMaintenance(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.addCommonAttributesInPreflightCheck(eventParams, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("migrationOrchestratorMaintenanceCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppDataConsent(PreflightAnalyticsEventParams eventParams, int apps) {
        return this.buildPreflightAppsDefault("appDataMigrationConsentCheck", eventParams, apps);
    }

    public EventDto buildPreflightAppReliability(PreflightAnalyticsEventParams eventParams, int apps) {
        return this.buildPreflightAppsDefault("appReliabilityCheck", eventParams, apps);
    }

    public EventDto buildPreflightServerAppOutdated(PreflightAnalyticsEventParams eventParams, int apps) {
        return this.buildPreflightAppsDefault("serverAppOutdatedCheck", eventParams, apps);
    }

    public EventDto buildPreflightAppsNotInstalledOnCloud(PreflightAnalyticsEventParams eventParams, int apps) {
        return this.buildPreflightAppsDefault("appsNotInstalledOnCloudCheck", eventParams, apps);
    }

    public EventDto buildPreflightAppLicenseCheck(AppsPreflightAnalyticsEventParams eventParams) {
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("appLicenseCheck")).withAttributes(this.createAppPreflightCheckCommonAttributes(eventParams))).build();
    }

    public EventDto buildPreflightAppListenerCheck(AppsPreflightAnalyticsEventParams eventParams) {
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("appMissingListenerCheck")).withAttributes(this.createAppPreflightCheckCommonAttributes(eventParams))).build();
    }

    private Map<String, Object> createAppPreflightCheckCommonAttributes(AppsPreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(eventParams.getNumberOfAppsChecked()));
        attributes.put((Object)"numberOfAppsChecked", (Object)Integer.toString(eventParams.getNumberOfAppsChecked()));
        attributes.put((Object)"numberOfAppsFailed", (Object)Integer.toString(eventParams.getAppsFailed().size()));
        attributes.put((Object)"appsWithSuccessfulCheck", eventParams.getAppsSucceeded());
        attributes.put((Object)"appsWithFailedCheck", eventParams.getAppsFailed());
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return attributes.build();
    }

    public EventDto buildPreflightAppsDefault(String subject, PreflightAnalyticsEventParams eventParams, int apps) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(apps));
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject(subject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightAppVendorCheck(PreflightAnalyticsEventParams eventParams) {
        if (Checker.retrieveExecutionErrorCode((CheckResult)eventParams.getCheckResult()) != null) {
            ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
            attributes.put((Object)"atlassianException", (Object)true);
            this.addCommonAttributesInPreflightCheck(eventParams, attributes);
            return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
        }
        Map appVendorCheckResult = eventParams.getCheckResult().details;
        int totalNumberOfApps = appVendorCheckResult.size();
        Set resultDtos = appVendorCheckResult.values().stream().flatMap(checkIdToCheckResultMap -> ((HashMap)checkIdToCheckResultMap).values().stream()).collect(Collectors.toSet());
        int totalChecksExecuted = resultDtos.size();
        int totalFailedChecks = (int)resultDtos.stream().filter(checkResultDto -> checkResultDto.status != CheckStatus.SUCCESS).count();
        List checksWithStatusWarning = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.WARNING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusBlocked = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.BLOCKING).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithStatusCheckExecutionError = resultDtos.stream().filter(checkResultDto -> checkResultDto.status == CheckStatus.CHECK_EXECUTION_ERROR).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List unsuccessfulChecksWithCsvContent = resultDtos.stream().filter(checkResultDto -> checkResultDto.showCsv).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithException = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.EXCEPTION)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithTimeout = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.TIMEOUT)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        List checksWithCsvTruncation = resultDtos.stream().filter(checkResultDto -> checkResultDto.getCheckDetails() != null && checkResultDto.getCheckDetails().contains(CheckDetail.CSV_TRUNCATED)).map(checkResultDto -> checkResultDto.checkId).collect(Collectors.toList());
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfApps", (Object)Integer.toString(totalNumberOfApps));
        attributes.put((Object)"numberOfChecksExecuted", (Object)Integer.toString(totalChecksExecuted));
        attributes.put((Object)"numberOfFailedChecks", (Object)Integer.toString(totalFailedChecks));
        attributes.put((Object)"unsuccessfulChecksAsWarning", checksWithStatusWarning);
        attributes.put((Object)"unsuccessfulChecksAsBlocking", checksWithStatusBlocked);
        attributes.put((Object)"unsuccessfulChecksAsCheckExecutionError", checksWithStatusCheckExecutionError);
        attributes.put((Object)"unsuccessfulChecksWithCSVContent", unsuccessfulChecksWithCsvContent);
        attributes.put((Object)"checksWithException", checksWithException);
        attributes.put((Object)"checksWithTimeout", checksWithTimeout);
        attributes.put((Object)"checksWithCsvTruncation", checksWithCsvTruncation);
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("appVendorCheck")).withAttributes((Map)attributes.build())).build();
    }

    public List<EventDto> buildPreflightAppVendorCheckIndividual(@javax.annotation.Nullable @Nullable String planId, @javax.annotation.Nullable @Nullable String planMigrationTag, PreflightAnalyticsEventParams eventParams) {
        return eventParams.getCheckResult().details.entrySet().stream().flatMap(entry -> {
            Map checkIdToCheckResultMap = (Map)entry.getValue();
            return checkIdToCheckResultMap.values().stream().map(checkResultDto -> {
                boolean executed = checkResultDto.status != CheckStatus.CHECK_EXECUTION_ERROR;
                boolean success = checkResultDto.status == CheckStatus.SUCCESS;
                boolean csvContentTruncated = false;
                boolean exception = false;
                boolean timeout = false;
                if (checkResultDto.getCheckDetails() != null) {
                    csvContentTruncated = checkResultDto.getCheckDetails().contains(CheckDetail.CSV_TRUNCATED);
                    exception = checkResultDto.getCheckDetails().contains(CheckDetail.EXCEPTION);
                    timeout = checkResultDto.getCheckDetails().contains(CheckDetail.TIMEOUT);
                }
                Object checkParams = ((PreflightAnalyticsEventParams.PreflightAnalyticsEventParamsBuilder)((PreflightAnalyticsEventParams.PreflightAnalyticsEventParamsBuilder)((PreflightAnalyticsEventParams.PreflightAnalyticsEventParamsBuilder)((PreflightAnalyticsEventParams.PreflightAnalyticsEventParamsBuilder)PreflightAnalyticsEventParams.builder().checkResult(new CheckResult(success))).totalTime(eventParams.getTotalTime())).executionId(eventParams.getExecutionId())).uniqueId(eventParams.getUniqueId())).build();
                ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
                this.addCommonAttributesInPreflightCheck((PreflightAnalyticsEventParams)checkParams, attributes);
                attributes.put((Object)"appKey", entry.getKey());
                attributes.put((Object)"csvContentTruncated", (Object)csvContentTruncated);
                attributes.put((Object)"devModeFFEnabled", (Object)this.featuresManager.appMigrationDevMode());
                attributes.put((Object)"csvContent", (Object)checkResultDto.showCsv);
                attributes.put((Object)"exception", (Object)exception);
                attributes.put((Object)"executed", (Object)executed);
                attributes.put((Object)"timeout", (Object)timeout);
                if (checkResultDto.checkId != null) {
                    attributes.put((Object)"checkId", (Object)checkResultDto.checkId);
                }
                if (planId != null) {
                    attributes.put((Object)"planId", (Object)planId);
                }
                if (planMigrationTag != null) {
                    attributes.put((Object)"migrationTag", (Object)planMigrationTag);
                }
                if (checkResultDto.status != null) {
                    attributes.put((Object)"status", (Object)checkResultDto.status);
                }
                return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).actionSubject("appVendorCheckIndividual")).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).withAttributes((Map)attributes.build())).build();
            });
        }).collect(Collectors.toList());
    }

    public EventDto buildPreflightAppWebhookEndpointCheck(AppsPreflightAnalyticsEventParams eventParams, String cloudId) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.createAppPreflightCheckCommonAttributes(eventParams));
        attributes.put("cloudId", cloudId);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("appWebhookEndpointCheck")).withAttributes(attributes)).build();
    }

    public EventDto buildPreflightFailed(String actionSubject, String executionId, int executionErrorCode, @javax.annotation.Nullable @Nullable UUID uniqueId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"executionErrorCode", (Object)executionErrorCode);
        if (uniqueId != null) {
            attributes.put((Object)"uniqueId", (Object)uniqueId);
        }
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("failed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey("preflightCheck"), executionId)).actionSubject(actionSubject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightMissingAttachments(PreflightAnalyticsEventParams eventParams, int size) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfMissingAttachments", (Object)size);
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("missingAttachmentsCheck")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightMissingAttachmentsDynamicParallelism(int totalSpaces, int totalWorkers, int batchSize, @javax.annotation.Nullable @Nullable String planId, String cloudId, String executionId, @javax.annotation.Nullable @Nullable UUID uniqueId) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"totalSpaces", (Object)totalSpaces);
        attributes.put((Object)"totalWorkers", (Object)totalWorkers);
        attributes.put((Object)"batchSize", (Object)batchSize);
        attributes.put((Object)"cloudId", (Object)cloudId);
        attributes.put((Object)"executionId", (Object)executionId);
        if (uniqueId != null) {
            attributes.put((Object)"uniqueId", (Object)uniqueId);
        }
        if (planId != null) {
            attributes.put((Object)"planId", (Object)planId);
        }
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), executionId)).actionSubject("missingAttachmentsDynamicParallelism")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightTrustedDomain(PreflightAnalyticsEventParams eventParams) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        this.addCommonAttributesInPreflightCheck(eventParams, (ImmutableMap.Builder<String, Object>)attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("executed")).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject("trustedDomainCheck")).withAttributes((Map)attributes.build())).build();
    }

    @NotNull
    private GenericOperationalEvent buildPreflightNetworkHealthEvent(String action, String actionSubject, PreflightAnalyticsEventParams eventParams, List<NetworkCheckResult> networkCheckResults) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"numberOfFailedDomains", (Object)Long.toString(networkCheckResults.size()));
        Map<String, List> failedUrlsByServiceNameMap = networkCheckResults.stream().collect(Collectors.toMap(NetworkCheckResult::getName, NetworkCheckResult::getFailedDomains));
        attributes.put((Object)"failedDomainsByServiceName", failedUrlsByServiceNameMap);
        this.addCommonAttributesInPreflightCheck(eventParams, attributes);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(action)).sen(this.senSupplier.get())).source("checkScreen")).contextContainer(this.getContextContainerKey(), eventParams.getExecutionId())).actionSubject(actionSubject)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildPreflightNetworkHealth(PreflightAnalyticsEventParams eventParams, List<NetworkCheckResult> networkCheckResults) {
        return this.buildPreflightNetworkHealthEvent("executed", "networkHealthCheck", eventParams, networkCheckResults);
    }

    public EventDto buildPreMigrationPreflightNetworkHealth(PreflightAnalyticsEventParams eventParams, List<NetworkCheckResult> networkCheckResults) {
        String action = eventParams.isSuccess() ? "executed" : "failed";
        return this.buildPreflightNetworkHealthEvent(action, "networkHealthPreMigrationCheck", eventParams, networkCheckResults);
    }

    public EventDto buildCheckResultDeserializationErrorEvent(String errorReason) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"errorReason", (Object)errorReason);
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("deserializationError")).sen(this.senSupplier.get())).source("checkScreen")).actionSubject("preflightCheck")).withAttributes((Map)attributes.build())).build();
    }

    private String getContextContainerKey() {
        return this.getContextContainerKey(null);
    }

    private String getContextContainerKey(String fallback) {
        return this.featuresManager.isPreflightTrackingEnabled() ? "preflightCheckExecutionId" : fallback;
    }
}

