/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.dto.AttachmentsMigrationDetails;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.analytics.builders.StepLevelAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class AttachmentUploadAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;
    private final StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder;

    public AttachmentUploadAnalyticsEventBuilder(SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this(senSupplier, Instant::now, analyticsEventBuilderUtil, stepLevelAnalyticsEventBuilder);
    }

    @VisibleForTesting
    AttachmentUploadAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.stepLevelAnalyticsEventBuilder = stepLevelAnalyticsEventBuilder;
    }

    public EventDto buildAttachmentMigrationEvent(long totalTime, SpaceAttachmentCount spaceAttachmentCount, UploadState uploadState) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"spaceKey", (Object)spaceAttachmentCount.spaceKey);
        attributes.put((Object)"cloudId", (Object)spaceAttachmentCount.cloudId);
        attributes.put((Object)"contentAttachmentCount", (Object)spaceAttachmentCount.contentAttachmentCount);
        attributes.put((Object)"migAttachmentCount", (Object)spaceAttachmentCount.retrievedMigAttachmentCount);
        attributes.put((Object)"unRetrievableMigAttachmentCount", (Object)spaceAttachmentCount.unRetrievableMigAttachmentCount);
        attributes.put((Object)"allAttachmentsMigrated", (Object)spaceAttachmentCount.hasAllAttachmentsMigrated());
        attributes.put((Object)"numOfAttachments", (Object)uploadState.numOfAttachments);
        attributes.put((Object)"numOfUploadedAttachments", (Object)uploadState.numOfUploadedAttachments);
        attributes.put((Object)"numOfFailedAttachments", (Object)uploadState.numOfFailedAttachments);
        attributes.put((Object)"uploadedBytes", (Object)uploadState.uploadedBytes);
        attributes.put((Object)"totalBytes", (Object)uploadState.totalBytes);
        attributes.put((Object)"numOfAttachmentsAlreadyMigrated", (Object)uploadState.numOfAttachmentsAlreadyMigrated);
        attributes.put((Object)"timeTaken", (Object)totalTime);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("migrated")).sen(this.senSupplier.get())).actionSubject("attachmentMigration")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAttachmentStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step) {
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "attachmentsUploaded", spaceKey, step);
    }

    public EventDto buildAttachmentMigrationStartEvent(Step step, long startTime, int batchSize, long totalCountOfAttachments, long totalSizeOfAttachments, String spaceKey, String migrationId) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute("batchSize", (Object)batchSize);
        stepBuilder.addAttribute("totalCountOfAttachments", (Object)totalCountOfAttachments);
        stepBuilder.addAttribute("totalSizeOfAttachments", (Object)totalSizeOfAttachments);
        stepBuilder.addAttribute("spaceKey", (Object)spaceKey);
        stepBuilder.addAttribute("migrationId", (Object)migrationId);
        return stepBuilder.build();
    }

    public EventDto buildConcurrencySettingsStartEvent(Plan plan, long startTime, Map<?, ?> concurrencySettings, Map<?, ?> migrationParameters) {
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(startTime).action("started")).sen(this.senSupplier.get())).source("user-data-compatibility-plugin-2")).actionSubject("concurrencySettings")).addAttribute("planId", (Object)plan.getId())).addAttribute("migrationId", (Object)plan.getMigrationId())).addAttribute("migrationProtocol", (Object)plan.getMigrationProtocol().name())).addAttribute("concurrencySettings", concurrencySettings)).addAttribute("migrationParameters", migrationParameters)).build();
    }

    public EventDto buildStuckAttachmentsUploadEvent(AttachmentsMigrationDetails attachmentsMigrationDetails) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.createStuckAttachmentsUploadEventBuilder(attachmentsMigrationDetails);
        return stepBuilder.build();
    }

    public EventDto buildAttachmentsFetchStartEvent(String migrationId, String cloudId, String spaceKey, Long attachmentsSize) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"migrationId", (Object)migrationId);
        attributes.put((Object)"cloudId", (Object)cloudId);
        attributes.put((Object)"spaceKey", (Object)spaceKey);
        attributes.put((Object)"attachmentsSize", (Object)attachmentsSize);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("started")).sen(this.senSupplier.get())).actionSubject("attachmentFetch")).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildAttachmentsFetchEndEvent(Boolean success, Long totalTime, String migrationId, String cloudId, String spaceKey, Long attachmentsSize) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"success", (Object)success);
        attributes.put((Object)"totalTime", (Object)totalTime);
        attributes.put((Object)"migrationId", (Object)migrationId);
        attributes.put((Object)"cloudId", (Object)cloudId);
        attributes.put((Object)"spaceKey", (Object)spaceKey);
        attributes.put((Object)"attachmentsSize", (Object)attachmentsSize);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("ended")).sen(this.senSupplier.get())).actionSubject("attachmentFetch")).withAttributes((Map)attributes.build())).build();
    }
}

