/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.dto.SpaceSearchResultDto;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.service.impl.SpaceCatalogService;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.Consumes;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="space")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SpaceCatalogResource {
    private final SpaceCatalogService spaceService;

    @Inject
    public SpaceCatalogResource(SpaceCatalogService spaceService) {
        this.spaceService = spaceService;
    }

    @GET
    @Path(value="/")
    public Response getSpaces(@QueryParam(value="cloudId") String cloudId, @QueryParam(value="query") String nameQuery, @QueryParam(value="spaceType") String spaceType, @QueryParam(value="startIndex") int startIndex, @javax.annotation.Nullable @QueryParam(value="statuses") String statuses, @javax.annotation.Nullable @QueryParam(value="pageSize") Integer pageSize, @javax.annotation.Nullable @QueryParam(value="sortKey") String sortKey, @javax.annotation.Nullable @QueryParam(value="lastEditedStartDate") String lastEditedStartDateISO8601, @javax.annotation.Nullable @QueryParam(value="lastEditedEndDate") String lastEditedEndDateISO8601, @DefaultValue(value="ASC") @QueryParam(value="sortOrder") SortOrder sortOrder) {
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.getSpacesDto(pageSize, cloudId, nameQuery, spaceType, startIndex, statuses, sortKey, lastEditedStartDateISO8601, lastEditedEndDateISO8601, sortOrder)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    public SpaceSearchResultDto getSpacesDto(@javax.annotation.Nullable @Nullable Integer pageSize, String cloudId, String nameQuery, String spaceType, Integer startIndex, @javax.annotation.Nullable @Nullable String statuses, @javax.annotation.Nullable @Nullable String sortKey, @javax.annotation.Nullable @Nullable String lastEditedStartDateISO8601, @javax.annotation.Nullable @Nullable String lastEditedEndDateISO8601, SortOrder sortOrder) throws UnsupportedEncodingException {
        if (pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
        Preconditions.checkNotNull((Object)cloudId, (Object)"cloudId must be set");
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"startIndex must be a positive integer.");
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize must be at least 1");
        SpaceTypeFilter spaceTypeFilter = SpaceCatalogResource.toSpaceTypeFilter(spaceType);
        Instant lastEditedStartDate = this.maybeParseISO8601DateString(lastEditedStartDateISO8601);
        Instant lastEditedEndDate = this.maybeParseISO8601DateString(lastEditedEndDateISO8601);
        if (lastEditedEndDate != null && lastEditedStartDate != null) {
            Preconditions.checkArgument((boolean)lastEditedStartDate.isBefore(lastEditedEndDate), (Object)"The query parameter 'lastEditedStartDate' must refer to an earlier date than 'lastEditedEndDate'.");
        }
        return this.spaceService.getSpaces(cloudId, nameQuery, spaceTypeFilter, this.parseCommaDelimitedStatusesToArray(statuses), startIndex, pageSize, sortKey, sortOrder, lastEditedStartDate, lastEditedEndDate);
    }

    private Instant maybeParseISO8601DateString(String maybeDateString) {
        return Strings.isNullOrEmpty((String)maybeDateString) ? null : Instant.parse(maybeDateString);
    }

    private List<String> parseCommaDelimitedStatusesToArray(String value) throws UnsupportedEncodingException {
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyList();
        }
        String decodedString = URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        return Arrays.asList(decodedString.split(","));
    }

    private static SpaceTypeFilter toSpaceTypeFilter(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return SpaceTypeFilter.ALL;
        }
        return SpaceTypeFilter.valueOf(value.trim().toUpperCase(Locale.ENGLISH));
    }
}

