/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.dto.MigrationSettingsDto;
import com.atlassian.migration.agent.rest.MigrationSettingsResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="settings")
public class MigrationSettingsResourceJakarta {
    private final MigrationSettingsResource originalResource;

    @Inject
    public MigrationSettingsResourceJakarta(MigrationSettingsResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    public Response getSettings(@QueryParam(value="type") @Nullable String type) {
        Pair<Integer, Object> result = this.originalResource.getSettingsDto(type);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @PUT
    public Response updateSettings(MigrationSettingsDto migrationSettingsDto) {
        Pair<Integer, Object> result = this.originalResource.updateSettingsDto(migrationSettingsDto);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }
}

