/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.okhttp.HttpException;
import com.atlassian.migration.agent.rest.AssessmentStatusDto;
import com.atlassian.migration.agent.rest.dto.OutputStreamWriter;
import com.atlassian.migration.agent.rest.dto.StreamResponseSpec;
import com.atlassian.migration.agent.service.guardrails.AssessmentJobProgressService;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentCSVService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.store.guardrails.AssessmentDuration;
import com.atlassian.migration.agent.store.guardrails.AssessmentStatus;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@Path(value="instance/assessment/job")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InstanceAssessmentResource {
    private static final DateTimeFormatter ZIP_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final AssessmentJobProgressService assessmentJobProgressService;
    private final InstanceAssessmentCSVService instanceAssessmentCSVService;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentResource.class);

    @Inject
    public InstanceAssessmentResource(AssessmentJobProgressService assessmentJobProgressService, InstanceAssessmentCSVService instanceAssessmentCSVService, InstanceAssessmentConfigClient instanceAssessmentConfigClient) {
        this.assessmentJobProgressService = assessmentJobProgressService;
        this.instanceAssessmentCSVService = instanceAssessmentCSVService;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
    }

    @GET
    @Path(value="/schedule")
    public Response scheduleNewAssessment(@QueryParam(value="mode") @DefaultValue(value="DEFAULT") InstanceAssessmentMode mode) {
        AssessmentStatusDto result = this.scheduleNewAssessmentDto(mode);
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/cancel")
    public Response cancelAssessment() {
        AssessmentStatusDto result = this.cancelAssessmentDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/csv")
    public Response downloadCSV() {
        Pair<Integer, Object> result = this.downloadCSVDto(false);
        return this.getResponse(result);
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/csv/example")
    public Response downloadExampleCSV() {
        Pair<Integer, Object> result = this.downloadCSVDto(true);
        return this.getResponse(result);
    }

    @GET
    @Path(value="")
    public Response getJobProgress() {
        AssessmentStatusDto result = this.getJobProgressDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/totalduration")
    public Response getTotalJobDuration(@QueryParam(value="mode") @DefaultValue(value="DEFAULT") InstanceAssessmentMode mode) {
        AssessmentDuration result = this.getTotalJobDurationDto(mode);
        return Response.ok((Object)result).build();
    }

    public AssessmentStatusDto scheduleNewAssessmentDto(InstanceAssessmentMode mode) {
        try {
            AssessmentStatus status = this.assessmentJobProgressService.scheduleInstanceAssessment(false, this.getConfig(mode));
            return AssessmentStatusDto.fromAssessmentStatus(status);
        }
        catch (Exception e) {
            log.warn("Exception:", (Throwable)e);
            AssessmentStatus assessmentStatus = AssessmentStatus.failedAssessment(Instant.now());
            return AssessmentStatusDto.fromAssessmentStatus(assessmentStatus);
        }
    }

    public AssessmentStatusDto cancelAssessmentDto() {
        try {
            AssessmentStatus assessmentStatus = this.assessmentJobProgressService.cancelAssessmentCollection();
            return AssessmentStatusDto.fromAssessmentStatus(assessmentStatus);
        }
        catch (Exception e) {
            log.warn("Exception:", (Throwable)e);
            return AssessmentStatusDto.fromAssessmentStatus(AssessmentStatus.failedAssessment());
        }
    }

    public Pair<Integer, Object> downloadCSVDto(boolean exampleOnly) {
        LocalDate today = LocalDate.now();
        String zipDate = ZIP_DATE_FORMATTER.format(today);
        String fileName = "confluence-entities-" + (exampleOnly ? "example-" : "") + zipDate;
        OutputStreamWriter writer = output -> {
            GuardrailsCsvOutputStreamResult result;
            GuardrailsCsvOutputStreamResult guardrailsCsvOutputStreamResult = result = exampleOnly ? this.instanceAssessmentCSVService.generateExample(today, zipDate, output) : this.instanceAssessmentCSVService.generate(today, zipDate, output);
            if (result.getError() != null) {
                throw new HttpException("Exception occurred while download", result.getError());
            }
        };
        String contentDisposition = String.format("attachment; filename=%s.zip", fileName);
        StreamResponseSpec spec = new StreamResponseSpec(writer, "application/zip", contentDisposition);
        return Pair.of((Object)200, (Object)spec);
    }

    private Response getResponse(Pair<Integer, Object> result) {
        int status = (Integer)result.getLeft();
        Object body = result.getRight();
        if (status != 200) {
            return Response.status((int)status).entity(body).build();
        }
        StreamResponseSpec spec = (StreamResponseSpec)body;
        StreamingOutput so = spec.writer::write;
        return Response.ok((Object)so).type(spec.contentType).header("Content-disposition", (Object)spec.contentDisposition).build();
    }

    public AssessmentStatusDto getJobProgressDto() {
        return AssessmentStatusDto.fromAssessmentStatus(this.assessmentJobProgressService.processJobProgress());
    }

    public AssessmentDuration getTotalJobDurationDto(InstanceAssessmentMode mode) {
        return this.assessmentJobProgressService.getTotalJobDuration(this.getConfig(mode));
    }

    @javax.annotation.Nullable
    @Nullable
    private InstanceAssessmentConfig getConfig(InstanceAssessmentMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return InstanceAssessmentConfig.full();
            }
            case 1: {
                return InstanceAssessmentConfig.quick();
            }
        }
        return null;
    }

    public static enum InstanceAssessmentMode {
        FULL,
        QUICK,
        DEFAULT;

    }
}

