/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.DuplicateEmailsConfigDto;
import com.atlassian.migration.agent.dto.InvalidEmailsConfigDto;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.entity.UserBaseScanSortKey;
import com.atlassian.migration.agent.rest.ContainerTokenValidator;
import com.atlassian.migration.agent.rest.IncorrectEmailResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="incorrect-email")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IncorrectEmailResourceJakarta {
    private final IncorrectEmailResource originalResource;
    private final ContainerTokenValidator containerTokenValidator;

    @Inject
    public IncorrectEmailResourceJakarta(IncorrectEmailResource originalResource, ContainerTokenValidator containerTokenValidator) {
        this.originalResource = originalResource;
        this.containerTokenValidator = containerTokenValidator;
    }

    @GET
    @Path(value="/duplicated/config")
    public Response getDuplicateEmailConfig() {
        Pair<Boolean, DuplicateEmailsConfigDto> result = this.originalResource.getDuplicateEmailConfigDto();
        if (Boolean.TRUE.equals(result.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result.getRight()).build();
    }

    @POST
    @Path(value="/duplicated/config")
    public Response saveDuplicateEmailConfig(DuplicateEmailsConfigDto duplicateEmailsConfigDto) {
        if (!this.originalResource.saveDuplicateEmailConfigDto(duplicateEmailsConfigDto)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/invalid/config")
    public Response getInvalidEmailConfig() {
        Pair<Boolean, InvalidEmailsConfigDto> result = this.originalResource.getInvalidEmailConfigDto();
        if (Boolean.TRUE.equals(result.getLeft())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result.getRight()).build();
    }

    @POST
    @Path(value="/invalid/config")
    public Response saveInvalidEmailConfig(InvalidEmailsConfigDto invalidEmailsConfigDto) {
        if (!this.originalResource.saveInvalidEmailConfigDto(invalidEmailsConfigDto)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/invalid/{cloudId}")
    public Response getInvalidEmails(@PathParam(value="cloudId") String cloudId, @QueryParam(value="userBaseScanId") String userBaseScanId, @QueryParam(value="page") @DefaultValue(value="1") Integer page, @QueryParam(value="limit") @DefaultValue(value="10") Integer limit, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") SortOrder sortOrder) {
        return this.handleEmailsRequest(cloudId, userBaseScanId, page, limit, () -> this.originalResource.getInvalidEmailsDto(cloudId, userBaseScanId, page, limit, sortKey, sortOrder));
    }

    @GET
    @Path(value="/duplicated/{cloudId}")
    public Response getDuplicateEmails(@PathParam(value="cloudId") String cloudId, @QueryParam(value="userBaseScanId") String userBaseScanId, @QueryParam(value="page") @DefaultValue(value="1") Integer page, @QueryParam(value="limit") @DefaultValue(value="10") Integer limit, @QueryParam(value="sortKey") @DefaultValue(value="USERNAME") UserBaseScanSortKey sortKey, @QueryParam(value="sortOrder") @DefaultValue(value="ASC") SortOrder sortOrder) {
        return this.handleEmailsRequest(cloudId, userBaseScanId, page, limit, () -> this.originalResource.getDuplicateEmailsDto(cloudId, userBaseScanId, page, limit, sortKey, sortOrder));
    }

    private Response handleEmailsRequest(String cloudId, String userBaseScanId, Integer page, Integer limit, Supplier<Pair<Integer, Object>> dtoCall) {
        if (this.originalResource.isGlobalEmailFixesDisabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<Response> invalid = this.containerTokenValidator.validateContainerToken(cloudId).toJakartaResponseWhenNotValid();
        if (invalid.isPresent()) {
            return invalid.get();
        }
        try {
            this.validateParameters(userBaseScanId, page, limit);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Pair<Integer, Object> result = dtoCall.get();
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    private void validateParameters(String userBaseScanId, Integer page, Integer limit) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)userBaseScanId) ? 1 : 0) != 0, (Object)"userBaseScanId must be set");
        Preconditions.checkArgument((page > 0 ? 1 : 0) != 0, (Object)"page must be a positive integer");
        Preconditions.checkArgument((limit > 0 && limit <= 100 ? 1 : 0) != 0, (Object)"limit must be a number between 1 and 100");
    }
}

