/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.rest.FeatureFlagResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="featureflag")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FeatureFlagResourceJakarta {
    private final FeatureFlagResource originalResource;

    @Inject
    public FeatureFlagResourceJakarta(FeatureFlagResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/all")
    public Response getAllEnabledFeatureFlags() {
        Object result = this.originalResource.getAllEnabledFeatureFlagsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/all/{planId}")
    public Response getAllEnabledFeatureFlagsForPlan(@PathParam(value="planId") String planId) {
        Object result = this.originalResource.getAllEnabledFeatureFlagsForPlanDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/launchdarkly/all")
    public Response getAllLaunchDarklyFeatureFlags() {
        Object result = this.originalResource.getAllLaunchDarklyFeatureFlagsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/statsig/configs")
    public Response getDynamicConfig() {
        Object result = this.originalResource.getDynamicConfigDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/statsig/configs/{configName}")
    public Response getDynamicConfigByHash(@PathParam(value="configName") String configName) {
        Pair<Integer, Object> response = this.originalResource.getDynamicConfigByHashDto(configName);
        return Response.status((int)((Integer)response.getLeft())).entity(response.getRight()).build();
    }
}

