/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.rest.ContainerTokenValidator;
import com.atlassian.migration.agent.rest.EmailResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="email")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EmailResourceJakarta {
    private final EmailResource originalResource;
    private final ContainerTokenValidator containerTokenValidator;

    @Inject
    public EmailResourceJakarta(EmailResource originalResource, ContainerTokenValidator containerTokenValidator) {
        this.originalResource = originalResource;
        this.containerTokenValidator = containerTokenValidator;
    }

    @GET
    @Path(value="/domains")
    public Response getUserDomains() {
        return Response.ok((Object)this.originalResource.getUserDomainsDto()).build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/domains/{cloudId}")
    public Response getUserDomainsCSV(@PathParam(value="cloudId") String cloudId) {
        try {
            Pair<Integer, Object> result = this.originalResource.getUserDomainsCSVDto(cloudId);
            if (((Integer)result.getLeft()).intValue() != Response.Status.OK.getStatusCode()) {
                return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
            }
            Pair streamData = (Pair)result.getRight();
            return Response.ok(((ByteArrayOutputStream)streamData.getLeft())::writeTo).type("application/zip").header("Content-disposition", streamData.getRight()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to generate CSV zip file" + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/domain-rules")
    public Response getDomainRuleset() {
        return Response.ok((Object)this.originalResource.getDomainRulesetDto()).build();
    }

    @PUT
    @Path(value="/domain-rules")
    public Response updateDomainRule(UserDomainRuleDto rule) {
        this.originalResource.updateDomainRuleDto(rule);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/domain-rules/{domain}")
    public Response deleteDomainRule(@PathParam(value="domain") String domain) {
        this.originalResource.deleteDomainRuleDto(domain);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/rules")
    public Response deleteAllUserModifiedDomainRules() {
        this.originalResource.deleteAllUserModifiedDomainRulesDto();
        return Response.ok().build();
    }

    @POST
    @Path(value="/upload/domains")
    @Consumes(value={"application/octet-stream"})
    public Response uploadDomainsFile(InputStream fileInputStream) {
        Pair<Integer, String> result = this.originalResource.uploadDomainsFileDto(fileInputStream);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/blocked-domains/{cloudId}")
    public Response getBlockedDomains(@PathParam(value="cloudId") String cloudId) {
        Optional<Response> invalid = this.containerTokenValidator.validateContainerToken(cloudId).toJakartaResponseWhenNotValid();
        if (invalid.isPresent()) {
            return invalid.get();
        }
        return Response.ok((Object)this.originalResource.getBlockedDomainsDto(cloudId)).build();
    }
}

