/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.rest.CheckResource;
import com.atlassian.migration.agent.rest.dto.StreamResponseSpec;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="check")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CheckResourceJakarta {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private final CheckResource originalResource;

    @Inject
    public CheckResourceJakarta(CheckResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/{executionId}/status")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId) {
        Pair<Integer, Object> result = this.originalResource.getCheckExecutionStatusDto(executionId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/{executionId}/status/{checkType}")
    public Response getCheckExecutionStatus(@PathParam(value="executionId") String executionId, @PathParam(value="checkType") CheckType checkType) {
        Pair<Integer, Object> result = this.originalResource.getCheckExecutionStatusDto(executionId, checkType);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{executionId}")
    public void executeChecks(@PathParam(value="executionId") String executionId, @QueryParam(value="type") Set<CheckType> types, PlanDto planDto) {
        this.originalResource.executeChecksDto(executionId, types, planDto);
    }

    @POST
    @Path(value="/{executionId}/{checkType}")
    public void executeChecksForApp(@PathParam(value="executionId") String executionId, @PathParam(value="checkType") CheckType checkType, @QueryParam(value="appKey") @Nonnull String serverAppKey, PlanDto planDto) {
        this.originalResource.executeChecksForAppDto(executionId, checkType, serverAppKey, planDto);
    }

    @DELETE
    @Path(value="/{executionId}")
    public void deleteCheckExecutionResults(@PathParam(value="executionId") String executionId) {
        this.originalResource.deleteCheckExecutionResultsDto(executionId);
    }

    @GET
    @Path(value="/{executionId}/{type}/csv")
    @Produces(value={"text/csv"})
    public Response generateCSV(@PathParam(value="executionId") String executionId, @PathParam(value="type") CheckType type, @QueryParam(value="planName") String planName) {
        Pair<Integer, Object> result = this.originalResource.generateCSVDto(executionId, type, planName);
        int status = (Integer)result.getLeft();
        Object body = result.getRight();
        if (status != 200) {
            return Response.status((int)status).entity(body).build();
        }
        StreamResponseSpec spec = (StreamResponseSpec)body;
        StreamingOutput so = spec.writer::write;
        return Response.ok((Object)so).type(spec.contentType).header(CONTENT_DISPOSITION, (Object)spec.contentDisposition).build();
    }

    @GET
    @Path(value="/{executionId}/AppVendorCheck/{appKey}/{checkId}/csv")
    @Produces(value={"text/csv"})
    public Response generateAppVendorCheckCSV(@PathParam(value="executionId") String executionId, @PathParam(value="appKey") String appKey, @PathParam(value="checkId") String checkId) {
        Pair<Integer, Object> result = this.originalResource.generateAppVendorCheckCSVDto(executionId, appKey, checkId);
        int status = (Integer)result.getLeft();
        Object body = result.getRight();
        if (status != 200) {
            return Response.status((int)status).entity(body).build();
        }
        StreamResponseSpec spec = (StreamResponseSpec)body;
        StreamingOutput so = spec.writer::write;
        return Response.ok((Object)so).type(spec.contentType).header(CONTENT_DISPOSITION, (Object)spec.contentDisposition).build();
    }
}

