/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.AppInstallInfoRequest;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.dto.assessment.ConsentRequestDto;
import com.atlassian.migration.agent.dto.assessment.UpdateAllAppAssessmentInfoRequest;
import com.atlassian.migration.agent.rest.AppAssessmentResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@Path(value="app")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SystemAdminOnly
public class AppAssessmentResourceJakarta {
    private final AppAssessmentResource originalResource;

    @Inject
    public AppAssessmentResourceJakarta(AppAssessmentResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/")
    public Response getPluginInfo() {
        Object result = this.originalResource.getPluginInfoDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/stats")
    public Response getPluginStats() {
        Object result = this.originalResource.getPluginStatsDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/update")
    public Response updateAppAssessmentInfo(AppAssessmentUpdateRequest updateRequest) {
        this.originalResource.updateAppAssessmentInfoDto(updateRequest);
        return Response.ok().build();
    }

    @POST
    @Path(value="/update/all")
    public Response updateAllAppAssessmentInfo(UpdateAllAppAssessmentInfoRequest updateRequest) {
        this.originalResource.updateAllAppAssessmentInfoDto(updateRequest);
        return Response.ok().build();
    }

    @GET
    @Path(value="/usage")
    public Response getAppUsageStats() {
        Object result = this.originalResource.getAppUsageStatsDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/usage/clearAppUsageCache")
    public Response clearAppUsageCache() {
        Object result = this.originalResource.clearAppUsageCacheDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/siteinfo")
    public Response getAppInstallationInfo(AppInstallInfoRequest request) {
        Object result = this.originalResource.getAppInstallationInfoDto(request);
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/consent")
    public Response getConsentApps() {
        Object result = this.originalResource.getConsentAppsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/consent/allowAppMigrationsDataShare")
    public Response getSharedConsentForMarketplacePartners() {
        Object result = this.originalResource.getSharedConsentForMarketplacePartnersDto();
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/consent/allowAppMigrationsDataShare")
    public Response saveSharedConsentForMarketplacePartners(ConsentRequestDto consentRequestDto) {
        Object result = this.originalResource.saveSharedConsentForMarketplacePartnersDto(consentRequestDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/consent/update")
    public Response updateAppConsent(AppAssessmentUpdateRequest updateRequest) {
        Pair<Integer, Object> result = this.originalResource.updateAppConsentDto(updateRequest);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/list/neededInCloud")
    public Response getAppsNeededInCloud() {
        Object result = this.originalResource.getAppsNeededInCloudDto();
        return Response.ok((Object)result).build();
    }
}

