/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.AppInstallInfoRequest;
import com.atlassian.migration.agent.dto.assessment.AppAssessmentUpdateRequest;
import com.atlassian.migration.agent.dto.assessment.AppConsentDto;
import com.atlassian.migration.agent.dto.assessment.ConsentRequestDto;
import com.atlassian.migration.agent.dto.assessment.UpdateAllAppAssessmentInfoRequest;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.AppConsentService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Path(value="app")
@ReadOnlyAccessAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
public class AppAssessmentResource {
    private final AppAssessmentFacade appAssessmentService;
    private final AppConsentService appConsentService;
    private static final Logger log = ContextLoggerFactory.getLogger(AppAssessmentResource.class);

    @Inject
    public AppAssessmentResource(AppAssessmentFacade appAssessmentService, AppConsentService appConsentService) {
        this.appAssessmentService = appAssessmentService;
        this.appConsentService = appConsentService;
    }

    @GET
    @Path(value="/")
    public Response getPluginInfo() {
        Object result = this.getPluginInfoDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/stats")
    public Response getPluginStats() {
        Object result = this.getPluginStatsDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/update")
    public Response updateAppAssessmentInfo(AppAssessmentUpdateRequest updateRequest) {
        this.updateAppAssessmentInfoDto(updateRequest);
        return Response.ok().build();
    }

    @POST
    @Path(value="/update/all")
    public Response updateAllAppAssessmentInfo(UpdateAllAppAssessmentInfoRequest updateRequest) {
        this.updateAllAppAssessmentInfoDto(updateRequest);
        return Response.ok().build();
    }

    @GET
    @Path(value="/usage")
    public Response getAppUsageStats() {
        Object result = this.getAppUsageStatsDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/usage/clearAppUsageCache")
    public Response clearAppUsageCache() {
        Object result = this.clearAppUsageCacheDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/siteinfo")
    public Response getAppInstallationInfo(AppInstallInfoRequest request) {
        Object result = this.getAppInstallationInfoDto(request);
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/consent")
    public Response getConsentApps() {
        Object result = this.getConsentAppsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/consent/allowAppMigrationsDataShare")
    public Response getSharedConsentForMarketplacePartners() {
        Object result = this.getSharedConsentForMarketplacePartnersDto();
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/consent/allowAppMigrationsDataShare")
    public Response saveSharedConsentForMarketplacePartners(ConsentRequestDto consentRequestDto) {
        Object result = this.saveSharedConsentForMarketplacePartnersDto(consentRequestDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/consent/update")
    public Response updateAppConsent(AppAssessmentUpdateRequest updateRequest) {
        Pair<Integer, Object> result = this.updateAppConsentDto(updateRequest);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/list/neededInCloud")
    public Response getAppsNeededInCloud() {
        Object result = this.getAppsNeededInCloudDto();
        return Response.ok((Object)result).build();
    }

    public Object getPluginInfoDto() {
        return this.appAssessmentService.getPlugins();
    }

    public Object getPluginStatsDto() {
        return this.appAssessmentService.getPluginStats();
    }

    public void updateAppAssessmentInfoDto(AppAssessmentUpdateRequest updateRequest) {
        this.appAssessmentService.updateAppAssessmentInfo(updateRequest.getAppKey(), updateRequest);
    }

    public void updateAllAppAssessmentInfoDto(UpdateAllAppAssessmentInfoRequest updateRequest) {
        this.appAssessmentService.updateAllAppAssessmentInfo(updateRequest);
    }

    public Object getAppUsageStatsDto() {
        return this.appAssessmentService.getAppUsageStats();
    }

    public Object clearAppUsageCacheDto() {
        return this.appAssessmentService.clearAppUsageCache();
    }

    public Object getAppInstallationInfoDto(AppInstallInfoRequest request) {
        return this.appAssessmentService.getCloudAppsInfo(request);
    }

    public Object getConsentAppsDto() {
        return this.appAssessmentService.getAllConsentApps();
    }

    public Object getSharedConsentForMarketplacePartnersDto() {
        return this.appConsentService.getSharedConsentForMarketplacePartners();
    }

    public Object saveSharedConsentForMarketplacePartnersDto(ConsentRequestDto consentRequestDto) {
        return this.appConsentService.saveSharedConsentForMarketplacePartners(consentRequestDto.getDisplayedText());
    }

    public Pair<Integer, Object> updateAppConsentDto(AppAssessmentUpdateRequest updateRequest) {
        Optional<AppConsentDto> maybeAppConsentDto = this.appAssessmentService.updateAppConsent(updateRequest.getAppKey(), updateRequest);
        if (!maybeAppConsentDto.isPresent()) {
            log.warn("App key not found {}", (Object)updateRequest.getAppKey());
            return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)new MessageDto(String.format("App key not found = %s", updateRequest.getAppKey())));
        }
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)maybeAppConsentDto.get());
    }

    public Object getAppsNeededInCloudDto() {
        return this.appAssessmentService.getAppsNeededInCloud();
    }
}

