/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTunnelLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ProxyTunnelLoggingInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        log.debug("=== HTTP Request Debug ===");
        log.debug("URL: {}", (Object)request.url());
        log.debug("Method: {}", (Object)request.method());
        log.debug("Headers: {}", (Object)request.headers());
        if (request.url().host().contains("atlassian.com")) {
            log.debug("Target: Atlassian service");
            log.debug("Scheme: {}", (Object)request.url().scheme());
            log.debug("Port: {}", (Object)request.url().port());
        }
        long startTime = System.currentTimeMillis();
        try {
            String proxyAuth;
            log.debug("Starting request execution...");
            Response response = chain.proceed(request);
            long duration = System.currentTimeMillis() - startTime;
            log.debug("=== HTTP Response Debug ===");
            log.debug("Response code: {}", (Object)response.code());
            log.debug("Response message: {}", (Object)response.message());
            log.debug("Duration: {} ms", (Object)duration);
            log.debug("Headers: {}", (Object)response.headers());
            String via = response.header("Via");
            if (via != null) {
                log.debug("Proxy via header: {}", (Object)via);
            }
            if ((proxyAuth = response.header("Proxy-Authenticate")) != null) {
                log.debug("Proxy authentication required: {}", (Object)proxyAuth);
            }
            return response;
        }
        catch (IOException e) {
            long duration = System.currentTimeMillis() - startTime;
            log.error("=== HTTP Request Failed ===");
            log.error("Duration before failure: {} ms", (Object)duration);
            log.error("Exception type: {}", (Object)e.getClass().getSimpleName());
            log.error("Exception message: {}", (Object)e.getMessage());
            if (e.getMessage() != null) {
                if (e.getMessage().contains("timeout")) {
                    log.error("TIMEOUT DETECTED: This is likely the proxy tunnel creation timeout");
                    log.error("Request URL: {}", (Object)request.url());
                    log.error("Timeout occurred after {} ms", (Object)duration);
                }
                if (e.getMessage().contains("connect")) {
                    log.error("CONNECTION ERROR: Proxy connection issue");
                }
                if (e.getMessage().contains("tunnel")) {
                    log.error("TUNNEL ERROR: HTTP CONNECT tunnel creation failed");
                }
            }
            if (e.getClass().getSimpleName().contains("Timeout")) {
                log.error("Timeout stack trace:", (Throwable)e);
            }
            throw e;
        }
    }
}

