/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.newexport;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.newexport.CSVExportTaskContext;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.newexport.DescriptorBuilder;
import com.atlassian.migration.agent.newexport.Queries;
import com.atlassian.migration.agent.newexport.Query;
import com.atlassian.migration.agent.newexport.TriConsumer;
import com.atlassian.migration.agent.newexport.exception.FileDeletionException;
import com.atlassian.migration.agent.newexport.processor.ColumnTransformer;
import com.atlassian.migration.agent.newexport.processor.CsvSerializingProcessor;
import com.atlassian.migration.agent.newexport.processor.RowProcessor;
import com.atlassian.migration.agent.newexport.processor.UserKeyColumnExtractor;
import com.atlassian.migration.agent.newexport.processor.UserWithEmailSerializingProcessor;
import com.atlassian.migration.agent.newexport.store.JdbcConfluenceStore;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.ExportTransformerService;
import com.atlassian.migration.agent.service.UserMappingsManager;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.user.UserMappingsFileManager;
import com.atlassian.migration.agent.service.util.CsvWriterFacade;
import com.atlassian.migration.agent.service.util.PreferenceType;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RapidExporter<T extends CSVExportTaskContext> {
    private static final Logger log = LoggerFactory.getLogger(RapidExporter.class);
    public static final int BATCH_SIZE_FOR_IN_OPERATOR = 1000;
    private static final int MAX_RETRIES = 6;
    private static final int MIN_RETRIES = 0;
    private static final String BODYCONTENT = "bodycontent";
    private static final String EXPORT_COUNTS_FILE_SUFFIX = "_export_counts.csv.gz";
    private static final Supplier<Instant> DEFAULT_INSTANT_SUPPLER = Instant::now;
    protected final UserMappingsFileManager userMappingsFileManager;
    protected final JdbcConfluenceStore confluenceStore;
    protected final DescriptorBuilder descriptorBuilder;
    protected final Supplier<Instant> instantSupplier;
    protected final AnalyticsEventService analyticsEventService;
    protected final AnalyticsEventBuilder analyticsEventBuilder;
    protected final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    protected final DbType dbType;
    protected final ExportTransformerService exportTransformerService;

    protected RapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ExportTransformerService exportTransformerService) {
        this(confluenceStore, descriptorBuilder, migrationAgentConfiguration, userMappingsFileManager, analyticsEventService, analyticsEventBuilder, DEFAULT_INSTANT_SUPPLER, migrationDarkFeaturesManager, exportTransformerService);
    }

    @VisibleForTesting
    protected RapidExporter(JdbcConfluenceStore confluenceStore, DescriptorBuilder descriptorBuilder, MigrationAgentConfiguration migrationAgentConfiguration, UserMappingsFileManager userMappingsFileManager, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, Supplier<Instant> instantSupplier, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ExportTransformerService exportTransformerService) {
        this.confluenceStore = confluenceStore;
        this.descriptorBuilder = descriptorBuilder;
        this.userMappingsFileManager = userMappingsFileManager;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.instantSupplier = instantSupplier;
        this.dbType = migrationAgentConfiguration.getDBType();
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.exportTransformerService = exportTransformerService;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    protected void exportFileCount(String exportDir, T taskConfig, String prefix) {
        String fileName = prefix + EXPORT_COUNTS_FILE_SUFFIX;
        String filePath = exportDir + fileName;
        String[] header = new String[]{"entityName", "exportCount"};
        try (OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(filePath);){
            CsvWriterFacade csvWriterFacade = new CsvWriterFacade(outputStreamWriter, PreferenceType.DEFAULT);
            csvWriterFacade.write(header, true);
            for (Map.Entry<String, Long> entry : ((CSVExportTaskContext)taskConfig).getFileRowCount().entrySet()) {
                String[] row = new String[]{entry.getKey(), String.valueOf(entry.getValue())};
                csvWriterFacade.write(row, true);
            }
            csvWriterFacade.flush();
            log.info("Export count written to CSV file: {} successfully!", (Object)filePath);
        }
        catch (Exception ex) {
            log.error("Error while serializing export count. Reason: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    protected <U> void runQueries(Query[] queries, U queryRunner, String exportDir, T taskConfig) {
        for (Query query : queries) {
            long start = this.instantSupplier.get().toEpochMilli();
            String fileName = query.exportName + ".csv.gz";
            String filePath = exportDir + fileName;
            if (query.exportName.equals(BODYCONTENT)) {
                this.runQuery(query, queryRunner, taskConfig, start, filePath, 6);
                continue;
            }
            this.runQuery(query, queryRunner, taskConfig, start, filePath, 0);
        }
    }

    protected <U> void runQuery(Query query, U queryRunner, T taskConfig, long start, String filePath, int maxRetries) {
        AtomicInteger retryCounter = new AtomicInteger(0);
        RetryPolicy retryPolicy = (RetryPolicy)RetryPolicyBuilder.spaceExportRetryPolicy(maxRetries).build().onRetry(e -> {
            int currentRetry = retryCounter.incrementAndGet();
            log.error("Retry number " + currentRetry + ". Failed to execute export for query" + query.sql, e.getLastFailure());
            try {
                Files.deleteIfExists(Paths.get(filePath, new String[0]));
            }
            catch (IOException ioException) {
                throw new FileDeletionException("Unable to delete the file for a failed export", ioException);
            }
        }).onFailure(e -> {
            this.reportExportTablePerformance(taskConfig, false, query.exportName, query.sql, this.dbType.name(), this.instantSupplier.get().toEpochMilli() - start, -1L, -1L, -1L);
            throw new MigrationExportException("Failed to execute export for query", e.getFailure());
        });
        Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> {
            try (OutputStreamWriter outputStreamWriter = this.createOutputStreamWriter(filePath);){
                List<ColumnTransformer> columnTransformers = Collections.emptyList();
                if (query.tableName.equalsIgnoreCase(BODYCONTENT) && this.migrationDarkFeaturesManager.isTransformersForContentInBodyContent()) {
                    columnTransformers = this.exportTransformerService.getTransformers(taskConfig.getPlanId());
                    log.info("Applying transformers: {}", columnTransformers);
                }
                CsvSerializingProcessor csvProcessor = new CsvSerializingProcessor(outputStreamWriter, this.instantSupplier, this.migrationDarkFeaturesManager, columnTransformers);
                this.queryAndProcess(query, queryRunner, csvProcessor, retryCounter.get());
                long totalTime = this.instantSupplier.get().toEpochMilli() - start;
                long timeToFirstRecord = csvProcessor.getTimeOfFirstRecord() > 0L ? csvProcessor.getTimeOfFirstRecord() - start : totalTime;
                long rowCount = csvProcessor.getRowCount();
                taskConfig.increaseTotalRowCount(rowCount);
                taskConfig.increaseTotalCharactersExported(csvProcessor.getTotalContentCharacters());
                taskConfig.addFileRowCount(query.exportName, rowCount);
                this.reportExportTablePerformance(taskConfig, true, query.exportName, query.sql, this.dbType.name(), totalTime, timeToFirstRecord, rowCount, csvProcessor.getTotalContentCharacters());
                this.logResults(query.tableName, taskConfig, totalTime);
            }
            catch (UncheckedInterruptedException e) {
                throw new UncheckedInterruptedException(e);
            }
        });
    }

    protected <U> void queryAndProcess(Query query, U queryRunner, CsvSerializingProcessor csvProcessor, int retry) {
        log.debug("Running space export query {}", (Object)query.sql);
        long start = this.instantSupplier.get().toEpochMilli();
        if (queryRunner instanceof BiConsumer) {
            ((BiConsumer)queryRunner).accept(query, csvProcessor);
        } else if (queryRunner instanceof TriConsumer) {
            ((TriConsumer)queryRunner).accept(query, csvProcessor, retry);
        }
        long end = this.instantSupplier.get().toEpochMilli();
        log.debug("Space export query {} completed in {} ms", (Object)query.sql, (Object)(end - start));
    }

    protected OutputStreamWriter createOutputStreamWriter(String filePath) throws IOException {
        boolean existed = Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
        if (!existed) {
            Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        }
        FileOutputStream outputStream = new FileOutputStream(filePath, true);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        return new OutputStreamWriter((OutputStream)gzipOutputStream, StandardCharsets.UTF_8);
    }

    protected BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams, Set<String> extractedUserKeys) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, new UserKeyColumnExtractor((RowProcessor)processor, extractedUserKeys, query.userkeyColums));
    }

    protected BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams, BiFunction<Query, RowProcessor, RowProcessor> rowProcessorFactory) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, (RowProcessor)rowProcessorFactory.apply((Query)query, (RowProcessor)processor));
    }

    protected TriConsumer<Query, RowProcessor, Integer> createQueryRunnerForBodyContent(Map<String, ?> queryParams, BiFunction<Query, RowProcessor, RowProcessor> rowProcessorFactory) {
        return (query, processor, retry) -> this.confluenceStore.queryAndProcessWithRetries((Query)query, queryParams, (RowProcessor)rowProcessorFactory.apply((Query)query, (RowProcessor)processor), (Integer)retry);
    }

    protected BiConsumer<Query, RowProcessor> createQueryRunner(Map<String, ?> queryParams) {
        return (query, processor) -> this.confluenceStore.queryAndProcess((Query)query, queryParams, (RowProcessor)processor);
    }

    protected void exportUserMappings(String exportDir, Set<String> discoveredUserKeys, T taskConfig, UserMappingsManager userMappingsManager) {
        Query userMappingQuery = new Query(this.getUserMappingQueryString(discoveredUserKeys), "user_mapping", "user_mapping");
        this.runQueries(new Query[]{userMappingQuery}, this.createQueryRunner(Collections.emptyMap(), (Query query, RowProcessor processor) -> new UserWithEmailSerializingProcessor((RowProcessor)processor, userMappingsManager)), exportDir, taskConfig);
    }

    @VisibleForTesting
    String getUserMappingQueryString(Set<String> discoveredUserKeys) {
        discoveredUserKeys.removeIf(String::isEmpty);
        List nonMatchingKeys = discoveredUserKeys.stream().filter(e -> !e.matches("[a-zA-Z\\d. :-]*")).collect(Collectors.toList());
        if (!nonMatchingKeys.isEmpty()) {
            log.warn("Invalid characters in userKeys: {}. Only alphanumeric characters are allowed.", nonMatchingKeys);
        }
        ArrayList userKeyBatches = Lists.newArrayList((Iterable)Iterables.partition(discoveredUserKeys, (int)1000));
        ArrayList clauses = Lists.newArrayList((Object[])new String[]{"1=0"});
        for (List userKeyBatch : userKeyBatches) {
            StringBuilder sb = new StringBuilder();
            for (String key : userKeyBatch) {
                sb.append(String.format("'%s',", key));
            }
            sb.deleteCharAt(sb.length() - 1);
            clauses.add(String.format("user_key in (%s)", sb));
        }
        return String.format(Queries.userMappingsQueryString(this.dbType), String.join((CharSequence)" or ", clauses));
    }

    protected abstract void logResults(String var1, T var2, long var3);

    public abstract String export(T var1) throws AccessDeniedException;

    public abstract void reportExportTablePerformance(T var1, boolean var2, String var3, String var4, String var5, long var6, long var8, long var10, long var12);
}

