/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.analytics;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.analytics.McsRemotePrometheusSnapshotSink;
import com.atlassian.migration.agent.analytics.PrometheusMetricEvent;
import com.atlassian.migration.agent.analytics.PrometheusMetrics;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.app.analytics.prometheus.PrometheusMetricManagerConfig;
import com.atlassian.migration.app.analytics.prometheus.PrometheusMetricsManager;
import com.atlassian.migration.app.analytics.prometheus.Sleeper;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import jakarta.annotation.PreDestroy;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricExportController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricExportController.class);
    private static final Counter prometheusPollerCounter = PrometheusMetrics.registerSilently(((Counter.Builder)Counter.builder().name("ccma.prometheus_exporter").labelNames(new String[]{"status"})).build());
    private static final Counter successExportCounter = PrometheusMetrics.registerSilently(((Counter.Builder)Counter.builder().name("ccma.prometheus_exporter.events.success").labelNames(new String[]{"migration_id"})).build());
    private static final Counter failedExportCounter = PrometheusMetrics.registerSilently(((Counter.Builder)Counter.builder().name("ccma.prometheus_exporter.events.failed").labelNames(new String[]{"migration_id"})).build());
    private final EventPublisher eventPublisher;
    private final PrometheusMetricsManager prometheusMetricManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public PrometheusMetricExportController(EventPublisher eventPublisher, AnalyticsConfigService analyticsConfigService, Clock systemClock, MigrationCatalogueStorageService migrationCatalogueStorageService, PlanStore planStore, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this(eventPublisher, new PrometheusMetricLivenessChecker(analyticsConfigService), systemClock, migrationCatalogueStorageService, planStore, migrationAgentConfiguration, migrationDarkFeaturesManager, new PrometheusSleeper());
    }

    @VisibleForTesting
    PrometheusMetricExportController(EventPublisher eventPublisher, Supplier<Boolean> livenessChecker, Clock systemClock, MigrationCatalogueStorageService migrationCatalogueStorageService, PlanStore planStore, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager, Sleeper sleeper) {
        this.eventPublisher = eventPublisher;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        PrometheusMetricManagerConfig config = new PrometheusMetricManagerConfig(migrationDarkFeaturesManager.getPrometheusPollerExportInterval().longValue(), migrationDarkFeaturesManager.getPrometheusPollerPollInterval().longValue(), migrationAgentConfiguration.getPrometheusPollerTimeoutMillis());
        McsRemoteSinkProvider mcsRemoteSinkProvider = new McsRemoteSinkProvider(migrationCatalogueStorageService, planStore);
        this.prometheusMetricManager = new PrometheusMetricsManager(mcsRemoteSinkProvider::provide, PrometheusRegistry.defaultRegistry, Executors.newCachedThreadPool(), config, systemClock, sleeper, livenessChecker::get, prometheusPollerCounter, successExportCounter, failedExportCounter);
        log.info("PrometheusMetricExportController initialized with config: {}", (Object)config);
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void start(String migrationId) {
        if (!this.migrationDarkFeaturesManager.isPrometheusPollingEnabled()) {
            log.info("PrometheusMetricExportController disabled for migration: {}", (Object)migrationId);
            return;
        }
        log.info("PrometheusMetricExportController starting poller for migration: {}", (Object)migrationId);
        this.prometheusMetricManager.start(migrationId);
        this.eventPublisher.publish((Object)new PrometheusMetricEvent(this, migrationId, PrometheusMetricEvent.PrometheusMetricEventState.START));
    }

    public void stop(String migrationId) {
        log.info("PrometheusMetricExportController stopping pollers for migration: {}", (Object)migrationId);
        this.prometheusMetricManager.stop(migrationId);
        this.eventPublisher.publish((Object)new PrometheusMetricEvent(this, migrationId, PrometheusMetricEvent.PrometheusMetricEventState.STOP));
    }

    @EventListener
    public void onPrometheusMetricEvent(PrometheusMetricEvent event) {
        log.info("PrometheusMetricExportController cluster event {} received for migration: {}", (Object)event.getState(), (Object)event.getMigrationId());
        if (event.getState() == PrometheusMetricEvent.PrometheusMetricEventState.START) {
            if (!this.migrationDarkFeaturesManager.isPrometheusPollingEnabled()) {
                log.info("PrometheusMetricExportController disabled for migration: {}", (Object)event.getMigrationId());
                return;
            }
            this.prometheusMetricManager.start(event.getMigrationId());
        } else if (event.getState() == PrometheusMetricEvent.PrometheusMetricEventState.STOP) {
            this.prometheusMetricManager.stop(event.getMigrationId());
        }
    }

    static {
        ((CounterDataPoint)prometheusPollerCounter.labelValues(new String[]{"start"})).inc(0L);
        ((CounterDataPoint)prometheusPollerCounter.labelValues(new String[]{"stop"})).inc(0L);
        ((CounterDataPoint)successExportCounter.labelValues(new String[]{""})).inc(0L);
        ((CounterDataPoint)failedExportCounter.labelValues(new String[]{""})).inc(0L);
    }

    @VisibleForTesting
    static class PrometheusMetricLivenessChecker
    implements Supplier<Boolean> {
        private final AnalyticsConfigService analyticsConfigService;

        private PrometheusMetricLivenessChecker(AnalyticsConfigService analyticsConfigService) {
            this.analyticsConfigService = analyticsConfigService;
        }

        public boolean alive() {
            return this.analyticsConfigService.canCollectAnalytics();
        }

        @Override
        public Boolean get() {
            return this.alive();
        }
    }

    public static class PrometheusSleeper
    implements Sleeper {
        public void sleep(long l) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class McsRemoteSinkProvider {
        private final MigrationCatalogueStorageService migrationCatalogueStorageService;
        private final PlanStore planStore;

        private McsRemoteSinkProvider(MigrationCatalogueStorageService migrationCatalogueStorageService, PlanStore planStore) {
            this.migrationCatalogueStorageService = migrationCatalogueStorageService;
            this.planStore = planStore;
        }

        public McsRemotePrometheusSnapshotSink provide(String migrationId) {
            String cloudId = this.planStore.getPlanForMigrationId(migrationId).getCloudSite().getCloudId();
            return new McsRemotePrometheusSnapshotSink(this.migrationCatalogueStorageService, migrationId, cloudId);
        }
    }
}

