/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.space;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.export.MigrationExportException;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.SpaceRapidExporter;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.ClusterLimits;
import com.atlassian.migration.agent.service.ExportDirManager;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.ServiceInitializeException;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.ErrorEvent;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.UsersMappingService;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportResult;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.file.AccessDeniedException;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class SpaceExportExecutor
extends ExportExecutor
implements SpaceBoundStepExecutor {
    @VisibleForTesting
    static final StepType EXPORT_STEP_TYPE = StepType.CONFLUENCE_EXPORT;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportExecutor.class);
    private static final String SPACE_KEY = "spaceKey";
    private static final String PLAN_ID = "planId";
    private static final String MIGRATION_ID = "migrationId";
    private static final String CLOUD_ID = "cloudId";
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private final SpaceManager spaceManager;
    private final SpaceRapidExporter rapidExporter;
    private final Supplier<String> fileIdGenerator;
    private final ClusterLimits clusterLimits;
    private final UsersMappingService usersMappingService;
    private final ProgressTracker progressTracker;
    private final PlanStore planStore;
    private final ShadowMigrationExecutor shadowMigrationExecutor;
    private final String FAILURE_COMPLETION_STATUS_MESSAGE = "Sending failure completion status for space export for spaceKey {}";

    public SpaceExportExecutor(ExportDirManager exportDirManager, BootstrapManager bootstrapManager, StepStore stepStore, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceRapidExporter rapidExporter, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration, ClusterLimits clusterLimits, UsersMappingService usersMappingService, ProgressTracker progressTracker, PlanStore planStore, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(exportDirManager, bootstrapManager, stepStore, ptx, analyticsEventService, analyticsEventBuilder, migrationDarkFeaturesManager, migrationAgentConfiguration, progressTracker);
        this.spaceManager = spaceManager;
        this.rapidExporter = rapidExporter;
        this.fileIdGenerator = () -> UUID.randomUUID().toString();
        this.clusterLimits = clusterLimits;
        this.usersMappingService = usersMappingService;
        this.progressTracker = progressTracker;
        this.planStore = planStore;
        this.shadowMigrationExecutor = shadowMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @VisibleForTesting
    SpaceExportExecutor(ExportDirManager exportDirManager, BootstrapManager bootstrapManager, StepStore stepStore, PluginTransactionTemplate ptx, Supplier<Instant> instantSupplier, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceRapidExporter rapidExporter, SpaceManager spaceManager, MigrationAgentConfiguration migrationAgentConfiguration, Clock clock, Supplier<String> fileIdGenerator, ClusterLimits clusterLimits, UsersMappingService usersMappingService, ProgressTracker progressTracker, PlanStore planStore, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(exportDirManager, bootstrapManager, stepStore, ptx, instantSupplier, analyticsEventService, analyticsEventBuilder, migrationDarkFeaturesManager, migrationAgentConfiguration, clock, progressTracker);
        this.spaceManager = spaceManager;
        this.rapidExporter = rapidExporter;
        this.fileIdGenerator = fileIdGenerator;
        this.clusterLimits = clusterLimits;
        this.usersMappingService = usersMappingService;
        this.progressTracker = progressTracker;
        this.planStore = planStore;
        this.shadowMigrationExecutor = shadowMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @VisibleForTesting
    StepResult doExport(ConfExportStepConfig exportStepConfig, String stepId, Optional<PrcTask<SpaceExportTransferTask>> prcTask) {
        if (prcTask.isPresent() && this.shadowMigrationExecutor.isShadowMigration(this.stepStore.getStep(stepId))) {
            return StepResult.succeeded("Shadow Migration - Data export successful", "shadowFileId");
        }
        long startTime = ((Instant)this.instantSupplier.get()).toEpochMilli();
        long freeHeapSizeAtStart = Runtime.getRuntime().freeMemory();
        Step step = this.stepStore.getStep(stepId);
        String planId = step.getPlan().getId();
        String migrationId = step.getPlan().getMigrationId();
        String migrationScopeId = step.getPlan().getMigrationScopeId();
        String cloudId = exportStepConfig.getCloudId();
        String spaceKey = exportStepConfig.getSpaceKey();
        String fileId = this.fileIdGenerator.get();
        MigrationProtocol migrationProtocol = step.getPlan().getMigrationProtocol();
        ExportType exportType = ExportType.RAPID;
        this.usersMappingService.saveUserMappingsToFile(cloudId, planId, migrationScopeId);
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(SPACE_KEY, spaceKey, PLAN_ID, planId, MIGRATION_ID, migrationId, CLOUD_ID, cloudId);
        this.v4Logger.logInfo(log, logContext, String.format("Initiating space export, exportType: %s fileId: %s", new Object[]{exportType, fileId}));
        prcTask.ifPresent(spaceExportTransferTaskPrcTask -> this.progressTracker.progress(step.getId(), 0, StepType.CONFLUENCE_EXPORT.getDisplayName(), StepType.CONFLUENCE_EXPORT.getDetailedStatus(), Collections.emptyMap(), Optional.of(spaceExportTransferTaskPrcTask)));
        if (StringUtils.isBlank((String)spaceKey)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_SPACE_KEY.getMessage(), spaceKey, migrationProtocol);
            this.v4Logger.logError(log, logContext, "Sending failure completion status for space export for spaceKey {}");
            StepResult result = StepResult.failed("Attempted to perform an export, but no space key was found.");
            prcTask.ifPresent(spaceExportTransferTaskPrcTask -> this.progressTracker.sendV4SpaceFailureStatus((PrcTask)spaceExportTransferTaskPrcTask, result.getMessage()));
            return result;
        }
        if (StringUtils.isBlank((String)cloudId)) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_NO_CLOUD_ID.getMessage(), spaceKey, migrationProtocol);
            this.v4Logger.logError(log, logContext, "Sending failure completion status for space export for spaceKey {}");
            StepResult result = StepResult.failed("Attempted to perform an export, but no cloud ID was found.");
            prcTask.ifPresent(spaceExportTransferTaskPrcTask -> this.progressTracker.sendV4SpaceFailureStatus((PrcTask)spaceExportTransferTaskPrcTask, result.getMessage()));
            return result;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST, exportType, migrationId, cloudId, MigrationErrorCode.SPACE_EXPORT_SPACE_DOES_NOT_EXIST.getMessage(), spaceKey, migrationProtocol);
            this.v4Logger.logError(log, logContext, "Sending failure completion status for space export for spaceKey {}");
            StepResult result = StepResult.failed(String.format("Attempted to perform an export, but no space with the key '%s' was found.", spaceKey));
            prcTask.ifPresent(spaceExportTransferTaskPrcTask -> this.progressTracker.sendV4SpaceFailureStatus((PrcTask)spaceExportTransferTaskPrcTask, result.getMessage()));
            return result;
        }
        this.analyticsEventService.saveAnalyticsEventAsync(() -> this.analyticsEventBuilder.buildSpaceExportStartEvent(step, exportType, space.getId(), startTime));
        return this.exportProcessor(step, exportStepConfig, exportType, startTime, freeHeapSizeAtStart, fileId, prcTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepResult exportProcessor(Step step, ConfExportStepConfig exportStepConfig, ExportType exportType, long startTime, long freeHeapSizeAtStart, String fileId, Optional<PrcTask<SpaceExportTransferTask>> prcTask) {
        String migrationId = step.getPlan().getMigrationId();
        String spaceKey = exportStepConfig.getSpaceKey();
        String cloudId = exportStepConfig.getCloudId();
        String planId = step.getPlan().getId();
        String taskId = step.getTask().getId();
        Plan plan = this.ptx.read(() -> this.planStore.getPlanWithTasksEagerly(step.getPlan().getId()));
        boolean containsUserMigrationTask = this.containsTask(plan, MigrateUsersTask.class);
        boolean success = false;
        MigrationProtocol migrationProtocol = step.getPlan().getMigrationProtocol();
        SpaceExportResult exportResult = null;
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).stepType(step.getType()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(SPACE_KEY, spaceKey, PLAN_ID, planId, MIGRATION_ID, migrationId);
        try {
            exportResult = this.exportedFileGenerator(spaceKey, planId, taskId, containsUserMigrationTask, cloudId, plan.isExcludeContentInTrash());
            String exportedFile = exportResult.getExportFile();
            if (!this.migrationDarkFeaturesManager.isExportOnlyEnabled()) {
                this.v4Logger.logInfo(log, logContext, String.format("Moving csv files in %s to %s inside migration exports directory.", exportedFile, fileId));
                this.exportDirManager.moveCompressedFilesToSharedHome(exportedFile, fileId);
            }
            success = true;
            this.v4Logger.logInfo(log, logContext, "Space export successful.");
            StepResult stepResult = StepResult.succeeded("Data export successful", fileId);
            return stepResult;
        }
        catch (UncheckedInterruptedException ex) {
            this.v4Logger.logWarn(log, logContext, "Space export was interrupted", ex);
            StepResult stepResult = StepResult.stopped();
            return stepResult;
        }
        catch (MigrationExportException ex) {
            this.v4Logger.logError(log, logContext, "Space export file generation failed", ex);
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED, exportType, migrationId, cloudId, ex.getMessage(), spaceKey, migrationProtocol);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_FILE_EXPORT_FAILED, prcTask);
            return stepResult;
        }
        catch (AccessDeniedException ex) {
            this.v4Logger.logError(log, logContext, "Space export failed due to permission issues", ex);
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.MISSING_WRITE_TO_DIRECTORY_PERMISSIONS, exportType, migrationId, cloudId, ex.getMessage(), spaceKey, migrationProtocol);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.MISSING_WRITE_TO_DIRECTORY_PERMISSIONS, prcTask);
            return stepResult;
        }
        catch (ServiceInitializeException ex) {
            this.v4Logger.logError(log, logContext, "Space export failed during directory creation", ex);
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED, exportType, migrationId, cloudId, ex.getMessage(), spaceKey, migrationProtocol);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_DIRECTORY_CREATION_FAILED, prcTask);
            return stepResult;
        }
        catch (Exception ex) {
            this.v4Logger.logError(log, logContext, "Space export failed with unexpected error", ex);
            success = this.checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR, exportType, migrationId, cloudId, ex.getMessage(), spaceKey, migrationProtocol);
            StepResult stepResult = this.failedStepResult(ex, migrationId, exportStepConfig, MigrationErrorCode.SPACE_EXPORT_EXECUTION_ERROR, prcTask);
            return stepResult;
        }
        finally {
            ImmutableMap additionalAttributes = ImmutableMap.of((Object)"stepSuccessful", (Object)String.valueOf(success), (Object)"exportType", (Object)exportType.name());
            EventDto completedStepEvent = this.analyticsEventBuilder.buildCompletedStepAnalyticsEvent(step, () -> SpaceExportExecutor.lambda$exportProcessor$7((Map)additionalAttributes));
            EventDto heapSizeAnalyticsEvent = this.analyticsEventBuilder.buildStepLevelHeapSizeAnalyticsEvent(step, freeHeapSizeAtStart, this.clusterLimits.getClusterConcurrencyLimit(StepType.CONFLUENCE_EXPORT, plan), this.clusterLimits.getConcurrencyPerNodeLimit(StepType.CONFLUENCE_EXPORT, plan));
            EventDto timerEvent = this.analyticsEventBuilder.buildSpaceExportStepTimerEvent(success, ((Instant)this.instantSupplier.get()).toEpochMilli() - startTime, spaceKey, step, exportType, this.createAdditionalAttributes(Optional.ofNullable(exportResult)));
            this.analyticsEventService.saveAnalyticsEvents(() -> ImmutableList.of((Object)completedStepEvent, (Object)heapSizeAnalyticsEvent, (Object)timerEvent));
        }
    }

    private Map<String, Object> createAdditionalAttributes(Optional<SpaceExportResult> maybeExportResult) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("dbType", this.migrationAgentConfiguration.getDBType().name());
        maybeExportResult.ifPresent(exportResult -> attributes.putAll(exportResult.getAttributes()));
        return attributes;
    }

    private SpaceExportResult exportedFileGenerator(String spaceKey, String planId, String taskId, boolean containsUserMigrationTask, String cloudId, boolean excludeContentInTrash) throws AccessDeniedException {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.exportSpaceContentToFile(space.getId(), spaceKey, planId, taskId, containsUserMigrationTask, cloudId, excludeContentInTrash);
    }

    private SpaceExportResult exportSpaceContentToFile(long spaceId, String spaceKey, String planId, String taskId, boolean containsUserMigrationTask, String cloudId, boolean excludeContentInTrash) throws AccessDeniedException {
        SpaceCSVExportTaskContext config = new SpaceCSVExportTaskContext(spaceId, spaceKey, cloudId, planId, taskId, this.tempDirFilePath.getAbsolutePath(), containsUserMigrationTask, excludeContentInTrash);
        String exportedFile = this.rapidExporter.export(config);
        this.createExportDirectoryIfNotExists();
        return new SpaceExportResult(exportedFile, (Map<String, Object>)ImmutableMap.of((Object)"totalRowCount", (Object)config.getTotalRowCount(), (Object)"totalCharactersExported", (Object)config.getTotalCharactersExported()));
    }

    private boolean checkIfGoodEventAndSaveAnalyticEventsWhenStepFails(MigrationErrorCode migrationErrorCode, ExportType exportType, String migrationId, String cloudId, String message, String spaceKey, MigrationProtocol migrationProtocol) {
        boolean isSloGoodEvent = migrationErrorCode.shouldBeTreatedAsGoodEventInReliabilitySlo();
        ErrorEvent errorEvent = new ErrorEvent.ErrorEventBuilder(migrationErrorCode, migrationErrorCode.getContainerType(), migrationId, EXPORT_STEP_TYPE).setCloudid(cloudId).setReason(message).setSpaceKey(spaceKey).build();
        ImmutableList events = ImmutableList.of((Object)this.analyticsEventBuilder.buildFailedSpaceMigration(EXPORT_STEP_TYPE, migrationErrorCode), (Object)this.analyticsEventBuilder.buildErrorOperationalEventForSpaceExport(errorEvent, exportType, migrationProtocol));
        this.analyticsEventService.sendAnalyticsEvents(() -> SpaceExportExecutor.lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$10((List)events));
        return isSloGoodEvent;
    }

    @Override
    public StepType getStepType() {
        return StepType.CONFLUENCE_EXPORT;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        ConfExportStepConfig exportStepConfig = Jsons.readValue(step.getConfig(), ConfExportStepConfig.class);
        String spaceKey = exportStepConfig.getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doExport(exportStepConfig, stepId, Optional.empty()));
    }

    public StepResult runStepV4(String stepId, PrcTask<SpaceExportTransferTask> prcTask) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        ConfExportStepConfig exportStepConfig = Jsons.readValue(step.getConfig(), ConfExportStepConfig.class);
        String spaceKey = exportStepConfig.getSpaceKey();
        return this.wrapStepResultSupplier(this.analyticsEventBuilder, this.analyticsEventService, step, spaceKey, this.spaceManager, () -> this.doExport(exportStepConfig, stepId, Optional.of(prcTask)));
    }

    private static /* synthetic */ Collection lambda$checkIfGoodEventAndSaveAnalyticEventsWhenStepFails$10(List events) {
        return events;
    }

    private static /* synthetic */ Map lambda$exportProcessor$7(Map additionalAttributes) {
        return additionalAttributes;
    }
}

